/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.modularization;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleWithTooManyClassesInspection
extends BaseGlobalInspection {
    public int limit = 100;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("module.with.too.many.classes.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/modularization/ModuleWithTooManyClassesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/modularization/ModuleWithTooManyClassesInspection", "checkElement"));
        }
        if (analysisScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analysisScope", "com/siyeh/ig/modularization/ModuleWithTooManyClassesInspection", "checkElement"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/siyeh/ig/modularization/ModuleWithTooManyClassesInspection", "checkElement"));
        }
        if (globalInspectionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalInspectionContext", "com/siyeh/ig/modularization/ModuleWithTooManyClassesInspection", "checkElement"));
        }
        if (!(refEntity instanceof RefModule)) {
            return null;
        }
        List<RefEntity> children = refEntity.getChildren();
        int numClasses = 0;
        for (RefEntity child : children) {
            if (!(child instanceof RefClass)) continue;
            ++numClasses;
        }
        if (numClasses <= this.limit) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("module.with.too.many.classes.problem.descriptor", refEntity.getName(), numClasses, this.limit);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("module.with.too.many.classes.max.option", new Object[0]), this, "limit", 3);
    }
}

