/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationParser
implements PsiParser {
    @NotNull
    private final IElementType myEolTokenType;
    @NotNull
    private final IElementType myIndentTokenType;
    @NotNull
    private final IElementType myBlockElementType;
    @NotNull
    private final IElementType myDocumentType;
    private final List<IElementType> myContainerTypes;

    public IndentationParser(@NotNull IElementType documentType, @NotNull IElementType blockElementType, @NotNull IElementType eolTokenType, @NotNull IElementType indentTokenType, List<IElementType> containerTypes) {
        if (documentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentType", "com/intellij/indentation/IndentationParser", "<init>"));
        }
        if (blockElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockElementType", "com/intellij/indentation/IndentationParser", "<init>"));
        }
        if (eolTokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eolTokenType", "com/intellij/indentation/IndentationParser", "<init>"));
        }
        if (indentTokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentTokenType", "com/intellij/indentation/IndentationParser", "<init>"));
        }
        this.myDocumentType = documentType;
        this.myBlockElementType = blockElementType;
        this.myEolTokenType = eolTokenType;
        this.myIndentTokenType = indentTokenType;
        this.myContainerTypes = containerTypes;
    }

    public IndentationParser(@NotNull IElementType documentType, @NotNull IElementType blockElementType, @NotNull IElementType eolTokenType, @NotNull IElementType indentTokenType) {
        if (documentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentType", "com/intellij/indentation/IndentationParser", "<init>"));
        }
        if (blockElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockElementType", "com/intellij/indentation/IndentationParser", "<init>"));
        }
        if (eolTokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eolTokenType", "com/intellij/indentation/IndentationParser", "<init>"));
        }
        if (indentTokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentTokenType", "com/intellij/indentation/IndentationParser", "<init>"));
        }
        this(documentType, blockElementType, eolTokenType, indentTokenType, null);
    }

    @Override
    @NotNull
    public final ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker fileMarker = builder.mark();
        ArrayList<PsiBuilder.Marker> containerMarkers = new ArrayList<PsiBuilder.Marker>();
        if (this.myContainerTypes != null) {
            for (IElementType ignored : this.myContainerTypes) {
                PsiBuilder.Marker containerMarker = builder.mark();
                containerMarkers.add(containerMarker);
            }
        }
        PsiBuilder.Marker documentMarker = builder.mark();
        while (builder.getTokenType() == this.myEolTokenType) {
            this.advanceLexer(builder);
        }
        int currentIndent = 0;
        boolean eolSeen = false;
        if (builder.getTokenType() == this.myIndentTokenType) {
            currentIndent = builder.getTokenText().length();
            this.advanceLexer(builder);
        }
        Stack<BlockInfo> stack = new Stack<BlockInfo>();
        stack.push(new BlockInfo(currentIndent, builder.mark(), builder.getTokenType()));
        PsiBuilder.Marker startLineMarker = null;
        while (!builder.eof()) {
            IElementType type = builder.getTokenType();
            if (type == this.myEolTokenType) {
                if (startLineMarker == null) {
                    startLineMarker = builder.mark();
                }
                eolSeen = true;
                currentIndent = 0;
            } else if (type == this.myIndentTokenType) {
                currentIndent = builder.getTokenText().length();
            } else {
                if (!eolSeen && !stack.isEmpty() && currentIndent > 0 && currentIndent < ((BlockInfo)stack.peek()).getIndent()) {
                    eolSeen = true;
                }
                if (this.isCustomTagDelimiter(type)) {
                    builder.advanceLexer();
                    eolSeen = true;
                }
                if (eolSeen) {
                    BlockInfo blockInfo;
                    if (startLineMarker != null) {
                        startLineMarker.rollbackTo();
                        startLineMarker = null;
                    }
                    while (!stack.isEmpty() && currentIndent < ((BlockInfo)stack.peek()).getIndent()) {
                        blockInfo = (BlockInfo)stack.pop();
                        this.closeBlock(builder, blockInfo.getMarker(), blockInfo.getStartTokenType());
                    }
                    if (!stack.isEmpty() && currentIndent >= (blockInfo = (BlockInfo)stack.peek()).getIndent()) {
                        if (currentIndent == blockInfo.getIndent()) {
                            BlockInfo info = (BlockInfo)stack.pop();
                            this.closeBlock(builder, info.getMarker(), info.getStartTokenType());
                        }
                        this.passEOLsAndIndents(builder);
                        stack.push(new BlockInfo(currentIndent, builder.mark(), type));
                    }
                    eolSeen = false;
                    currentIndent = 0;
                }
            }
            this.advanceLexer(builder);
        }
        if (startLineMarker != null) {
            startLineMarker.drop();
        }
        while (!stack.isEmpty()) {
            BlockInfo blockInfo = (BlockInfo)stack.pop();
            this.closeBlock(builder, blockInfo.getMarker(), blockInfo.getStartTokenType());
        }
        documentMarker.done(this.myDocumentType);
        if (this.myContainerTypes != null) {
            for (int i = containerMarkers.size() - 1; i >= 0; --i) {
                PsiBuilder.Marker marker = (PsiBuilder.Marker)containerMarkers.get(i);
                marker.done(this.myContainerTypes.get(i));
            }
        }
        fileMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indentation/IndentationParser", "parse"));
        }
        return aSTNode;
    }

    protected boolean isCustomTagDelimiter(IElementType type) {
        return false;
    }

    protected void closeBlock(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker marker, @Nullable IElementType startTokenType) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/indentation/IndentationParser", "closeBlock"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/indentation/IndentationParser", "closeBlock"));
        }
        marker.done(this.myBlockElementType);
    }

    protected void advanceLexer(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/indentation/IndentationParser", "advanceLexer"));
        }
        builder.advanceLexer();
    }

    private void passEOLsAndIndents(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/indentation/IndentationParser", "passEOLsAndIndents"));
        }
        IElementType tokenType = builder.getTokenType();
        while (tokenType == this.myEolTokenType || tokenType == this.myIndentTokenType) {
            builder.advanceLexer();
            tokenType = builder.getTokenType();
        }
    }

    private static final class BlockInfo {
        private final int myIndent;
        @NotNull
        private final PsiBuilder.Marker myMarker;
        @Nullable
        private final IElementType myStartTokenType;

        private BlockInfo(int indent, @NotNull PsiBuilder.Marker marker, @Nullable IElementType type) {
            if (marker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/indentation/IndentationParser$BlockInfo", "<init>"));
            }
            this.myIndent = indent;
            this.myMarker = marker;
            this.myStartTokenType = type;
        }

        public int getIndent() {
            return this.myIndent;
        }

        @NotNull
        public PsiBuilder.Marker getMarker() {
            PsiBuilder.Marker marker = this.myMarker;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/indentation/IndentationParser$BlockInfo", "getMarker"));
            }
            return marker;
        }

        @Nullable
        public IElementType getStartTokenType() {
            return this.myStartTokenType;
        }
    }
}

