/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class ClassPresentationUtil {
    private ClassPresentationUtil() {
    }

    public static String getNameForClass(@NotNull PsiClass aClass, boolean qualified) {
        String qName;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/presentation/java/ClassPresentationUtil", "getNameForClass"));
        }
        if (aClass instanceof PsiAnonymousClass) {
            if (aClass instanceof PsiEnumConstantInitializer) {
                PsiEnumConstant enumConstant = ((PsiEnumConstantInitializer)aClass).getEnumConstant();
                String name = enumConstant.getName();
                return PsiBundle.message("enum.constant.context", name, ClassPresentationUtil.getContextName(enumConstant, qualified));
            }
            return PsiBundle.message("anonymous.class.context.display", ClassPresentationUtil.getContextName(aClass, qualified));
        }
        if (qualified && (qName = aClass.getQualifiedName()) != null) {
            return qName;
        }
        String className = aClass.getName();
        String contextName = ClassPresentationUtil.getContextName(aClass, qualified);
        return contextName != null ? PsiBundle.message("class.context.display", className, contextName) : className;
    }

    private static String getNameForElement(@NotNull PsiElement element, boolean qualified) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/presentation/java/ClassPresentationUtil", "getNameForElement"));
        }
        if (element instanceof PsiClass) {
            return ClassPresentationUtil.getNameForClass((PsiClass)element, qualified);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String methodName = method.getName();
            return PsiBundle.message("method.context.display", methodName, ClassPresentationUtil.getContextName(method, qualified));
        }
        if (element instanceof PsiClassOwner) {
            return null;
        }
        if (element instanceof PsiFile) {
            return ((PsiFile)element).getName();
        }
        if (element instanceof PsiField) {
            return ((PsiField)element).getName() + " in " + ClassPresentationUtil.getContextName(element, qualified);
        }
        return null;
    }

    public static String getContextName(@NotNull PsiElement element, boolean qualified) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/presentation/java/ClassPresentationUtil", "getContextName"));
        }
        PsiElement parent = PsiTreeUtil.getStubOrPsiParentOfType(element, PsiMember.class);
        if (parent == null) {
            parent = element.getContainingFile();
        }
        while (parent != null) {
            String name = ClassPresentationUtil.getNameForElement(parent, qualified);
            if (name != null) {
                return name;
            }
            if (parent instanceof PsiFile) {
                return null;
            }
            parent = PsiTreeUtil.getStubOrPsiParent(parent);
        }
        return null;
    }

    public static String getFunctionalExpressionPresentation(PsiFunctionalExpression functionalExpression, boolean qualified) {
        Object stub = ((StubBasedPsiElementBase)((Object)functionalExpression)).getGreenStub();
        String lambdaText = stub instanceof FunctionalExpressionStub ? ((FunctionalExpressionStub)stub).getPresentableText() : PsiExpressionTrimRenderer.render(functionalExpression);
        return PsiBundle.message("class.context.display", lambdaText, ClassPresentationUtil.getContextName(functionalExpression, qualified));
    }
}

