/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.StdJobDescriptors;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionToolWrapper
extends InspectionToolWrapper<GlobalInspectionTool, InspectionEP> {
    public GlobalInspectionToolWrapper(@NotNull GlobalInspectionTool globalInspectionTool) {
        if (globalInspectionTool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalInspectionTool", "com/intellij/codeInspection/ex/GlobalInspectionToolWrapper", "<init>"));
        }
        super(globalInspectionTool);
    }

    public GlobalInspectionToolWrapper(@NotNull GlobalInspectionTool tool, @NotNull InspectionEP ep) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/GlobalInspectionToolWrapper", "<init>"));
        }
        if (ep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ep", "com/intellij/codeInspection/ex/GlobalInspectionToolWrapper", "<init>"));
        }
        super(tool, ep);
    }

    public GlobalInspectionToolWrapper(@NotNull InspectionEP ep) {
        if (ep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ep", "com/intellij/codeInspection/ex/GlobalInspectionToolWrapper", "<init>"));
        }
        super(ep);
    }

    private GlobalInspectionToolWrapper(@NotNull GlobalInspectionToolWrapper other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInspection/ex/GlobalInspectionToolWrapper", "<init>"));
        }
        super(other);
    }

    @NotNull
    public GlobalInspectionToolWrapper createCopy() {
        GlobalInspectionToolWrapper globalInspectionToolWrapper = new GlobalInspectionToolWrapper(this);
        if (globalInspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionToolWrapper", "createCopy"));
        }
        return globalInspectionToolWrapper;
    }

    @Override
    public void initialize(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/GlobalInspectionToolWrapper", "initialize"));
        }
        super.initialize(context);
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        RefGraphAnnotator annotator = ((GlobalInspectionTool)this.getTool()).getAnnotator(refManager);
        if (annotator != null) {
            refManager.registerGraphAnnotator(annotator);
        }
        ((GlobalInspectionTool)this.getTool()).initialize(context);
    }

    @Override
    @NotNull
    public JobDescriptor[] getJobDescriptors(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/GlobalInspectionToolWrapper", "getJobDescriptors"));
        }
        GlobalInspectionTool tool = (GlobalInspectionTool)this.getTool();
        JobDescriptor[] additionalJobs = ObjectUtils.notNull(tool.getAdditionalJobs(context), JobDescriptor.EMPTY_ARRAY);
        StdJobDescriptors stdJobDescriptors = context.getStdJobDescriptors();
        if (tool.isGraphNeeded()) {
            JobDescriptor[] jobDescriptorArray = additionalJobs = additionalJobs.length == 0 ? stdJobDescriptors.BUILD_GRAPH_ONLY : ArrayUtil.append(additionalJobs, stdJobDescriptors.BUILD_GRAPH);
        }
        if (tool instanceof GlobalSimpleInspectionTool) {
            JobDescriptor[] jobDescriptorArray = additionalJobs.length == 0 ? stdJobDescriptors.LOCAL_ANALYSIS_ARRAY : (additionalJobs = ArrayUtil.contains(stdJobDescriptors.LOCAL_ANALYSIS, additionalJobs) ? additionalJobs : ArrayUtil.append(additionalJobs, stdJobDescriptors.LOCAL_ANALYSIS));
        }
        if (additionalJobs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/GlobalInspectionToolWrapper", "getJobDescriptors"));
        }
        return additionalJobs;
    }

    public boolean worksInBatchModeOnly() {
        return ((GlobalInspectionTool)this.getTool()).worksInBatchModeOnly();
    }

    @Nullable
    public LocalInspectionToolWrapper getSharedLocalInspectionToolWrapper() {
        LocalInspectionTool sharedTool = ((GlobalInspectionTool)this.getTool()).getSharedLocalInspectionTool();
        if (sharedTool == null) {
            return null;
        }
        return new LocalInspectionToolWrapper(sharedTool);
    }
}

