/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.reference.SoftReference;
import com.intellij.util.JdomKt;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.XMLReader;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u001a\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u001a\u001c\u0010\u0016\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u001a\u0012\u0010\u0017\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0014\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0012\u0010\u0019\u001a\u00020\n*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\f\u0010\u001a\u001a\u00020\u001b*\u0004\u0018\u00010\n\u001aA\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\u0004\b\u0000\u0010\u001e*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b!\u0012\b\b\u0013\u0012\u0004\b\b(\"\u0012\u0004\u0012\u0002H\u001e0 \u001a\n\u0010#\u001a\u00020$*\u00020\n\u001a\u001e\u0010%\u001a\u00020\u0012*\u00020&2\u0006\u0010'\u001a\u00020\u000e2\b\b\u0002\u0010(\u001a\u00020\u0014H\u0007\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"cachedSaxBuilder", "Ljava/lang/ThreadLocal;", "Lcom/intellij/reference/SoftReference;", "Lorg/jdom/input/SAXBuilder;", "getSaxBuilder", "loadDocument", "Lorg/jdom/Document;", "reader", "Ljava/io/Reader;", "loadElement", "Lorg/jdom/Element;", "stream", "Ljava/io/InputStream;", "path", "Ljava/nio/file/Path;", "chars", "", "addOptionTag", "", "name", "", "value", "attribute", "element", "get", "getOrCreate", "isEmpty", "", "remove", "", "T", "transform", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "child", "toByteArray", "", "write", "Lorg/jdom/Parent;", "file", "lineSeparator", "projectModel-api"})
public final class JdomKt {
    private static final ThreadLocal<SoftReference<SAXBuilder>> cachedSaxBuilder = new ThreadLocal();

    private static final SAXBuilder getSaxBuilder() {
        SoftReference<SAXBuilder> reference = cachedSaxBuilder.get();
        SAXBuilder saxBuilder = (SAXBuilder)SoftReference.dereference(reference);
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder(){

                protected void configureParser(@NotNull XMLReader parser, @Nullable SAXHandler contentHandler) {
                    Intrinsics.checkParameterIsNotNull((Object)parser, (String)"parser");
                    super.configureParser(parser, contentHandler);
                    try {
                        parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            (saxBuilder).setIgnoringBoundaryWhitespace(true);
            (saxBuilder).setIgnoringElementContentWhitespace(true);
            (saxBuilder).setEntityResolver(getSaxBuilder.2.INSTANCE);
            cachedSaxBuilder.set(new SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public static final void write(@NotNull Parent $receiver, @NotNull Path file, @NotNull String lineSeparator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
        Closeable closeable = new BufferedOutputStream(PathKt.outputStream(file));
        boolean bl = false;
        try {
            BufferedOutputStream it = (BufferedOutputStream)closeable;
            JDOMUtil.write($receiver, it, lineSeparator);
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception exception) {
            bl = true;
            try {
                closeable.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                closeable.close();
            }
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void write$default(Parent parent, Path path, String string, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string = "\n";
        }
        JdomKt.write(parent, path, string);
    }

    @JvmOverloads
    public static final void write(@NotNull Parent $receiver, @NotNull Path file) throws IOException {
        JdomKt.write$default($receiver, file, null, 2, null);
    }

    @NotNull
    public static final Element loadElement(@NotNull CharSequence chars) throws IOException, JDOMException {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        return JdomKt.loadElement(new CharSequenceReader(chars));
    }

    @NotNull
    public static final Element loadElement(@NotNull Reader reader) throws IOException, JDOMException {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Element element = JdomKt.loadDocument(reader).detachRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"loadDocument(reader).detachRootElement()");
        return element;
    }

    @NotNull
    public static final Element loadElement(@NotNull InputStream stream) throws IOException, JDOMException {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        InputStream inputStream = stream;
        Charset charset = null;
        boolean bl = true;
        Object var4_4 = null;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        Element element = JdomKt.loadDocument(new InputStreamReader(inputStream, charset)).detachRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"loadDocument(stream.reader()).detachRootElement()");
        return element;
    }

    @NotNull
    public static final Element loadElement(@NotNull Path path) throws IOException, JDOMException {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        InputStream inputStream = PathKt.inputStream(path);
        Charset charset = null;
        boolean bl = true;
        Closeable closeable = null;
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        closeable = inputStream;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        int n = 0;
        boolean bl2 = true;
        Object var7_7 = null;
        if (bl2 & true) {
            n = 8192;
        }
        Element element = JdomKt.loadDocument(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)).detachRootElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"loadDocument(path.inputS\u2026er()).detachRootElement()");
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Document loadDocument(Reader reader) {
        Document document;
        Closeable closeable = reader;
        boolean bl = false;
        try {
            Reader it = (Reader)closeable;
            Document document2 = JdomKt.getSaxBuilder().build(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"getSaxBuilder().build(it)");
            Document document3 = document2;
            document = document3;
        }
        catch (Exception exception) {
            bl = true;
            try {
                Closeable closeable2 = closeable;
                if (closeable2 != null) {
                    closeable2.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw (Throwable)exception;
        }
        finally {
            if (!bl) {
                Closeable closeable3 = closeable;
                if (closeable3 != null) {
                    closeable3.close();
                }
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"reader.use { getSaxBuilder().build(it) }");
        return document;
    }

    public static final boolean isEmpty(@Nullable Element $receiver) {
        return $receiver == null || JDOMUtil.isEmpty($receiver);
    }

    @NotNull
    public static final Element getOrCreate(@NotNull Element $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Element element = $receiver.getChild(name);
        if (element == null) {
            element = new Element(name);
            $receiver.addContent(element);
        }
        return element;
    }

    @Nullable
    public static final Element get(@NotNull Element $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return $receiver.getChild(name);
    }

    @NotNull
    public static final Element element(@NotNull Element $receiver, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Element element = new Element(name);
        $receiver.addContent(element);
        return element;
    }

    @NotNull
    public static final Element attribute(@NotNull Element $receiver, @NotNull String name, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Element element = $receiver.setAttribute(name, value);
        Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"setAttribute(name, value)");
        return element;
    }

    @NotNull
    public static final <T> List<T> remove(@NotNull Element $receiver, @NotNull String name, @NotNull Function1<? super Element, ? extends T> transform) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(transform, (String)"transform");
        SmartList<Object> result = new SmartList<Object>();
        Iterator groupIterator = $receiver.getContent((Filter)new ElementFilter(name)).iterator();
        while (groupIterator.hasNext()) {
            Element child;
            Element element = child = (Element)groupIterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"child");
            result.add(transform.invoke((Object)element));
            groupIterator.remove();
        }
        return result;
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull Element $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(512);
        JDOMUtil.write((Parent)$receiver, out, "\n");
        byte[] byArray = out.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"out.toByteArray()");
        return byArray;
    }

    public static final void addOptionTag(@NotNull Element $receiver, @NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Element element = new Element("option");
        element.setAttribute("name", name);
        element.setAttribute("value", value);
        $receiver.addContent(element);
    }
}

