/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import one.util.streamex.StreamEx;

public class FunctionalExpressionUtils {
    public static boolean isFunctionalReferenceTo(PsiExpression expression, String className, PsiType returnType, String methodName, PsiType ... parameterTypes) {
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expression;
            if (!methodName.equals(methodRef.getReferenceName())) {
                return false;
            }
            PsiMethod method = ObjectUtils.tryCast(methodRef.resolve(), PsiMethod.class);
            PsiReferenceExpression ref = ObjectUtils.tryCast(methodRef.getQualifier(), PsiReferenceExpression.class);
            return ref != null && method != null && MethodUtils.methodMatches(method, className, returnType, methodName, parameterTypes) && ref.isReferenceTo(method.getContainingClass());
        }
        if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression;
            PsiExpression body = PsiUtil.skipParenthesizedExprDown(LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody()));
            PsiMethodCallExpression call = ObjectUtils.tryCast(body, PsiMethodCallExpression.class);
            if (call == null || !MethodCallUtils.isCallToMethod(call, className, returnType, methodName, parameterTypes)) {
                return false;
            }
            Object[] parameters = lambda2.getParameterList().getParameters();
            Object[] args = call.getArgumentList().getExpressions();
            PsiMethod method = call.resolveMethod();
            if (method != null && !method.hasModifierProperty("static")) {
                args = ArrayUtil.prepend(call.getMethodExpression().getQualifierExpression(), args);
            }
            if (parameters.length != args.length || StreamEx.zip((Object[])args, (Object[])parameters, ExpressionUtils::isReferenceTo).has((Object)false)) {
                return false;
            }
            return MethodCallUtils.isCallToMethod(call, className, returnType, methodName, parameterTypes);
        }
        return false;
    }
}

