/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldAccessNotGuardedInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unguarded field access" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "getDisplayName"));
        }
        return "Unguarded field access";
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("FieldAccessNotGuarded" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "getShortName"));
        }
        return "FieldAccessNotGuarded";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static boolean isCallOnGuard(String guard, String lockMethodStart, PsiMethodCallExpression psiExpression) {
        PsiReferenceExpression methodExpression = psiExpression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression != null) {
            PsiElement resolve;
            if (FieldAccessNotGuardedInspection.isCallOnGuard(guard, lockMethodStart, methodExpression, qualifierExpression)) {
                return true;
            }
            if (qualifierExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final")) {
                PsiExpression initializer = ((PsiField)resolve).getInitializer();
                return initializer != null && FieldAccessNotGuardedInspection.isCallOnGuard(guard, lockMethodStart, methodExpression, initializer);
            }
        }
        return false;
    }

    private static boolean isCallOnGuard(String guard, String lockMethodStart, PsiReferenceExpression methodExpression, PsiExpression qualifier) {
        String methodName;
        PsiElement resolve;
        String qualifierText = qualifier.getText();
        return (qualifierText.startsWith(guard + ".") || qualifierText.equals(guard)) && (resolve = methodExpression.resolve()) instanceof PsiMethod && (methodName = ((PsiMethod)resolve).getName()).startsWith(lockMethodStart);
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiSynchronizedStatement syncStatement;
            PsiExpression guardExpression;
            PsiElement parent = PsiTreeUtil.skipParentsOfType(expression, PsiParenthesizedExpression.class);
            if (parent instanceof PsiSynchronizedStatement) {
                return;
            }
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            String guard = JCiPUtil.findGuardForMember(field);
            if (guard == null) {
                return;
            }
            try {
                guardExpression = JavaPsiFacade.getElementFactory(expression.getProject()).createExpressionFromText(guard, field);
            }
            catch (IncorrectOperationException ignore) {
                return;
            }
            if (guardExpression instanceof PsiThisExpression && !PsiUtil.isAccessedForWriting(expression) && field.hasModifierProperty("volatile")) {
                return;
            }
            PsiMethod containingMethod = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (containingMethod != null) {
                PsiThisExpression thisExpression;
                PsiClass aClass;
                if (JCiPUtil.isGuardedBy((PsiMember)containingMethod, guard) || containingMethod.isConstructor()) {
                    return;
                }
                if (containingMethod.hasModifierProperty("synchronized") && guardExpression instanceof PsiThisExpression && ((aClass = Visitor.getClassFromThisExpression(thisExpression = (PsiThisExpression)guardExpression, field)) == null || aClass.equals(containingMethod.getContainingClass()))) {
                    return;
                }
            }
            if (Visitor.findLockTryStatement(expression, guard) != null) {
                for (PsiElement lockExpr = expression; lockExpr != null; lockExpr = lockExpr.getParent()) {
                    for (PsiElement child = lockExpr; child != null; child = child.getPrevSibling()) {
                        if (Visitor.isLockGuardStatement(guard, child, "lock")) {
                            return;
                        }
                        PsiElement childParent = child.getParent();
                        if (!(child instanceof PsiMethodCallExpression) || !FieldAccessNotGuardedInspection.isCallOnGuard(guard, "tryLock", (PsiMethodCallExpression)child) || !(childParent instanceof PsiIfStatement) || ((PsiIfStatement)childParent).getCondition() != child) continue;
                        return;
                    }
                }
            }
            PsiElement check = expression;
            while ((syncStatement = PsiTreeUtil.getParentOfType(check, PsiSynchronizedStatement.class)) != null) {
                PsiClass aClass2;
                PsiClass aClass1;
                PsiExpression lockExpression = PsiUtil.skipParenthesizedExprDown(syncStatement.getLockExpression());
                if (lockExpression == null) continue;
                if (guardExpression instanceof PsiThisExpression) {
                    PsiExpression qualifierExpression;
                    if (lockExpression instanceof PsiThisExpression) {
                        PsiThisExpression thisExpression1 = (PsiThisExpression)guardExpression;
                        PsiThisExpression thisExpression2 = (PsiThisExpression)lockExpression;
                        aClass1 = Visitor.getClassFromThisExpression(thisExpression1, field);
                        aClass2 = Visitor.getClassFromThisExpression(thisExpression2, expression);
                        if (aClass1 == null || aClass1.equals(aClass2)) {
                            return;
                        }
                    } else if (lockExpression instanceof PsiReferenceExpression && (qualifierExpression = expression.getQualifierExpression()) != null && PsiEquivalenceUtil.areElementsEquivalent(lockExpression, qualifierExpression)) {
                        return;
                    }
                } else if (guardExpression instanceof PsiReferenceExpression && lockExpression instanceof PsiReferenceExpression) {
                    PsiReferenceExpression referenceExpression1 = (PsiReferenceExpression)guardExpression;
                    PsiReferenceExpression referenceExpression2 = (PsiReferenceExpression)lockExpression;
                    PsiElement target1 = referenceExpression1.resolve();
                    PsiElement target2 = referenceExpression2.resolve();
                    if (target1 == null || target1.equals(target2)) {
                        PsiExpression lockQualifier = referenceExpression2.getQualifierExpression();
                        if (referenceExpression1.getQualifierExpression() != null || lockQualifier == null) return;
                        PsiExpression qualifierExpression = expression.getQualifierExpression();
                        if (qualifierExpression != null && PsiEquivalenceUtil.areElementsEquivalent(lockQualifier, qualifierExpression)) {
                            return;
                        }
                    }
                } else if (guardExpression instanceof PsiMethodCallExpression && lockExpression instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCallExpression1 = (PsiMethodCallExpression)guardExpression;
                    PsiMethodCallExpression methodCallExpression2 = (PsiMethodCallExpression)lockExpression;
                    if (methodCallExpression2.getArgumentList().getExpressions().length == 0) {
                        PsiMethod method1 = methodCallExpression1.resolveMethod();
                        PsiMethod method2 = methodCallExpression2.resolveMethod();
                        if (method1 == null || method1.equals(method2)) {
                            PsiReferenceExpression methodExpression2 = methodCallExpression2.getMethodExpression();
                            PsiExpression qualifierExpression1 = expression.getQualifierExpression();
                            PsiExpression qualifierExpression2 = methodExpression2.getQualifierExpression();
                            if (qualifierExpression1 == null && qualifierExpression2 == null) {
                                return;
                            }
                            if (qualifierExpression1 != null && qualifierExpression2 != null && PsiEquivalenceUtil.areElementsEquivalent(qualifierExpression1, qualifierExpression2)) {
                                return;
                            }
                        }
                    }
                } else if (guardExpression instanceof PsiClassObjectAccessExpression && lockExpression instanceof PsiClassObjectAccessExpression) {
                    PsiClassObjectAccessExpression classObjectAccessExpression1 = (PsiClassObjectAccessExpression)guardExpression;
                    PsiClassObjectAccessExpression classObjectAccessExpression2 = (PsiClassObjectAccessExpression)lockExpression;
                    aClass1 = PsiUtil.resolveClassInClassTypeOnly(classObjectAccessExpression1.getOperand().getType());
                    aClass2 = PsiUtil.resolveClassInClassTypeOnly(classObjectAccessExpression2.getOperand().getType());
                    if (aClass1 == null || aClass1.equals(aClass2)) {
                        return;
                    }
                }
                check = syncStatement;
            }
            this.myHolder.registerProblem((PsiElement)expression, "Access to field <code>#ref</code> outside of declared guards #loc", new LocalQuickFix[0]);
        }

        private static PsiClass getClassFromThisExpression(PsiThisExpression thisExpression, PsiElement context) {
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            if (qualifier == null) {
                return PsiTreeUtil.getParentOfType(context, PsiClass.class);
            }
            PsiElement target = qualifier.resolve();
            return target instanceof PsiClass ? (PsiClass)target : null;
        }

        @Nullable
        private static PsiTryStatement findLockTryStatement(PsiReferenceExpression expression, String guard) {
            PsiTryStatement tryStatement = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiTryStatement.class);
            while (tryStatement != null) {
                PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
                if (finallyBlock != null) {
                    for (PsiStatement psiStatement : finallyBlock.getStatements()) {
                        if (!Visitor.isLockGuardStatement(guard, psiStatement, "unlock")) continue;
                        return tryStatement;
                    }
                }
                tryStatement = PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiTryStatement.class);
            }
            return null;
        }

        private static boolean isLockGuardStatement(String guard, PsiElement element, String lockMethodStart) {
            PsiExpression psiExpression;
            if (element instanceof PsiExpressionStatement && (psiExpression = ((PsiExpressionStatement)element).getExpression()) instanceof PsiMethodCallExpression) {
                return FieldAccessNotGuardedInspection.isCallOnGuard(guard, lockMethodStart, (PsiMethodCallExpression)psiExpression);
            }
            return false;
        }
    }
}

