/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lang.HtmlInlineScriptTokenTypesProvider;
import com.intellij.lang.HtmlScriptContentProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageHtmlInlineScriptTokenTypesProvider;
import com.intellij.lexer.BaseHtmlLexer;
import com.intellij.lexer.EmbedmentLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.lexer._HtmlLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlHighlightingLexer
extends BaseHtmlLexer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.lexer.HtmlHighlightingLexer");
    private static final int EMBEDDED_LEXER_ON = 2048;
    private static final int EMBEDDED_LEXER_STATE_SHIFT = 12;
    private static final FileType ourInlineScriptFileType;
    private final FileType ourStyleFileType;
    protected Lexer elLexer;
    private Lexer embeddedLexer;
    private final Map<String, Lexer> scriptLexers = new HashMap<String, Lexer>();
    private final Map<String, Lexer> styleLexers = new HashMap<String, Lexer>();
    private boolean hasNoEmbeddments;

    public HtmlHighlightingLexer() {
        this((FileType)null);
    }

    public HtmlHighlightingLexer(FileType styleFileType) {
        this(new MergingLexerAdapter(new FlexAdapter(new _HtmlLexer()), TOKENS_TO_MERGE), true, styleFileType);
    }

    protected HtmlHighlightingLexer(Lexer lexer, boolean caseInsensitive, FileType styleFileType) {
        super(lexer, caseInsensitive);
        this.ourStyleFileType = styleFileType;
        XmlEmbeddmentHandler value = new XmlEmbeddmentHandler();
        this.registerHandler(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, value);
        this.registerHandler(XmlTokenType.XML_DATA_CHARACTERS, value);
        this.registerHandler(XmlTokenType.XML_COMMENT_CHARACTERS, value);
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/lexer/HtmlHighlightingLexer", "start"));
        }
        super.start(buffer, startOffset, endOffset, initialState);
        if ((initialState & 0x800) != 0) {
            int state = initialState >> 12;
            this.setEmbeddedLexer();
            LOG.assertTrue(this.embeddedLexer != null);
            this.embeddedLexer.start(buffer, startOffset, this.skipToTheEndOfTheEmbeddment(), state);
        } else {
            this.embeddedLexer = null;
            this.scriptLexers.clear();
            this.styleLexers.clear();
        }
    }

    private void setEmbeddedLexer() {
        Lexer newLexer = null;
        if (this.hasSeenStyle()) {
            Lexer styleLexer = this.styleLexers.get(this.styleType);
            if (styleLexer == null) {
                if (this.hasSeenTag()) {
                    IElementType currentStylesheetElementType = this.getCurrentStylesheetElementType();
                    if (currentStylesheetElementType != null) {
                        Language language = currentStylesheetElementType.getLanguage();
                        styleLexer = SyntaxHighlighterFactory.getSyntaxHighlighter(language, null, null).getHighlightingLexer();
                    } else if (this.ourStyleFileType != null) {
                        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(this.ourStyleFileType, null, null);
                        LOG.assertTrue(highlighter != null, this.ourStyleFileType);
                        styleLexer = highlighter.getHighlightingLexer();
                    } else {
                        styleLexer = null;
                    }
                    this.styleLexers.put(this.styleType, styleLexer);
                } else if (this.hasSeenAttribute()) {
                    if (this.ourStyleFileType == null) {
                        styleLexer = null;
                    } else {
                        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(this.ourStyleFileType, null, null);
                        LOG.assertTrue(highlighter != null, this.ourStyleFileType);
                        styleLexer = highlighter.getHighlightingLexer();
                    }
                }
            }
            newLexer = styleLexer;
        } else if (this.hasSeenScript()) {
            Lexer scriptLexer = this.scriptLexers.get(this.scriptType);
            if (scriptLexer == null) {
                if (this.hasSeenTag()) {
                    HtmlScriptContentProvider provider = this.findScriptContentProvider(this.scriptType);
                    scriptLexer = provider != null ? provider.getHighlightingLexer() : SyntaxHighlighterFactory.getSyntaxHighlighter(PlainTextLanguage.INSTANCE, null, null).getHighlightingLexer();
                } else if (this.hasSeenAttribute()) {
                    SyntaxHighlighter syntaxHighlighter = ourInlineScriptFileType != null ? SyntaxHighlighterFactory.getSyntaxHighlighter(ourInlineScriptFileType, null, null) : null;
                    scriptLexer = syntaxHighlighter != null ? syntaxHighlighter.getHighlightingLexer() : null;
                }
                this.scriptLexers.put(this.scriptType, scriptLexer);
            }
            newLexer = scriptLexer;
        } else {
            newLexer = this.createELLexer(newLexer);
        }
        if (newLexer != null) {
            this.embeddedLexer = newLexer;
        }
    }

    @Nullable
    protected Lexer createELLexer(Lexer newLexer) {
        return newLexer;
    }

    @Override
    public void advance() {
        if (this.embeddedLexer != null) {
            this.embeddedLexer.advance();
            if (this.embeddedLexer.getTokenType() == null) {
                this.embeddedLexer = null;
            }
        }
        if (this.embeddedLexer == null) {
            super.advance();
        }
    }

    @Override
    public IElementType getTokenType() {
        int state;
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenType();
        }
        IElementType tokenType = super.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType == XmlTokenType.XML_NAME) {
            int state2 = this.getState() & 0x3F;
            if (this.isHtmlTagState(state2)) {
                tokenType = XmlTokenType.XML_TAG_NAME;
            }
        } else if (tokenType == XmlTokenType.XML_WHITE_SPACE || tokenType == XmlTokenType.XML_REAL_WHITE_SPACE) {
            tokenType = this.hasSeenTag() && (this.hasSeenStyle() || this.hasSeenScript()) ? XmlTokenType.XML_WHITE_SPACE : (this.getState() != 0 ? XmlTokenType.TAG_WHITE_SPACE : XmlTokenType.XML_REAL_WHITE_SPACE);
        } else if ((tokenType == XmlTokenType.XML_CHAR_ENTITY_REF || tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN) && (state = this.getState() & 0x3F) == 4) {
            return XmlTokenType.XML_COMMENT_CHARACTERS;
        }
        return tokenType;
    }

    @Override
    public int getTokenStart() {
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenStart();
        }
        return super.getTokenStart();
    }

    @Override
    public int getTokenEnd() {
        if (this.embeddedLexer != null) {
            return this.embeddedLexer.getTokenEnd();
        }
        return super.getTokenEnd();
    }

    @Override
    public int getState() {
        int state = super.getState();
        state |= this.embeddedLexer != null ? 2048 : 0;
        if (this.embeddedLexer != null) {
            state |= this.embeddedLexer.getState() << 12;
        }
        return state;
    }

    @Override
    protected boolean isHtmlTagState(int state) {
        return state == 6 || state == 8 || state == 22 || state == 24;
    }

    public void setHasNoEmbeddments(boolean hasNoEmbeddments) {
        this.hasNoEmbeddments = hasNoEmbeddments;
    }

    static {
        HtmlInlineScriptTokenTypesProvider provider = LanguageHtmlInlineScriptTokenTypesProvider.getInlineScriptProvider(Language.findLanguageByID("JavaScript"));
        ourInlineScriptFileType = provider != null ? provider.getFileType() : null;
    }

    public class ElEmbeddmentHandler
    implements BaseHtmlLexer.TokenHandler {
        @Override
        public void handleElement(Lexer lexer) {
            HtmlHighlightingLexer.this.setEmbeddedLexer();
            if (HtmlHighlightingLexer.this.embeddedLexer != null) {
                HtmlHighlightingLexer.this.embeddedLexer.start(HtmlHighlightingLexer.this.getBufferSequence(), HtmlHighlightingLexer.super.getTokenStart(), HtmlHighlightingLexer.super.getTokenEnd());
            }
        }
    }

    public class XmlEmbeddmentHandler
    implements BaseHtmlLexer.TokenHandler {
        @Override
        public void handleElement(Lexer lexer) {
            if (!HtmlHighlightingLexer.this.hasSeenStyle() && !HtmlHighlightingLexer.this.hasSeenScript() || HtmlHighlightingLexer.this.hasNoEmbeddments) {
                return;
            }
            IElementType tokenType = lexer.getTokenType();
            if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && HtmlHighlightingLexer.this.hasSeenAttribute() || tokenType == XmlTokenType.XML_DATA_CHARACTERS && HtmlHighlightingLexer.this.hasSeenTag() || tokenType == XmlTokenType.XML_COMMENT_CHARACTERS && HtmlHighlightingLexer.this.hasSeenTag()) {
                HtmlHighlightingLexer.this.setEmbeddedLexer();
                if (HtmlHighlightingLexer.this.embeddedLexer != null) {
                    HtmlHighlightingLexer.this.embeddedLexer.start(HtmlHighlightingLexer.this.getBufferSequence(), HtmlHighlightingLexer.super.getTokenStart(), HtmlHighlightingLexer.this.skipToTheEndOfTheEmbeddment(), HtmlHighlightingLexer.this.embeddedLexer instanceof EmbedmentLexer ? ((EmbedmentLexer)((Object)HtmlHighlightingLexer.this.embeddedLexer)).getEmbeddedInitialState(tokenType) : 0);
                    if (HtmlHighlightingLexer.this.embeddedLexer.getTokenType() == null) {
                        HtmlHighlightingLexer.this.embeddedLexer = null;
                    }
                }
            }
        }
    }
}

