/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagUtil
extends XmlTagUtilBase {
    private static final Map<String, Character> ourCharacterEntities = new HashMap<String, Character>();

    public static String getCDATAQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&\n";
        int textLength = text.length();
        if (textLength > 0 && (Character.isWhitespace(text.charAt(0)) || Character.isWhitespace(text.charAt(textLength - 1)))) {
            return "<![CDATA[" + text + "]]>";
        }
        for (int i2 = 0; i2 < offensiveChars.length(); ++i2) {
            char c = offensiveChars.charAt(i2);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static String getInlineQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&";
        for (int i2 = 0; i2 < offensiveChars.length(); ++i2) {
            char c = offensiveChars.charAt(i2);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static CharSequence composeTagText(@NonNls String tagName, @NonNls String tagValue) {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(tagName);
        if (StringUtil.isEmpty(tagValue)) {
            builder.append("/>");
        } else {
            builder.append('>').append(XmlTagUtil.getCDATAQuote(tagValue)).append("</").append(tagName).append('>');
        }
        return builder;
    }

    public static String[] getCharacterEntityNames() {
        Set<String> strings = ourCharacterEntities.keySet();
        return ArrayUtil.toStringArray(strings);
    }

    public static Character getCharacterByEntityName(String entityName) {
        return ourCharacterEntities.get(entityName);
    }

    @Nullable
    public static XmlToken getStartTagNameElement(@NotNull XmlTag tag) {
        IElementType elementType;
        ASTNode current;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/XmlTagUtil", "getStartTagNameElement"));
        }
        ASTNode node = tag.getNode();
        if (node == null) {
            return null;
        }
        for (current = node.getFirstChildNode(); current != null && (elementType = current.getElementType()) != XmlTokenType.XML_NAME && elementType != XmlTokenType.XML_TAG_NAME; current = current.getTreeNext()) {
        }
        return current == null ? null : (XmlToken)current.getPsi();
    }

    @Nullable
    public static XmlToken getEndTagNameElement(@NotNull XmlTag tag) {
        ASTNode current;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/XmlTagUtil", "getEndTagNameElement"));
        }
        ASTNode node = tag.getNode();
        if (node == null) {
            return null;
        }
        ASTNode prev = current = node.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current;
            current = current.getTreePrev();
        }
        return null;
    }

    @NotNull
    public static TextRange getTrimmedValueRange(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/XmlTagUtil", "getTrimmedValueRange"));
        }
        XmlTagValue tagValue = tag.getValue();
        String text = tagValue.getText();
        String trimmed = text.trim();
        int index = text.indexOf(trimmed);
        int startOffset = tagValue.getTextRange().getStartOffset() - tag.getTextRange().getStartOffset() + index;
        TextRange textRange = new TextRange(startOffset, startOffset + trimmed.length());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlTagUtil", "getTrimmedValueRange"));
        }
        return textRange;
    }

    @Nullable
    public static TextRange getStartTagRange(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/XmlTagUtil", "getStartTagRange"));
        }
        XmlToken tagName = XmlTagUtil.getStartTagNameElement(tag);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_START_TAG_START);
    }

    @Nullable
    public static TextRange getEndTagRange(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/xml/util/XmlTagUtil", "getEndTagRange"));
        }
        XmlToken tagName = XmlTagUtil.getEndTagNameElement(tag);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_END_TAG_START);
    }

    @Nullable
    private static TextRange getTagRange(@Nullable XmlToken tagName, IElementType tagStart) {
        PsiElement f;
        PsiElement s;
        if (tagName == null) {
            return null;
        }
        for (s = tagName.getPrevSibling(); s != null && s.getNode().getElementType() != tagStart; s = s.getPrevSibling()) {
        }
        for (f = tagName.getNextSibling(); f != null && f.getNode().getElementType() != XmlTokenType.XML_TAG_END && f.getNode().getElementType() != XmlTokenType.XML_EMPTY_ELEMENT_END; f = f.getNextSibling()) {
        }
        if (s != null && f != null) {
            return new TextRange(s.getTextRange().getStartOffset(), f.getTextRange().getEndOffset());
        }
        return null;
    }

    static {
        ourCharacterEntities.put("lt", Character.valueOf('<'));
        ourCharacterEntities.put("gt", Character.valueOf('>'));
        ourCharacterEntities.put("apos", Character.valueOf('\''));
        ourCharacterEntities.put("quot", Character.valueOf('\"'));
        ourCharacterEntities.put("nbsp", Character.valueOf('\u00a0'));
        ourCharacterEntities.put("amp", Character.valueOf('&'));
    }
}

