/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class SyntheticLibrary {
    @NotNull
    public abstract Collection<VirtualFile> getSourceRoots();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @NotNull
    public static SyntheticLibrary newImmutableLibrary(final @NotNull Collection<VirtualFile> sourceRoots) {
        if (sourceRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        SyntheticLibrary syntheticLibrary = new SyntheticLibrary(){

            @Override
            @NotNull
            public Collection<VirtualFile> getSourceRoots() {
                Collection collection = sourceRoots;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary$1", "getSourceRoots"));
                }
                return collection;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SyntheticLibrary library = (SyntheticLibrary)o;
                return this.getSourceRoots().equals(library.getSourceRoots());
            }

            @Override
            public int hashCode() {
                return sourceRoots.hashCode();
            }
        };
        if (syntheticLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/SyntheticLibrary", "newImmutableLibrary"));
        }
        return syntheticLibrary;
    }
}

