/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariableAssignedFromVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean assignedFrom;
    @NotNull
    private final PsiVariable variable;

    public VariableAssignedFromVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariableAssignedFromVisitor", "<init>"));
        }
        this.assignedFrom = false;
        this.variable = variable;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariableAssignedFromVisitor", "visitElement"));
        }
        if (!this.assignedFrom) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/siyeh/ig/psiutils/VariableAssignedFromVisitor", "visitAssignmentExpression"));
        }
        if (this.assignedFrom) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression arg = assignment.getRExpression();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assignedFrom = true;
        }
    }

    @Override
    public void visitVariable(@NotNull PsiVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/siyeh/ig/psiutils/VariableAssignedFromVisitor", "visitVariable"));
        }
        if (this.assignedFrom) {
            return;
        }
        super.visitVariable(var);
        PsiExpression initializer = var.getInitializer();
        if (VariableAccessUtils.mayEvaluateToVariable(initializer, this.variable)) {
            this.assignedFrom = true;
        }
    }

    public boolean isAssignedFrom() {
        return this.assignedFrom;
    }
}

