/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.svg;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.UpdateManager;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherEvent;
import org.apache.batik.swing.svg.SVGLoadEventDispatcherListener;
import org.apache.batik.util.EventDispatcher;
import org.apache.batik.util.HaltingThread;
import org.w3c.dom.svg.SVGDocument;

public class SVGLoadEventDispatcher
extends HaltingThread {
    protected SVGDocument svgDocument;
    protected GraphicsNode root;
    protected BridgeContext bridgeContext;
    protected UpdateManager updateManager;
    protected List listeners = Collections.synchronizedList(new LinkedList());
    protected Exception exception;
    static EventDispatcher.Dispatcher startedDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object object, Object object2) {
            ((SVGLoadEventDispatcherListener)object).svgLoadEventDispatchStarted((SVGLoadEventDispatcherEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher completedDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object object, Object object2) {
            ((SVGLoadEventDispatcherListener)object).svgLoadEventDispatchCompleted((SVGLoadEventDispatcherEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher cancelledDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object object, Object object2) {
            ((SVGLoadEventDispatcherListener)object).svgLoadEventDispatchCancelled((SVGLoadEventDispatcherEvent)object2);
        }
    };
    static EventDispatcher.Dispatcher failedDispatcher = new EventDispatcher.Dispatcher(){

        @Override
        public void dispatch(Object object, Object object2) {
            ((SVGLoadEventDispatcherListener)object).svgLoadEventDispatchFailed((SVGLoadEventDispatcherEvent)object2);
        }
    };

    public SVGLoadEventDispatcher(GraphicsNode graphicsNode, SVGDocument sVGDocument, BridgeContext bridgeContext, UpdateManager updateManager) {
        this.svgDocument = sVGDocument;
        this.root = graphicsNode;
        this.bridgeContext = bridgeContext;
        this.updateManager = updateManager;
    }

    @Override
    public void run() {
        SVGLoadEventDispatcherEvent sVGLoadEventDispatcherEvent = new SVGLoadEventDispatcherEvent(this, this.root);
        try {
            this.fireEvent(startedDispatcher, sVGLoadEventDispatcherEvent);
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, sVGLoadEventDispatcherEvent);
                return;
            }
            this.updateManager.dispatchSVGLoadEvent();
            if (this.isHalted()) {
                this.fireEvent(cancelledDispatcher, sVGLoadEventDispatcherEvent);
                return;
            }
            this.fireEvent(completedDispatcher, sVGLoadEventDispatcherEvent);
        }
        catch (InterruptedException interruptedException) {
            this.fireEvent(cancelledDispatcher, sVGLoadEventDispatcherEvent);
        }
        catch (InterruptedBridgeException interruptedBridgeException) {
            this.fireEvent(cancelledDispatcher, sVGLoadEventDispatcherEvent);
        }
        catch (Exception exception) {
            this.exception = exception;
            this.fireEvent(failedDispatcher, sVGLoadEventDispatcherEvent);
        }
        catch (ThreadDeath threadDeath) {
            this.exception = new Exception(threadDeath.getMessage());
            this.fireEvent(failedDispatcher, sVGLoadEventDispatcherEvent);
            throw threadDeath;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.exception = new Exception(throwable.getMessage());
            this.fireEvent(failedDispatcher, sVGLoadEventDispatcherEvent);
        }
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    public Exception getException() {
        return this.exception;
    }

    public void addSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.listeners.add(sVGLoadEventDispatcherListener);
    }

    public void removeSVGLoadEventDispatcherListener(SVGLoadEventDispatcherListener sVGLoadEventDispatcherListener) {
        this.listeners.remove(sVGLoadEventDispatcherListener);
    }

    public void fireEvent(EventDispatcher.Dispatcher dispatcher, Object object) {
        EventDispatcher.fireEvent(dispatcher, this.listeners, object, true);
    }
}

