/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PossibleHeapPollutionVarargsInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance("#" + PossibleHeapPollutionVarargsInspection.class.getName());

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Possible heap pollution from parameterized vararg type" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "getDisplayName"));
        }
        return "Possible heap pollution from parameterized vararg type";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("SafeVarargsDetector" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "getShortName"));
        }
        return "SafeVarargsDetector";
    }

    @Override
    @NotNull
    public String getID() {
        if ("unchecked" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "getID"));
        }
        return "unchecked";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "buildVisitor"));
        }
        HeapPollutionVisitor heapPollutionVisitor = new HeapPollutionVisitor(){

            @Override
            protected void registerProblem(PsiMethod method, PsiIdentifier nameIdentifier) {
                LocalQuickFix quickFix;
                if (GenericsHighlightUtil.isSafeVarargsNoOverridingCondition(method, PsiUtil.getLanguageLevel(method))) {
                    quickFix = new AnnotateAsSafeVarargsQuickFix();
                } else {
                    PsiClass containingClass = method.getContainingClass();
                    LOG.assertTrue(containingClass != null);
                    boolean canBeFinal = !method.hasModifierProperty("abstract") && !containingClass.isInterface() && OverridingMethodsSearch.search(method).findFirst() == null;
                    quickFix = canBeFinal ? new MakeFinalAndAnnotateQuickFix() : null;
                }
                holder.registerProblem((PsiElement)nameIdentifier, "Possible heap pollution from parameterized vararg type #loc", quickFix);
            }
        };
        if (heapPollutionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "buildVisitor"));
        }
        return heapPollutionVisitor;
    }

    public static abstract class HeapPollutionVisitor
    extends JavaElementVisitor {
        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!PsiUtil.getLanguageLevel(method).isAtLeast(LanguageLevel.JDK_1_7)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, "java.lang.SafeVarargs", false)) {
                return;
            }
            if (!method.isVarArgs()) {
                return;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiParameter psiParameter = parameters[parameters.length - 1];
            if (!psiParameter.isVarArgs()) {
                return;
            }
            PsiType type = psiParameter.getType();
            LOG.assertTrue(type instanceof PsiEllipsisType, "type: " + type.getCanonicalText() + "; param: " + psiParameter);
            PsiType componentType = ((PsiEllipsisType)type).getComponentType();
            if (JavaGenericsUtil.isReifiableType(componentType)) {
                return;
            }
            for (PsiReference reference : ReferencesSearch.search(psiParameter)) {
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiExpression) || PsiUtil.isAccessedForReading((PsiExpression)element)) continue;
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerProblem(method, nameIdentifier);
            }
        }

        protected abstract void registerProblem(PsiMethod var1, PsiIdentifier var2);
    }

    private static class MakeFinalAndAnnotateQuickFix
    implements LocalQuickFix {
        private MakeFinalAndAnnotateQuickFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Make final and annotate as @SafeVarargs" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix", "getFamilyName"));
            }
            return "Make final and annotate as @SafeVarargs";
        }

        @Override
        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            if (currentFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix", "getElementToMakeWritable"));
            }
            return currentFile;
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiIdentifier) {
                PsiMethod psiMethod = (PsiMethod)psiElement.getParent();
                WriteAction.run(() -> psiMethod.getModifierList().setModifierProperty("final", true));
                new AddAnnotationPsiFix("java.lang.SafeVarargs", psiMethod, PsiNameValuePair.EMPTY_ARRAY, new String[0]).applyFix(project, descriptor);
            }
        }
    }

    private static class AnnotateAsSafeVarargsQuickFix
    implements LocalQuickFix {
        private AnnotateAsSafeVarargsQuickFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Annotate as @SafeVarargs" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix", "getFamilyName"));
            }
            return "Annotate as @SafeVarargs";
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethod psiMethod;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiIdentifier && (psiMethod = (PsiMethod)psiElement.getParent()) != null) {
                new AddAnnotationPsiFix("java.lang.SafeVarargs", psiMethod, PsiNameValuePair.EMPTY_ARRAY, new String[0]).applyFix(project, descriptor);
            }
        }
    }
}

