/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSuperElementsHelper {
    @NotNull
    public static PsiElement[] findSuperElements(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            ArrayList<PsiClass> allSupers = new ArrayList<PsiClass>(Arrays.asList(aClass.getSupers()));
            Iterator iterator = allSupers.iterator();
            while (iterator.hasNext()) {
                PsiClass superClass = (PsiClass)iterator.next();
                if (!"java.lang.Object".equals(superClass.getQualifiedName())) continue;
                iterator.remove();
            }
            PsiElement[] psiElementArray = allSupers.toArray(new PsiClass[allSupers.size()]);
            if (psiElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
            }
            return psiElementArray;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                PsiMethod constructorInSuper = PsiSuperMethodUtil.findConstructorInSuper(method);
                if (constructorInSuper != null) {
                    PsiElement[] psiElementArray = new PsiMethod[]{constructorInSuper};
                    if (psiElementArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
                    }
                    return psiElementArray;
                }
            } else {
                PsiMethod superMethod;
                PsiElement[] superMethods = method.findSuperMethods(false);
                if (superMethods.length == 0 && (superMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method)) != null) {
                    superMethods = new PsiMethod[]{superMethod};
                }
                if (superMethods == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
                }
                return superMethods;
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "findSuperElements"));
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiMethod getSiblingInheritedViaSubClass(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/FindSuperElementsHelper", "getSiblingInheritedViaSubClass"));
        }
        SiblingInfo info = FindSuperElementsHelper.getSiblingInfoInheritedViaSubClass(method);
        return info == null ? null : info.superMethod;
    }

    @Nullable
    public static SiblingInfo getSiblingInfoInheritedViaSubClass(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/FindSuperElementsHelper", "getSiblingInfoInheritedViaSubClass"));
        }
        return FindSuperElementsHelper.getSiblingInheritanceInfos(Collections.singletonList(method)).get(method);
    }

    @NotNull
    public static Map<PsiMethod, SiblingInfo> getSiblingInheritanceInfos(@NotNull Collection<PsiMethod> methods) {
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/psi/impl/FindSuperElementsHelper", "getSiblingInheritanceInfos"));
        }
        MultiMap<PsiClass, PsiMethod> byClass = MultiMap.create();
        for (PsiMethod method : methods) {
            PsiClass containingClass;
            if (!FindSuperElementsHelper.canHaveSiblingSuper(method, containingClass = method.getContainingClass())) continue;
            byClass.putValue(containingClass, method);
        }
        HashMap<PsiMethod, SiblingInfo> result = new HashMap<PsiMethod, SiblingInfo>();
        for (PsiClass psiClass : byClass.keySet()) {
            SiblingInheritorSearcher searcher = new SiblingInheritorSearcher(byClass.get(psiClass), psiClass);
            ClassInheritorsSearch.search(psiClass, psiClass.getUseScope(), true, true, false).forEach(searcher);
            result.putAll(searcher.getResult());
        }
        HashMap<PsiMethod, SiblingInfo> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/FindSuperElementsHelper", "getSiblingInheritanceInfos"));
        }
        return hashMap;
    }

    private static boolean canHaveSiblingSuper(PsiMethod method, PsiClass containingClass) {
        return containingClass != null && PsiUtil.canBeOverriden(method) && !method.hasModifierProperty("abstract") && !method.hasModifierProperty("native") && method.hasModifierProperty("public") && !containingClass.isInterface() && !"java.lang.Object".equals(containingClass.getQualifiedName());
    }

    private static class SiblingInheritorSearcher
    implements Processor<PsiClass> {
        private final PsiClass myContainingClass;
        private final Set<PsiMethod> myRemainingMethods;
        private final Map<PsiMethod, SiblingInfo> myResult = new HashMap<PsiMethod, SiblingInfo>();
        private final Collection<PsiAnchor> myCheckedInterfaces = new THashSet();

        SiblingInheritorSearcher(Collection<PsiMethod> methods, PsiClass containingClass) {
            this.myContainingClass = containingClass;
            this.myRemainingMethods = new HashSet<PsiMethod>(methods);
            this.myCheckedInterfaces.add(PsiAnchor.create(containingClass));
        }

        @Override
        public boolean process(PsiClass inheritor) {
            ProgressManager.checkCanceled();
            for (PsiClassType interfaceType : inheritor.getImplementsListTypes()) {
                ProgressManager.checkCanceled();
                PsiClass anInterface = interfaceType.resolveGenerics().getElement();
                if (anInterface == null || !this.myCheckedInterfaces.add(PsiAnchor.create(anInterface))) continue;
                this.processInterface(inheritor, anInterface);
            }
            return !this.myRemainingMethods.isEmpty();
        }

        private void processInterface(PsiClass inheritor, PsiClass anInterface) {
            Iterator<PsiMethod> methodIterator = this.myRemainingMethods.iterator();
            while (methodIterator.hasNext()) {
                PsiMethod method = methodIterator.next();
                SiblingInfo info = this.findSibling(inheritor, anInterface, method);
                if (info == null) continue;
                this.myResult.put(method, info);
                methodIterator.remove();
            }
        }

        @Nullable
        private SiblingInfo findSibling(PsiClass inheritor, PsiClass anInterface, PsiMethod method) {
            for (PsiMethod superMethod : anInterface.findMethodsByName(method.getName(), true)) {
                PsiElement navigationElement = superMethod.getNavigationElement();
                if (!(navigationElement instanceof PsiMethod)) continue;
                superMethod = (PsiMethod)navigationElement;
                ProgressManager.checkCanceled();
                PsiClass superInterface = superMethod.getContainingClass();
                if (superInterface == null || this.myContainingClass.isInheritor(superInterface, true) || !this.isOverridden(inheritor, method, superMethod, superInterface)) continue;
                return new SiblingInfo(superMethod, inheritor);
            }
            return null;
        }

        private boolean isOverridden(PsiClass inheritor, PsiMethod method, PsiMethod superMethod, PsiClass superInterface) {
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(this.myContainingClass, inheritor, PsiSubstitutor.EMPTY);
            PsiSubstitutor superInterfaceSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superInterface, inheritor, substitutor);
            return MethodSignatureUtil.isSubsignature(superMethod.getSignature(superInterfaceSubstitutor), method.getSignature(substitutor));
        }

        Map<PsiMethod, SiblingInfo> getResult() {
            return this.myResult;
        }
    }

    public static class SiblingInfo {
        @NotNull
        public final PsiMethod superMethod;
        @NotNull
        public final PsiClass subClass;

        private SiblingInfo(@NotNull PsiMethod superMethod, @NotNull PsiClass subClass) {
            if (superMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/psi/impl/FindSuperElementsHelper$SiblingInfo", "<init>"));
            }
            if (subClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "com/intellij/psi/impl/FindSuperElementsHelper$SiblingInfo", "<init>"));
            }
            this.superMethod = superMethod;
            this.subClass = subClass;
        }
    }
}

