/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeInitializerExplicitFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.InitializationUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StaticVariableInitializationInspection
extends BaseInspection {
    public boolean m_ignorePrimitives = false;

    @Override
    @NotNull
    public String getID() {
        if ("StaticVariableMayNotBeInitialized" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/StaticVariableInitializationInspection", "getID"));
        }
        return "StaticVariableMayNotBeInitialized";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.variable.may.not.be.initialized.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/StaticVariableInitializationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.variable.may.not.be.initialized.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/StaticVariableInitializationInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("primitive.fields.ignore.option", new Object[0]), this, "m_ignorePrimitives");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeInitializerExplicitFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticVariableInitializationVisitor();
    }

    private class StaticVariableInitializationVisitor
    extends BaseInspectionVisitor {
        private StaticVariableInitializationVisitor() {
        }

        @Override
        public void visitField(@NotNull PsiField field) {
            PsiClassInitializer[] initializers;
            PsiType type;
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/initialization/StaticVariableInitializationInspection$StaticVariableInitializationVisitor", "visitField"));
            }
            if (!field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            if (field.getInitializer() != null) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || containingClass.isEnum()) {
                return;
            }
            if (StaticVariableInitializationInspection.this.m_ignorePrimitives && ClassUtils.isPrimitive(type = field.getType())) {
                return;
            }
            for (PsiClassInitializer initializer : initializers = containingClass.getInitializers()) {
                PsiCodeBlock body;
                if (!initializer.hasModifierProperty("static") || !InitializationUtils.blockAssignsVariableOrFails(body = initializer.getBody(), field)) continue;
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

