/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.NullityInferenceResult;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityInference {
    public static Nullness inferNullity(PsiMethodImpl method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            return Nullness.UNKNOWN;
        }
        PsiType type = method.getReturnType();
        if (type == null || type instanceof PsiPrimitiveType) {
            return Nullness.UNKNOWN;
        }
        return (Nullness)((Object)CachedValuesManager.getCachedValue(method, () -> {
            Nullness nullness;
            MethodData data = ContractInferenceIndexKt.getIndexedData(method);
            NullityInferenceResult result = data == null ? null : data.getNullity();
            Nullness nullness2 = nullness = result == null ? null : RecursionManager.doPreventingRecursion(method, true, () -> result.getNullness(method, data.methodBody(method)));
            if (nullness == null) {
                nullness = Nullness.UNKNOWN;
            }
            return CachedValueProvider.Result.create(nullness, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        }));
    }

    static class NullityInferenceVisitor {
        private final LighterAST tree;
        private final LighterASTNode body;
        private boolean hasErrors;
        private boolean hasNotNulls;
        private boolean hasNulls;
        private boolean hasUnknowns;
        MultiMap<String, ExpressionRange> delegates = MultiMap.create();

        NullityInferenceVisitor(LighterAST tree, LighterASTNode body) {
            this.tree = tree;
            this.body = body;
        }

        void visitNode(LighterASTNode element) {
            IElementType type = element.getTokenType();
            if (type == TokenType.ERROR_ELEMENT) {
                this.hasErrors = true;
            } else if (type == JavaElementType.RETURN_STATEMENT) {
                LighterASTNode value = JavaLightTreeUtil.findExpressionChild(this.tree, element);
                if (value == null) {
                    this.hasErrors = true;
                } else {
                    this.visitReturnedValue(value);
                }
            }
        }

        private void visitReturnedValue(LighterASTNode expr) {
            IElementType type = expr.getTokenType();
            if (this.containsNulls(expr)) {
                this.hasNulls = true;
            } else if (type == JavaElementType.LAMBDA_EXPRESSION || type == JavaElementType.NEW_EXPRESSION || type == JavaElementType.LITERAL_EXPRESSION || type == JavaElementType.BINARY_EXPRESSION || type == JavaElementType.POLYADIC_EXPRESSION) {
                this.hasNotNulls = true;
            } else if (type == JavaElementType.METHOD_CALL_EXPRESSION) {
                String calledMethod = JavaLightTreeUtil.getNameIdentifierText(this.tree, this.tree.getChildren(expr).get(0));
                if (calledMethod != null) {
                    this.delegates.putValue(calledMethod, ExpressionRange.create(expr, this.body.getStartOffset()));
                }
            } else {
                this.hasUnknowns = true;
            }
        }

        private boolean containsNulls(@NotNull LighterASTNode value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/NullityInference$NullityInferenceVisitor", "containsNulls"));
            }
            if (value.getTokenType() == JavaElementType.CONDITIONAL_EXPRESSION) {
                List<LighterASTNode> exprChildren = JavaLightTreeUtil.getExpressionChildren(this.tree, value);
                return exprChildren.subList(1, exprChildren.size()).stream().anyMatch(e -> this.containsNulls((LighterASTNode)e));
            }
            if (value.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
                LighterASTNode wrapped = JavaLightTreeUtil.findExpressionChild(this.tree, value);
                return wrapped != null && this.containsNulls(wrapped);
            }
            return value.getTokenType() == JavaElementType.LITERAL_EXPRESSION && this.tree.getChildren(value).get(0).getTokenType() == JavaTokenType.NULL_KEYWORD;
        }

        @Nullable
        NullityInferenceResult getResult() {
            if (this.hasNulls) {
                return new NullityInferenceResult.Predefined(Nullness.NULLABLE);
            }
            if (this.hasErrors || this.hasUnknowns || this.delegates.size() > 1) {
                return null;
            }
            if (this.delegates.size() == 1) {
                return new NullityInferenceResult.FromDelegate(ContainerUtil.newArrayList(this.delegates.get(this.delegates.keySet().iterator().next())));
            }
            if (this.hasNotNulls) {
                return new NullityInferenceResult.Predefined(Nullness.NOT_NULL);
            }
            return null;
        }
    }
}

