/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.WeakList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModalityStateEx
extends ModalityState {
    private final WeakList<Object> myModalEntities;

    public ModalityStateEx() {
        this.myModalEntities = new WeakList();
    }

    public ModalityStateEx(@NotNull Object[] modalEntities) {
        if (modalEntities == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalEntities", "com/intellij/openapi/application/impl/ModalityStateEx", "<init>"));
        }
        this.myModalEntities = new WeakList();
        Collections.addAll(this.myModalEntities, modalEntities);
    }

    private List<Object> getModalEntities() {
        return this.myModalEntities.toStrongList();
    }

    @NotNull
    public ModalityState appendProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/openapi/application/impl/ModalityStateEx", "appendProgress"));
        }
        ModalityStateEx modalityStateEx = this.appendEntity(progress);
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ModalityStateEx", "appendProgress"));
        }
        return modalityStateEx;
    }

    @NotNull
    ModalityStateEx appendEntity(@NotNull Object anEntity) {
        if (anEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anEntity", "com/intellij/openapi/application/impl/ModalityStateEx", "appendEntity"));
        }
        List<Object> modalEntities = this.getModalEntities();
        ArrayList<Object> list = new ArrayList<Object>(modalEntities.size() + 1);
        list.addAll(modalEntities);
        list.add(anEntity);
        ModalityStateEx modalityStateEx = new ModalityStateEx(list.toArray());
        if (modalityStateEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ModalityStateEx", "appendEntity"));
        }
        return modalityStateEx;
    }

    @Override
    public boolean dominates(@NotNull ModalityState anotherState) {
        if (anotherState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anotherState", "com/intellij/openapi/application/impl/ModalityStateEx", "dominates"));
        }
        if (anotherState == ModalityState.any()) {
            return false;
        }
        List<Object> otherEntities = ((ModalityStateEx)anotherState).getModalEntities();
        for (Object entity : this.getModalEntities()) {
            if (otherEntities.contains(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNls
    public String toString() {
        return this == NON_MODAL ? "ModalityState.NON_MODAL" : "ModalityState:" + StringUtil.join(this.getModalEntities(), ", ");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModalityStateEx)) {
            return false;
        }
        List<Object> entities = this.getModalEntities();
        if (entities.isEmpty()) {
            return false;
        }
        return entities.equals(((ModalityStateEx)o).getModalEntities());
    }

    public int hashCode() {
        return this.getModalEntities().hashCode();
    }

    void removeModality(Object modalEntity) {
        this.myModalEntities.remove(modalEntity);
    }
}

