/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.Serializer;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import gnu.trove.THashMap;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCollectionBinding
extends NotNullDeserializeBinding
implements MultiNodeBinding {
    private Map<Class<?>, Binding> itemBindings;
    protected final Class<?> itemType;
    @Nullable
    protected final AbstractCollection annotation;
    private Serializer serializer;

    public AbstractCollectionBinding(@NotNull Class elementType, @Nullable MutableAccessor accessor) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/util/xmlb/AbstractCollectionBinding", "<init>"));
        }
        super(accessor);
        this.itemType = elementType;
        this.annotation = accessor == null ? null : accessor.getAnnotation(AbstractCollection.class);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/AbstractCollectionBinding", "init"));
        }
        if (serializer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/util/xmlb/AbstractCollectionBinding", "init"));
        }
        this.serializer = serializer2;
        if (this.annotation == null || this.annotation.surroundWithTag()) {
            return;
        }
        if (StringUtil.isEmpty(this.annotation.elementTag()) || this.annotation.elementTag().equals("option") && serializer2.getBinding(this.itemType) == null) {
            throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
        }
    }

    @NotNull
    private synchronized Map<Class<?>, Binding> getElementBindings() {
        if (this.itemBindings == null) {
            Binding binding = this.serializer.getBinding(this.itemType);
            if (this.annotation == null || this.annotation.elementTypes().length == 0) {
                this.itemBindings = binding == null ? Collections.emptyMap() : Collections.singletonMap(this.itemType, binding);
            } else {
                this.itemBindings = new THashMap();
                if (binding != null) {
                    this.itemBindings.put(this.itemType, binding);
                }
                for (Class aClass : this.annotation.elementTypes()) {
                    Binding b = this.serializer.getBinding(aClass);
                    if (b == null) continue;
                    this.itemBindings.put(aClass, b);
                }
                if (this.itemBindings.isEmpty()) {
                    this.itemBindings = Collections.emptyMap();
                }
            }
        }
        Map<Class<?>, Binding> map = this.itemBindings;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/AbstractCollectionBinding", "getElementBindings"));
        }
        return map;
    }

    @Nullable
    private Binding getElementBinding(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/AbstractCollectionBinding", "getElementBinding"));
        }
        for (Binding binding : this.getElementBindings().values()) {
            if (!binding.isBoundTo(element)) continue;
            return binding;
        }
        return null;
    }

    @NotNull
    abstract Object processResult(@NotNull Collection var1, @Nullable Object var2);

    @NotNull
    abstract Collection<Object> getIterable(@NotNull Object var1);

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @Nullable SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/AbstractCollectionBinding", "serialize"));
        }
        Collection<Object> collection = this.getIterable(o);
        String tagName = this.getTagName(o);
        if (tagName == null) {
            SmartList result = new SmartList();
            if (!ContainerUtil.isEmpty(collection)) {
                for (Object item : collection) {
                    ContainerUtil.addAllNotNull(result, this.serializeItem(item, result, filter));
                }
            }
            return result;
        }
        Element result = new Element(tagName);
        if (!ContainerUtil.isEmpty(collection)) {
            for (Object item : collection) {
                Content child = (Content)this.serializeItem(item, result, filter);
                if (child == null) continue;
                result.addContent(child);
            }
        }
        return result;
    }

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context, @NotNull List<Element> elements) {
        Collection<Object> result;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeList"));
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result = (SmartList)context;
                result.clear();
            } else {
                result = new SmartList();
            }
            for (Element node : elements) {
                result.add(this.deserializeItem(node, context));
            }
            if (result == context) {
                return result;
            }
        } else {
            assert (elements.size() == 1);
            result = this.deserializeSingle(context, elements.get(0));
        }
        return this.processResult(result, context);
    }

    @Nullable
    private Object serializeItem(@Nullable Object value, Object context, @Nullable SerializationFilter filter) {
        if (value == null) {
            LOG.warn("Collection " + this.myAccessor + " contains 'null' object");
            return null;
        }
        Binding binding = this.serializer.getBinding(value.getClass());
        if (binding == null) {
            Element serializedItem = new Element(this.annotation == null ? "option" : this.annotation.elementTag());
            String attributeName = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
            String serialized = XmlSerializerImpl.convertToString(value);
            if (attributeName.isEmpty()) {
                if (!serialized.isEmpty()) {
                    serializedItem.addContent((Content)new Text(serialized));
                }
            } else {
                serializedItem.setAttribute(attributeName, serialized);
            }
            return serializedItem;
        }
        return binding.serialize(value, context, filter);
    }

    private Object deserializeItem(@NotNull Element node, @Nullable Object context) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeItem"));
        }
        Binding binding = this.getElementBinding(node);
        if (binding == null) {
            String attributeName = this.annotation == null ? "value" : this.annotation.elementValueAttribute();
            String value = attributeName.isEmpty() ? XmlSerializerImpl.getTextValue(node, "") : node.getAttributeValue(attributeName);
            return XmlSerializerImpl.convert(value, this.itemType);
        }
        return binding.deserializeUnsafe(context, node);
    }

    @Override
    @NotNull
    public Object deserialize(@Nullable Object context, @NotNull Element element) {
        SmartList<Object> result;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserialize"));
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result = (Collection)context;
                result.clear();
            } else {
                result = new SmartList<Object>();
            }
            result.add(this.deserializeItem(element, context));
            if (result == context) {
                SmartList<Object> smartList = result;
                if (smartList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserialize"));
                }
                return smartList;
            }
        } else {
            result = this.deserializeSingle(context, element);
        }
        Object object = this.processResult(result, context);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserialize"));
        }
        return object;
    }

    @NotNull
    private Collection deserializeSingle(Object context, @NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeSingle"));
        }
        Collection result = this.createCollection(node.getName());
        for (Element child : node.getChildren()) {
            result.add(this.deserializeItem(child, context));
        }
        Collection collection = result;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeSingle"));
        }
        return collection;
    }

    protected Collection createCollection(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/util/xmlb/AbstractCollectionBinding", "createCollection"));
        }
        return new SmartList();
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/AbstractCollectionBinding", "isBoundTo"));
        }
        String tagName = this.getTagName(element);
        if (tagName == null) {
            if (element.getName().equals(this.annotation == null ? "option" : this.annotation.elementTag())) {
                return true;
            }
            if (this.getElementBinding(element) != null) {
                return true;
            }
        }
        return element.getName().equals(tagName);
    }

    @Nullable
    private String getTagName(@Nullable Object target) {
        return this.annotation == null || this.annotation.surroundWithTag() ? this.getCollectionTagName(target) : null;
    }

    protected abstract String getCollectionTagName(@Nullable Object var1);
}

