/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.text.CharArrayUtil;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Document
extends UserDataHolder {
    public static final Document[] EMPTY_ARRAY = new Document[0];
    @NonNls
    public static final String PROP_WRITABLE = "writable";

    @NotNull
    @Contract(pure=true)
    default public String getText() {
        String string = this.getImmutableCharSequence().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/Document", "getText"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    default public String getText(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/Document", "getText"));
        }
        String string = range.substring(this.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/Document", "getText"));
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    default public CharSequence getCharsSequence() {
        CharSequence charSequence = this.getImmutableCharSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/Document", "getCharsSequence"));
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public CharSequence getImmutableCharSequence();

    @Deprecated
    @NotNull
    default public char[] getChars() {
        char[] cArray = CharArrayUtil.fromSequence(this.getImmutableCharSequence());
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/Document", "getChars"));
        }
        return cArray;
    }

    @Contract(pure=true)
    default public int getTextLength() {
        return this.getImmutableCharSequence().length();
    }

    @Contract(pure=true)
    public int getLineCount();

    @Contract(pure=true)
    public int getLineNumber(int var1);

    @Contract(pure=true)
    public int getLineStartOffset(int var1);

    @Contract(pure=true)
    public int getLineEndOffset(int var1);

    public void insertString(int var1, @NotNull CharSequence var2);

    public void deleteString(int var1, int var2);

    public void replaceString(int var1, int var2, @NotNull CharSequence var3);

    @Contract(pure=true)
    public boolean isWritable();

    @Contract(pure=true)
    default public long getModificationStamp() {
        return 0L;
    }

    default public void fireReadOnlyModificationAttempt() {
    }

    default public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/Document", "addDocumentListener"));
        }
    }

    default public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/Document", "addDocumentListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/Document", "addDocumentListener"));
        }
    }

    default public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/Document", "removeDocumentListener"));
        }
    }

    @NotNull
    default public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        RangeMarker rangeMarker = this.createRangeMarker(startOffset, endOffset, false);
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/Document", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @NotNull
    public RangeMarker createRangeMarker(int var1, int var2, boolean var3);

    default public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/Document", "addPropertyChangeListener"));
        }
    }

    default public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/Document", "removePropertyChangeListener"));
        }
    }

    default public void setReadOnly(boolean isReadOnly) {
    }

    @NotNull
    public RangeMarker createGuardedBlock(int var1, int var2);

    default public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/openapi/editor/Document", "removeGuardedBlock"));
        }
    }

    @Nullable
    default public RangeMarker getOffsetGuard(int offset) {
        return null;
    }

    @Nullable
    default public RangeMarker getRangeGuard(int start, int end) {
        return null;
    }

    default public void startGuardedBlockChecking() {
    }

    default public void stopGuardedBlockChecking() {
    }

    default public void setCyclicBufferSize(int bufferSize) {
    }

    public void setText(@NotNull CharSequence var1);

    @NotNull
    default public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/openapi/editor/Document", "createRangeMarker"));
        }
        RangeMarker rangeMarker = this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/Document", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @Contract(pure=true)
    default public int getLineSeparatorLength(int line) {
        return 0;
    }
}

