/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UnsignedShortArrayList;
import java.awt.EventQueue;
import org.jetbrains.annotations.NotNull;

public class PausesStat {
    private static final int N_MAX = 100000;
    private final UnsignedShortArrayList durations;
    @NotNull
    private final String myName;
    private final Thread myEdtThread;
    private boolean started;
    private long startTimeStamp;
    private int maxDuration;
    private Object maxDurationDescription;
    private int totalNumberRecorded;
    private int indexToOverwrite;

    public PausesStat(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/PausesStat", "<init>"));
        }
        this.durations = new UnsignedShortArrayList();
        this.startTimeStamp = System.currentTimeMillis();
        this.myName = name;
        assert (EventQueue.isDispatchThread()) : Thread.currentThread();
        this.myEdtThread = Thread.currentThread();
    }

    private void register(int duration) {
        if (this.durations.size() == 100000) {
            this.durations.set(this.indexToOverwrite, duration);
            this.indexToOverwrite = (this.indexToOverwrite + 1) % 100000;
        } else {
            this.durations.add(duration);
        }
    }

    public void started() {
        this.assertEdt();
        assert (!this.started);
        this.startTimeStamp = System.currentTimeMillis();
        this.started = true;
    }

    private void assertEdt() {
        if (Thread.currentThread() != this.myEdtThread) {
            throw new IllegalStateException("wrong thread: " + Thread.currentThread());
        }
    }

    public void finished(@NotNull String description) {
        long startTimeStamp;
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/util/PausesStat", "finished"));
        }
        this.assertEdt();
        assert (this.started);
        long finishStamp = System.currentTimeMillis();
        if (finishStamp < (startTimeStamp = this.startTimeStamp)) {
            throw new IllegalStateException("startTimeStamp: " + startTimeStamp + "; finishStamp: " + finishStamp);
        }
        int duration = (int)(finishStamp - startTimeStamp);
        if (duration < 0) {
            throw new IllegalStateException("startTimeStamp: " + startTimeStamp + "; finishStamp: " + finishStamp + "; duration: " + duration);
        }
        this.started = false;
        this.startTimeStamp = 0L;
        if ((duration = Math.min(duration, Short.MAX_VALUE)) > this.maxDuration) {
            this.maxDuration = duration;
            this.maxDurationDescription = description;
        }
        ++this.totalNumberRecorded;
        this.register(duration);
    }

    public String statistics() {
        int number = this.durations.size();
        int[] duration = this.durations.toArray();
        int total = 0;
        for (int d : duration) {
            total += d;
        }
        return this.myName + " Statistics" + (this.totalNumberRecorded == number ? "" : " (" + this.totalNumberRecorded + " events was recorded in total, but only last " + number + " are reported here)") + ":\nEvent number:     " + number + "\nTotal time spent: " + total + "ms\nAverage duration: " + (number == 0 ? 0 : total / number) + "ms\nMedian  duration: " + ArrayUtil.averageAmongMedians(duration, 3) + "ms\nMax  duration:    " + (this.maxDuration == 65535 ? ">" : "") + this.maxDuration + "ms (it was '" + this.maxDurationDescription + "')";
    }
}

