/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NonNls
    private static final String CLONE_METHOD_NAME = "clone";

    private ExceptionUtil() {
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownCheckedExceptions(PsiElement ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/ExceptionUtil", "getThrownCheckedExceptions"));
        }
        List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(elements);
        if (exceptions.isEmpty()) {
            List<PsiClassType> list = exceptions;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownCheckedExceptions"));
            }
            return list;
        }
        List<PsiClassType> list = exceptions = ExceptionUtil.filterOutUncheckedExceptions(exceptions);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownCheckedExceptions"));
        }
        return list;
    }

    @NotNull
    private static List<PsiClassType> filterOutUncheckedExceptions(@NotNull List<PsiClassType> exceptions) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/codeInsight/ExceptionUtil", "filterOutUncheckedExceptions"));
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        for (PsiClassType exception : exceptions) {
            if (ExceptionUtil.isUncheckedException(exception)) continue;
            array.add(exception);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "filterOutUncheckedExceptions"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(final @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        final ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        element.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                PsiExpressionList argumentList = aClass.getArgumentList();
                if (argumentList != null) {
                    super.visitExpressionList(argumentList);
                }
                super.visitAnonymousClass(aClass);
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiReferenceExpression methodRef = expression.getMethodExpression();
                JavaResolveResult resolveResult = methodRef.advancedResolve(false);
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitMethodCallExpression(expression);
            }

            @Override
            public void visitNewExpression(PsiNewExpression expression) {
                JavaResolveResult resolveResult = expression.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitNewExpression(expression);
            }

            @Override
            public void visitThrowStatement(PsiThrowStatement statement) {
                PsiExpression expr = statement.getException();
                if (expr != null) {
                    ExceptionUtil.addExceptions(result, StreamEx.of((Collection)ExceptionUtil.getPreciseThrowTypes(expr)).select(PsiClassType.class).toList());
                }
                super.visitThrowStatement(statement);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }

            @Override
            public void visitResourceList(PsiResourceList resourceList) {
                for (PsiResourceListElement listElement : resourceList) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getCloserExceptions(listElement));
                }
                super.visitResourceList(resourceList);
            }

            @Override
            public void visitTryStatement(PsiTryStatement statement) {
                ExceptionUtil.addExceptions(result, ExceptionUtil.getTryExceptions(statement));
            }
        });
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getThrownExceptions"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/intellij/codeInsight/ExceptionUtil", "getTryExceptions"));
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceListElement psiResourceListElement : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(psiResourceListElement, resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(tryBlock));
        }
        for (PsiParameter psiParameter : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiParameter.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom(exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(psiCodeBlock));
        }
        PsiCodeBlock psiCodeBlock = tryStatement.getFinallyBlock();
        if (psiCodeBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(psiCodeBlock.getProject()).getControlFlow(psiCodeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list = ExceptionUtil.getThrownExceptions(psiCodeBlock);
                if (!BitUtil.isSet(completionReasons, 1)) {
                    array = ContainerUtil.newArrayList(list);
                } else {
                    ExceptionUtil.addExceptions(array, list);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getTryExceptions"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethodAndChildren(@NotNull PsiElement element, @NotNull JavaResolveResult resolveResult) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethodAndChildren"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethodAndChildren"));
        }
        ArrayList<PsiClassType> result = ContainerUtil.newArrayList();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method != null) {
            ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
        }
        ExceptionUtil.addExceptions(result, ExceptionUtil.getThrownExceptions(element.getChildren()));
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethodAndChildren"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement place) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        PsiClassType[] referenceTypes = method.getThrowsList().getReferencedTypes();
        if (referenceTypes.length == 0) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
            }
            return list;
        }
        GlobalSearchScope scope = place.getResolveScope();
        ArrayList<PsiClassType> result = ContainerUtil.newArrayList();
        for (PsiType type : referenceTypes) {
            if (!((type = PsiClassImplUtil.correctType(substitutor.substitute(type), scope)) instanceof PsiClassType)) continue;
            result.add((PsiClassType)type);
        }
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getExceptionsByMethod"));
        }
        return arrayList;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<PsiClassType> exceptions) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/codeInsight/ExceptionUtil", "addExceptions"));
        }
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/codeInsight/ExceptionUtil", "addExceptions"));
        }
        for (PsiClassType exception : exceptions) {
            ExceptionUtil.addException(array, exception);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/codeInsight/ExceptionUtil", "addException"));
        }
        if (exception == null) {
            return;
        }
        for (int i2 = array.size() - 1; i2 >= 0; --i2) {
            PsiClassType exception1 = array.get(i2);
            if (exception1.isAssignableFrom(exception)) {
                return;
            }
            if (!exception.isAssignableFrom(exception1)) continue;
            array.remove(i2);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        Collection<PsiClassType> collection = ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        Set<PsiClassType> set = ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls);
        Collection<Object> collection = set == null ? Collections.emptyList() : set;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        return collection;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, boolean includeSelfCalls) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "collectUnhandledExceptions"));
        }
        Collection<PsiClassType> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression, topElement, includeSelfCalls);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression != null ? ExceptionUtil.collectUnhandledExceptions(qualifierExpression, topElement, null, false) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass = constructor.getContainingClass();
                PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || superConstructor.getParameterList().getParametersCount() != 0) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.isHandled(element, exceptionType, topElement)) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass != null) {
                    PsiClassInitializer[] initializers = aClass.getInitializers();
                    THashSet thrownByInitializer = new THashSet();
                    for (PsiClassInitializer initializer : initializers) {
                        if (initializer.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions(initializer.getBody(), initializer, (Set<PsiClassType>)thrownByInitializer, includeSelfCalls);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.isHandled(constructor.getBody(), thrown, topElement)) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, (Set<PsiClassType>)foundExceptions, includeSelfCalls);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static Collection<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReferenceExpression", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        JavaResolveResult resolveResult = methodReferenceExpression.advancedResolve(false);
        PsiElement resolve = resolveResult.getElement();
        if (resolve instanceof PsiMethod) {
            PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
            List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve, referenceNameElement, topElement, resolveResult.getSubstitutor());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
            }
            return list;
        }
        List<PsiClassType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list;
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        if (constructorBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorBody", "com/intellij/codeInsight/ExceptionUtil", "firstStatementIsConstructorCall"));
        }
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final @NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        final ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                PsiMethod method = enumConstant.resolveMethod();
                if (method != null) {
                    ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(method, (PsiElement)enumConstant, null, PsiSubstitutor.EMPTY));
                }
                this.visitElement(enumConstant);
            }

            @Override
            public void visitCallExpression(@NotNull PsiCallExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExceptionUtil$2", "visitCallExpression"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                this.visitElement(expression);
            }

            @Override
            public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
                if (statement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/ExceptionUtil$2", "visitThrowStatement"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(statement, null));
                this.visitElement(statement);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
                if (ArrayUtil.find(elements, expression) >= 0) {
                    this.visitElement(expression);
                }
            }

            @Override
            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExceptionUtil$2", "visitMethodReferenceExpression"));
                }
                if (ArrayUtil.find(elements, expression) >= 0) {
                    ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                    this.visitElement(expression);
                }
            }

            @Override
            public void visitResourceVariable(@NotNull PsiResourceVariable resource) {
                if (resource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/ExceptionUtil$2", "visitResourceVariable"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(resource, null));
                this.visitElement(resource);
            }

            @Override
            public void visitResourceExpression(@NotNull PsiResourceExpression resource) {
                if (resource == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/ExceptionUtil$2", "visitResourceExpression"));
                }
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(resource, null));
                this.visitElement(resource);
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }
        };
        for (PsiElement element : elements) {
            element.accept(visitor);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{element});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        block19: {
            block20: {
                if (methodCall == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", new Object[]{"methodCall", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                }
                if (MethodCandidateInfo.isOverloadCheck()) {
                    v0 = Collections.emptyList();
                    if (v0 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v0;
                }
                properties = MethodCandidateInfo.getCurrentMethod(methodCall.getArgumentList());
                result = properties != null ? properties.getInfo() : PsiDiamondType.getDiamondsAwareResolveResult(methodCall);
                element = result.getElement();
                v1 = method = element instanceof PsiMethod != false ? (PsiMethod)element : null;
                if (method == null) {
                    v2 = Collections.emptyList();
                    if (v2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v2;
                }
                containingMethod = PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
                if (!includeSelfCalls && method == containingMethod) {
                    v3 = Collections.emptyList();
                    if (v3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v3;
                }
                if (properties != null) {
                    PsiUtilCore.ensureValid(method);
                }
                if ((thrownExceptions = method.getThrowsList().getReferencedTypes()).length == 0) {
                    v4 = Collections.emptyList();
                    if (v4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v4;
                }
                substitutor = result.getSubstitutor();
                if (ExceptionUtil.isArrayClone(method, methodCall) || !(methodCall instanceof PsiMethodCallExpression)) break block19;
                containingFile = (containingMethod == null ? methodCall : containingMethod).getContainingFile();
                processor = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
                try {
                    PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
                    candidates = ContainerUtil.mapNotNull(processor.getResults(), (Function<CandidateInfo, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getUnhandledExceptions$0(com.intellij.psi.PsiMethod com.intellij.psi.infos.CandidateInfo ), (Lcom/intellij/psi/infos/CandidateInfo;)Lcom/intellij/openapi/util/Pair;)((PsiMethod)method));
                    if (candidates.size() <= 1) break block19;
                    scope = methodCall.getResolveScope();
                    ex = ExceptionUtil.collectSubstituted(substitutor, thrownExceptions, scope);
lbl40:
                    // 2 sources

                    for (Pair pair : candidates) {
                        exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            v5 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, PsiClassType.EMPTY_ARRAY);
                            break block20;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl58
                }
                catch (MethodProcessorSetupFailedException ignore) {
                    v6 = Collections.emptyList();
                    if (v6 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
                    }
                    return v6;
                }
            }
            if (v5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
            }
            return v5;
lbl-1000:
            // 1 sources

            {
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope));
                ** GOTO lbl40
lbl58:
                // 1 sources

                v7 = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(new PsiClassType[ex.size()]));
            }
            if (v7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
            }
            return v7;
        }
        v8 = ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, substitutor);
        if (v8 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", new Object[]{"com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"}));
        }
        return v8;
    }

    public static void retainExceptions(List<PsiClassType> ex, List<PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator = ex.iterator();
        while (iterator.hasNext()) {
            PsiClassType classType = iterator.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom(classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom(psiClassType) || ExceptionUtil.isUncheckedException(classType) != ExceptionUtil.isUncheckedException(psiClassType)) continue;
                replacement.add(psiClassType);
            }
            if (found) continue;
            iterator.remove();
        }
        ex.removeAll(replacement);
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor, PsiClassType[] thrownExceptions, GlobalSearchScope scope) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiCapturedWildcardType capturedWildcardType;
            PsiType upperBound;
            PsiType psiType = PsiClassImplUtil.correctType(substitutor.substitute(thrownException), scope);
            if (psiType instanceof PsiClassType) {
                ex.add((PsiClassType)psiType);
                continue;
            }
            if (!(psiType instanceof PsiCapturedWildcardType) || !((upperBound = (capturedWildcardType = (PsiCapturedWildcardType)psiType).getUpperBound()) instanceof PsiClassType)) continue;
            ex.add((PsiClassType)upperBound);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/ExceptionUtil", "getCloserExceptions"));
        }
        List<PsiClassType> ex = ExceptionUtil.getExceptionsFromClose(resource);
        List<PsiClassType> list = ex != null ? ex : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getCloserExceptions"));
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledCloserExceptions"));
        }
        PsiType type = resource.getType();
        List<PsiClassType> list = ExceptionUtil.getUnhandledCloserExceptions(resource, topElement, type);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledCloserExceptions"));
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiElement place, @Nullable PsiElement topElement, PsiType type) {
        List<PsiClassType> ex = type instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type, place.getResolveScope()) : null;
        List<PsiClassType> list = ex != null ? ExceptionUtil.getUnhandledExceptions(place, topElement, PsiSubstitutor.EMPTY, ex.toArray(new PsiClassType[ex.size()])) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledCloserExceptions"));
        }
        return list;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiResourceListElement resource) {
        PsiType type = resource.getType();
        return type instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type, resource.getResolveScope()) : null;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiType type, GlobalSearchScope scope) {
        PsiClassType.ClassResolveResult resourceType = PsiUtil.resolveGenericsClassInType(type);
        PsiClass resourceClass = resourceType.getElement();
        if (resourceClass == null) {
            return null;
        }
        PsiMethod[] methods = PsiUtil.getResourceCloserMethodsForType((PsiClassType)type);
        if (methods != null) {
            List<PsiClassType> ex = null;
            for (PsiMethod method : methods) {
                PsiSubstitutor substitutor;
                PsiClass closerClass = method.getContainingClass();
                if (closerClass == null || (substitutor = TypeConversionUtil.getClassSubstitutor(closerClass, resourceClass, resourceType.getSubstitutor())) == null) continue;
                PsiClassType[] exceptionTypes = method.getThrowsList().getReferencedTypes();
                if (exceptionTypes.length == 0) {
                    return Collections.emptyList();
                }
                if (ex == null) {
                    ex = ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope);
                    continue;
                }
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope));
            }
            return ex;
        }
        return null;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        if (throwStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwStatement", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        SmartList<PsiClassType> unhandled = new SmartList<PsiClassType>();
        for (PsiType type : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List<PsiType> types = type instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type).getDisjunctions() : Collections.singletonList(type);
            for (PsiType subType : types) {
                PsiClassType classType;
                if (!(subType instanceof PsiClassType) || ExceptionUtil.isUncheckedException(classType = (PsiClassType)subType) || ExceptionUtil.isHandled(throwStatement, classType, topElement)) continue;
                unhandled.add(classType);
            }
        }
        SmartList<PsiClassType> smartList = unhandled;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return smartList;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression) {
        PsiType type;
        PsiElement target;
        if ((expression = PsiUtil.skipParenthesizedExprDown(expression)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression).resolve()) != null && PsiUtil.isCatchParameter(target)) {
            List<PsiType> list = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getPreciseThrowTypes"));
            }
            return list;
        }
        if (expression != null && (type = expression.getType()) != null) {
            List<PsiType> list = Collections.singletonList(type);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getPreciseThrowTypes"));
            }
            return list;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getPreciseThrowTypes"));
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method, PsiElement element, PsiElement topElement, @NotNull PsiSubstitutor substitutor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        if (ExceptionUtil.isArrayClone(method, element)) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
            }
            return list;
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor, referencedTypes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExceptionUtil", "getUnhandledExceptions"));
        }
        return list;
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList<PsiClassType> result = ContainerUtil.newArrayList();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards(substitutor.substitute(referencedType), false), element.getResolveScope());
                if (!(type instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type;
                PsiClass exceptionClass = ((PsiClassType)type).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.isHandled(element, classType, topElement)) continue;
                result.add((PsiClassType)type);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "isArrayClone"));
        }
        if (!method.getName().equals(CLONE_METHOD_NAME)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression = methodCallExpression.getQualifierExpression();
            return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExceptionUtil", "isUncheckedException"));
        }
        return InheritanceUtil.isInheritor(type, "java.lang.RuntimeException") || InheritanceUtil.isInheritor(type, "java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExceptionUtil", "isUncheckedExceptionOrSuperclass"));
        }
        return ExceptionUtil.isGeneralExceptionType(type) || ExceptionUtil.isUncheckedException(type);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExceptionUtil", "isGeneralExceptionType"));
        }
        String canonicalText = type.getCanonicalText();
        return "java.lang.Throwable".equals(canonicalText) || "java.lang.Exception".equals(canonicalText);
    }

    public static boolean isHandled(@NotNull PsiClassType exceptionType, @NotNull PsiElement throwPlace) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandled"));
        }
        if (throwPlace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwPlace", "com/intellij/codeInsight/ExceptionUtil", "isHandled"));
        }
        return ExceptionUtil.isHandled(throwPlace, exceptionType, throwPlace.getContainingFile());
    }

    private static boolean isHandled(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, PsiElement topElement) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandled"));
        }
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType);
        }
        if (parent instanceof PsiClass) {
            return parent instanceof PsiAnonymousClass && ExceptionUtil.isHandled(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiLambdaExpression || parent instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent).getFunctionalInterfaceType();
            return ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType);
        }
        if (parent instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent).hasModifierProperty("static")) {
                return false;
            }
            if (!(parent.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent).getContainingClass();
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        } else if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else {
            if (parent instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return exceptionHandler != null && exceptionHandler.isHandledException(exceptionType);
            }
            if (PsiImplUtil.isInServerPage(parent) && parent instanceof PsiFile) {
                return true;
            }
            if (parent instanceof PsiFile) {
                return false;
            }
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                PsiClass aClass = ((PsiField)parent).getContainingClass();
                if (aClass != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent).hasModifierProperty("static")) {
                    return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
                }
            } else {
                for (CustomExceptionHandler exceptionHandler : Extensions.getExtensions(CustomExceptionHandler.KEY)) {
                    if (!exceptionHandler.isHandled(element, exceptionType, topElement)) continue;
                    return true;
                }
            }
        }
        return ExceptionUtil.isHandled(parent, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isDeclaredBySAMMethod"));
        }
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult = PsiUtil.resolveGenericsClassInType(interfaceType))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor(interfaceMethod, resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass, @NotNull PsiClassType exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "areAllConstructorsThrow"));
        }
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean thrown = constructors.length != 0;
        for (PsiMethod constructor : constructors) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    private static boolean isCaught(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        if (tryStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryStatement", "com/intellij/codeInsight/ExceptionUtil", "isCaught"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isCaught"));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finallyBlock", "com/intellij/codeInsight/ExceptionUtil", "blockCompletesAbruptly"));
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet(completionReasons, 1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandledByMethodThrowsClause"));
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandledBy"));
        }
        if (referencedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedTypes", "com/intellij/codeInsight/ExceptionUtil", "isHandledBy"));
        }
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, PsiSubstitutor.EMPTY);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor) {
        if (exceptionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionType", "com/intellij/codeInsight/ExceptionUtil", "isHandledBy"));
        }
        if (referencedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedTypes", "com/intellij/codeInsight/ExceptionUtil", "isHandledBy"));
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor.substitute(classType);
            if (psiType == null || !psiType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void sortExceptionsByHierarchy(@NotNull List<PsiClassType> exceptions) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/codeInsight/ExceptionUtil", "sortExceptionsByHierarchy"));
        }
        if (exceptions.size() <= 1) {
            return;
        }
        ExceptionUtil.sortExceptionsByHierarchy(exceptions.subList(1, exceptions.size()));
        for (int i2 = 0; i2 < exceptions.size() - 1; ++i2) {
            if (!TypeConversionUtil.isAssignable(exceptions.get(i2), exceptions.get(i2 + 1))) continue;
            Collections.swap(exceptions, i2, i2 + 1);
        }
    }

    private static /* synthetic */ Pair lambda$getUnhandledExceptions$0(PsiMethod method, CandidateInfo info) {
        PsiElement element1 = info.getElement();
        if (info instanceof MethodCandidateInfo && MethodSignatureUtil.areSignaturesEqual(method, (PsiMethod)element1) && !MethodSignatureUtil.isSuperMethod((PsiMethod)element1, method)) {
            return Pair.create((PsiMethod)element1, ((MethodCandidateInfo)info).getSubstitutor(false));
        }
        return null;
    }
}

