/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DelegationContract;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.codeInspection.dataFlow.KnownContract;
import com.intellij.codeInspection.dataFlow.MethodCallContract;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.codeInspection.dataFlow.SideEffectFilter;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContractInferenceInterpreter {
    private final LighterAST myTree;
    private final LighterASTNode myMethod;
    private final LighterASTNode myBody;

    public ContractInferenceInterpreter(LighterAST tree, LighterASTNode method, LighterASTNode body) {
        this.myTree = tree;
        this.myMethod = method;
        this.myBody = body;
    }

    @NotNull
    private List<LighterASTNode> getParameters() {
        LighterASTNode paramList = LightTreeUtil.firstChildOfType(this.myTree, this.myMethod, JavaElementType.PARAMETER_LIST);
        List<LighterASTNode> list = paramList != null ? LightTreeUtil.getChildrenOfType(this.myTree, paramList, JavaElementType.PARAMETER) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getParameters"));
        }
        return list;
    }

    @NotNull
    List<PreContract> inferContracts(List<LighterASTNode> statements) {
        List<PreContract> result;
        if (statements.isEmpty()) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "inferContracts"));
            }
            return list;
        }
        if (statements.size() == 1 && (result = this.handleSingleStatement(statements.get(0))) != null) {
            List<PreContract> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "inferContracts"));
            }
            return list;
        }
        List<PreContract> list = this.visitStatements(Collections.singletonList(StandardMethodContract.createConstraintArray(this.getParameters().size())), statements);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "inferContracts"));
        }
        return list;
    }

    @Nullable
    private List<PreContract> handleSingleStatement(LighterASTNode statement) {
        if (statement.getTokenType() == JavaElementType.RETURN_STATEMENT) {
            LighterASTNode returned = JavaLightTreeUtil.findExpressionChild(this.myTree, statement);
            return this.getLiteralConstraint(returned) != null ? Collections.emptyList() : this.handleDelegation(returned, false);
        }
        if (statement.getTokenType() == JavaElementType.EXPRESSION_STATEMENT) {
            LighterASTNode expr = JavaLightTreeUtil.findExpressionChild(this.myTree, statement);
            return expr != null && expr.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION ? this.handleDelegation(expr, false) : null;
        }
        return null;
    }

    @Nullable
    private LighterASTNode getCodeBlock(@Nullable LighterASTNode parent) {
        return LightTreeUtil.firstChildOfType(this.myTree, parent, JavaElementType.CODE_BLOCK);
    }

    @NotNull
    static List<LighterASTNode> getStatements(@Nullable LighterASTNode codeBlock, LighterAST tree) {
        List<LighterASTNode> list = codeBlock == null ? Collections.emptyList() : LightTreeUtil.getChildrenOfType(tree, codeBlock, ElementType.JAVA_STATEMENT_BIT_SET);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getStatements"));
        }
        return list;
    }

    @Nullable
    private List<PreContract> handleDelegation(@Nullable LighterASTNode expression, boolean negated) {
        if (expression == null) {
            return null;
        }
        if (expression.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild(this.myTree, expression), negated);
        }
        if (this.isNegationExpression(expression)) {
            return this.handleDelegation(JavaLightTreeUtil.findExpressionChild(this.myTree, expression), !negated);
        }
        if (expression.getTokenType() == JavaElementType.METHOD_CALL_EXPRESSION) {
            return Collections.singletonList(new DelegationContract(ExpressionRange.create(expression, this.myBody.getStartOffset()), negated));
        }
        return null;
    }

    private boolean isNegationExpression(@Nullable LighterASTNode expression) {
        return expression != null && expression.getTokenType() == JavaElementType.PREFIX_EXPRESSION && LightTreeUtil.firstChildOfType(this.myTree, expression, JavaTokenType.EXCL) != null;
    }

    @NotNull
    private List<PreContract> visitExpression(List<MethodContract.ValueConstraint[]> states, @Nullable LighterASTNode expr) {
        int parameter;
        if (expr == null) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (states.isEmpty()) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (states.size() > 300) {
            List<PreContract> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        IElementType type = expr.getTokenType();
        if (type == JavaElementType.POLYADIC_EXPRESSION || type == JavaElementType.BINARY_EXPRESSION) {
            List<PreContract> list = this.visitPolyadic(states, expr);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (type == JavaElementType.CONDITIONAL_EXPRESSION) {
            List<LighterASTNode> children = JavaLightTreeUtil.getExpressionChildren(this.myTree, expr);
            if (children.size() != 3) {
                List<PreContract> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
                }
                return list;
            }
            List<PreContract> conditionResults = this.visitExpression(states, children.get(0));
            List<PreContract> list = ContainerUtil.concat(this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.TRUE_VALUE), children.get(1)), this.visitExpression(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE), children.get(2)));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (type == JavaElementType.PARENTH_EXPRESSION) {
            List<PreContract> list = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (type == JavaElementType.TYPE_CAST_EXPRESSION) {
            List<PreContract> list = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (this.isNegationExpression(expr)) {
            List<PreContract> list = ContainerUtil.mapNotNull(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, expr)), PreContract::negate);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (type == JavaElementType.INSTANCE_OF_EXPRESSION && (parameter = this.resolveParameter(JavaLightTreeUtil.findExpressionChild(this.myTree, expr))) >= 0) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(ContainerUtil.mapNotNull(states, state -> ContractInferenceInterpreter.contractWithConstraint(state, parameter, MethodContract.ValueConstraint.NULL_VALUE, MethodContract.ValueConstraint.FALSE_VALUE)));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (type == JavaElementType.NEW_EXPRESSION || type == JavaElementType.THIS_EXPRESSION) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, MethodContract.ValueConstraint.NOT_NULL_VALUE));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        if (type == JavaElementType.METHOD_CALL_EXPRESSION) {
            List<PreContract> list = Collections.singletonList(new MethodCallContract(ExpressionRange.create(expr, this.myBody.getStartOffset()), ContainerUtil.map(states, Arrays::asList)));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        MethodContract.ValueConstraint constraint = this.getLiteralConstraint(expr);
        if (constraint != null) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, constraint));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        int paramIndex = this.resolveParameter(expr);
        if (paramIndex >= 0) {
            ArrayList<StandardMethodContract> result = ContainerUtil.newArrayList();
            for (MethodContract.ValueConstraint[] state2 : states) {
                if (state2[paramIndex] != MethodContract.ValueConstraint.ANY_VALUE) {
                    result.add(new StandardMethodContract(state2, state2[paramIndex]));
                    continue;
                }
                if (JavaTokenType.BOOLEAN_KEYWORD != this.getPrimitiveParameterType(paramIndex)) continue;
                ContainerUtil.addIfNotNull(result, ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, MethodContract.ValueConstraint.TRUE_VALUE, MethodContract.ValueConstraint.TRUE_VALUE));
                ContainerUtil.addIfNotNull(result, ContractInferenceInterpreter.contractWithConstraint(state2, paramIndex, MethodContract.ValueConstraint.FALSE_VALUE, MethodContract.ValueConstraint.FALSE_VALUE));
            }
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(result);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
            }
            return list;
        }
        List<PreContract> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitExpression"));
        }
        return list;
    }

    @NotNull
    private List<PreContract> visitPolyadic(List<MethodContract.ValueConstraint[]> states, @NotNull LighterASTNode expr) {
        boolean logicalAnd;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
        }
        if (LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.PLUS) != null) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(ContainerUtil.map(states, s -> new StandardMethodContract((MethodContract.ValueConstraint[])s, MethodContract.ValueConstraint.NOT_NULL_VALUE)));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
            }
            return list;
        }
        List<LighterASTNode> operands = JavaLightTreeUtil.getExpressionChildren(this.myTree, expr);
        if (operands.size() == 2) {
            boolean equality;
            boolean bl = equality = LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.EQEQ) != null;
            if (equality || LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.NE) != null) {
                List<PreContract> list = ContractInferenceInterpreter.asPreContracts(this.visitEqualityComparison(states, operands.get(0), operands.get(1), equality));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
                }
                return list;
            }
        }
        boolean bl = logicalAnd = LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.ANDAND) != null;
        if (logicalAnd || LightTreeUtil.firstChildOfType(this.myTree, expr, JavaTokenType.OROR) != null) {
            List<PreContract> list = ContractInferenceInterpreter.asPreContracts(this.visitLogicalOperation(operands, logicalAnd, states));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
            }
            return list;
        }
        List<PreContract> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitPolyadic"));
        }
        return list;
    }

    @NotNull
    private static List<PreContract> asPreContracts(List<StandardMethodContract> contracts2) {
        List<PreContract> list = ContainerUtil.map(contracts2, KnownContract::new);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "asPreContracts"));
        }
        return list;
    }

    @Nullable
    private static StandardMethodContract contractWithConstraint(MethodContract.ValueConstraint[] state, int parameter, MethodContract.ValueConstraint paramConstraint, MethodContract.ValueConstraint returnValue) {
        MethodContract.ValueConstraint[] newState = ContractInferenceInterpreter.withConstraint(state, parameter, paramConstraint);
        return newState == null ? null : new StandardMethodContract(newState, returnValue);
    }

    private List<StandardMethodContract> visitEqualityComparison(List<MethodContract.ValueConstraint[]> states, LighterASTNode op1, LighterASTNode op2, boolean equality) {
        int parameter = this.resolveParameter(op1);
        MethodContract.ValueConstraint constraint = this.getLiteralConstraint(op2);
        if (parameter < 0 || constraint == null) {
            parameter = this.resolveParameter(op2);
            constraint = this.getLiteralConstraint(op1);
        }
        if (parameter >= 0 && constraint != null) {
            ArrayList<StandardMethodContract> result = ContainerUtil.newArrayList();
            for (MethodContract.ValueConstraint[] state : states) {
                if (constraint == MethodContract.ValueConstraint.NOT_NULL_VALUE) {
                    if (this.getPrimitiveParameterType(parameter) != null) continue;
                    ContainerUtil.addIfNotNull(result, ContractInferenceInterpreter.contractWithConstraint(state, parameter, MethodContract.ValueConstraint.NULL_VALUE, equality ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE));
                    continue;
                }
                ContainerUtil.addIfNotNull(result, ContractInferenceInterpreter.contractWithConstraint(state, parameter, constraint, equality ? MethodContract.ValueConstraint.TRUE_VALUE : MethodContract.ValueConstraint.FALSE_VALUE));
                ContainerUtil.addIfNotNull(result, ContractInferenceInterpreter.contractWithConstraint(state, parameter, ContractInferenceInterpreter.negateConstraint(constraint), equality ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Nullable
    private IElementType getPrimitiveParameterType(int paramIndex) {
        LighterASTNode typeElement = LightTreeUtil.firstChildOfType(this.myTree, this.getParameters().get(paramIndex), JavaElementType.TYPE);
        LighterASTNode primitive = LightTreeUtil.firstChildOfType(this.myTree, typeElement, ElementType.PRIMITIVE_TYPE_BIT_SET);
        return primitive == null ? null : primitive.getTokenType();
    }

    static List<StandardMethodContract> toContracts(List<MethodContract.ValueConstraint[]> states, MethodContract.ValueConstraint constraint) {
        return ContainerUtil.map(states, state -> new StandardMethodContract((MethodContract.ValueConstraint[])state, constraint));
    }

    private List<StandardMethodContract> visitLogicalOperation(List<LighterASTNode> operands, boolean conjunction, List<MethodContract.ValueConstraint[]> states) {
        MethodContract.ValueConstraint breakValue = conjunction ? MethodContract.ValueConstraint.FALSE_VALUE : MethodContract.ValueConstraint.TRUE_VALUE;
        ArrayList<StandardMethodContract> finalStates = ContainerUtil.newArrayList();
        for (LighterASTNode operand : operands) {
            List<PreContract> opResults = this.visitExpression(states, operand);
            finalStates.addAll(ContainerUtil.filter(ContractInferenceInterpreter.knownContracts(opResults), contract -> contract.returnValue == breakValue));
            states = ContractInferenceInterpreter.antecedentsReturning(opResults, ContractInferenceInterpreter.negateConstraint(breakValue));
        }
        finalStates.addAll(ContractInferenceInterpreter.toContracts(states, ContractInferenceInterpreter.negateConstraint(breakValue)));
        return finalStates;
    }

    private static List<StandardMethodContract> knownContracts(List<PreContract> values) {
        return ContainerUtil.mapNotNull(values, pc -> pc instanceof KnownContract ? ((KnownContract)pc).getContract() : null);
    }

    private static List<MethodContract.ValueConstraint[]> antecedentsReturning(List<PreContract> values, MethodContract.ValueConstraint result) {
        return ContainerUtil.mapNotNull(ContractInferenceInterpreter.knownContracts(values), contract -> contract.returnValue == result ? contract.arguments : null);
    }

    @NotNull
    private List<PreContract> visitStatements(List<MethodContract.ValueConstraint[]> states, List<LighterASTNode> statements) {
        CodeBlockContracts result = new CodeBlockContracts();
        for (LighterASTNode statement : statements) {
            List<PreContract> conditionResults;
            IElementType type = statement.getTokenType();
            if (type == JavaElementType.BLOCK_STATEMENT) {
                result.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(this.getCodeBlock(statement), this.myTree)));
                break;
            }
            if (type == JavaElementType.IF_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement));
                List<LighterASTNode> thenElse = ContractInferenceInterpreter.getStatements(statement, this.myTree);
                if (thenElse.size() > 0) {
                    result.addAll(this.visitStatements(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.TRUE_VALUE), Collections.singletonList(thenElse.get(0))));
                }
                List<MethodContract.ValueConstraint[]> falseStates = ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE);
                if (thenElse.size() > 1) {
                    result.addAll(this.visitStatements(falseStates, Collections.singletonList(thenElse.get(1))));
                    break;
                }
                states = falseStates;
                continue;
            }
            if (type == JavaElementType.WHILE_STATEMENT) {
                states = ContractInferenceInterpreter.antecedentsReturning(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement)), MethodContract.ValueConstraint.FALSE_VALUE);
                continue;
            }
            if (type == JavaElementType.THROW_STATEMENT) {
                result.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(states, MethodContract.ValueConstraint.THROW_EXCEPTION)));
                break;
            }
            if (type == JavaElementType.RETURN_STATEMENT) {
                result.addAll(this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement)));
                break;
            }
            if (type == JavaElementType.ASSERT_STATEMENT) {
                conditionResults = this.visitExpression(states, JavaLightTreeUtil.findExpressionChild(this.myTree, statement));
                result.addAll(ContractInferenceInterpreter.asPreContracts(ContractInferenceInterpreter.toContracts(ContractInferenceInterpreter.antecedentsReturning(conditionResults, MethodContract.ValueConstraint.FALSE_VALUE), MethodContract.ValueConstraint.THROW_EXCEPTION)));
                break;
            }
            if (type == JavaElementType.DECLARATION_STATEMENT) {
                result.registerDeclaration(statement, this.myTree, this.myBody.getStartOffset());
                continue;
            }
            if (type != JavaElementType.DO_WHILE_STATEMENT) break;
            result.addAll(this.visitStatements(states, ContractInferenceInterpreter.getStatements(statement, this.myTree)));
            break;
        }
        List<PreContract> list = result.accumulated;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "visitStatements"));
        }
        return list;
    }

    @Nullable
    private MethodContract.ValueConstraint getLiteralConstraint(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.LITERAL_EXPRESSION) {
            return ContractInferenceInterpreter.getLiteralConstraint(this.myTree.getChildren(expr).get(0).getTokenType());
        }
        return null;
    }

    @NotNull
    static MethodContract.ValueConstraint getLiteralConstraint(@NotNull IElementType literalTokenType) {
        if (literalTokenType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalTokenType", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
        }
        if (literalTokenType.equals(JavaTokenType.TRUE_KEYWORD)) {
            MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.TRUE_VALUE;
            if (valueConstraint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
            }
            return valueConstraint;
        }
        if (literalTokenType.equals(JavaTokenType.FALSE_KEYWORD)) {
            MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.FALSE_VALUE;
            if (valueConstraint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
            }
            return valueConstraint;
        }
        if (literalTokenType.equals(JavaTokenType.NULL_KEYWORD)) {
            MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.NULL_VALUE;
            if (valueConstraint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
            }
            return valueConstraint;
        }
        MethodContract.ValueConstraint valueConstraint = MethodContract.ValueConstraint.NOT_NULL_VALUE;
        if (valueConstraint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "getLiteralConstraint"));
        }
        return valueConstraint;
    }

    static MethodContract.ValueConstraint negateConstraint(@NotNull MethodContract.ValueConstraint constraint) {
        if (constraint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraint", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter", "negateConstraint"));
        }
        switch (constraint) {
            case NULL_VALUE: {
                return MethodContract.ValueConstraint.NOT_NULL_VALUE;
            }
            case NOT_NULL_VALUE: {
                return MethodContract.ValueConstraint.NULL_VALUE;
            }
            case TRUE_VALUE: {
                return MethodContract.ValueConstraint.FALSE_VALUE;
            }
            case FALSE_VALUE: {
                return MethodContract.ValueConstraint.TRUE_VALUE;
            }
        }
        return constraint;
    }

    private int resolveParameter(@Nullable LighterASTNode expr) {
        if (expr != null && expr.getTokenType() == JavaElementType.REFERENCE_EXPRESSION && JavaLightTreeUtil.findExpressionChild(this.myTree, expr) == null) {
            String name = JavaLightTreeUtil.getNameIdentifierText(this.myTree, expr);
            if (name == null) {
                return -1;
            }
            List<LighterASTNode> parameters = this.getParameters();
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                if (!name.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, parameters.get(i2)))) continue;
                return i2;
            }
        }
        return -1;
    }

    @Nullable
    static MethodContract.ValueConstraint[] withConstraint(MethodContract.ValueConstraint[] constraints, int index, MethodContract.ValueConstraint constraint) {
        if (constraints[index] == constraint) {
            return constraints;
        }
        MethodContract.ValueConstraint negated = ContractInferenceInterpreter.negateConstraint(constraint);
        if (negated != constraint && constraints[index] == negated) {
            return null;
        }
        MethodContract.ValueConstraint[] copy = (MethodContract.ValueConstraint[])constraints.clone();
        copy[index] = constraint;
        return copy;
    }

    private static class CodeBlockContracts {
        List<PreContract> accumulated = new ArrayList<PreContract>();
        List<ExpressionRange> varInitializers = new ArrayList<ExpressionRange>();

        private CodeBlockContracts() {
        }

        void addAll(List<PreContract> contracts2) {
            if (contracts2.isEmpty()) {
                return;
            }
            if (this.varInitializers.isEmpty()) {
                this.accumulated.addAll(contracts2);
            } else {
                this.accumulated.add(new SideEffectFilter(this.varInitializers, contracts2));
            }
        }

        void registerDeclaration(@NotNull LighterASTNode declStatement, @NotNull LighterAST tree, int scopeStart) {
            if (declStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declStatement", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter$CodeBlockContracts", "registerDeclaration"));
            }
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/codeInspection/dataFlow/ContractInferenceInterpreter$CodeBlockContracts", "registerDeclaration"));
            }
            for (LighterASTNode var : LightTreeUtil.getChildrenOfType(tree, declStatement, JavaElementType.LOCAL_VARIABLE)) {
                LighterASTNode initializer = JavaLightTreeUtil.findExpressionChild(tree, var);
                if (initializer == null) continue;
                this.varInitializers.add(ExpressionRange.create(initializer, scopeStart));
            }
        }
    }
}

