/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomMethodHandlers {
    private static final CallMapper<CustomMethodHandler> CUSTOM_METHOD_HANDLERS = new CallMapper<CustomMethodHandler>().register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "indexOf", "lastIndexOf"), (args, memState, factory) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory, SpecialField.STRING_LENGTH)).register((CallMatcher)CallMatcher.instanceCall("java.util.List", "indexOf", "lastIndexOf"), (args, memState, factory) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory, SpecialField.COLLECTION_SIZE)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "equals").parameterCount(1), (args, memState, factory) -> CustomMethodHandlers.stringEquals(args, memState, factory, false)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "equalsIgnoreCase").parameterCount(1), (args, memState, factory) -> CustomMethodHandlers.stringEquals(args, memState, factory, true)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "startsWith").parameterCount(1), (args, memState, factory) -> CustomMethodHandlers.stringStartsEnds(args, memState, factory, false)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "endsWith").parameterCount(1), (args, memState, factory) -> CustomMethodHandlers.stringStartsEnds(args, memState, factory, true)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "max").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Math", "max").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Integer", "max").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "max").parameterTypes("long", "long")), (args, memState, factory) -> CustomMethodHandlers.mathMinMax(args.myArguments, memState, factory, true)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "min").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Math", "min").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Integer", "min").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "min").parameterTypes("long", "long")), (args, memState, factory) -> CustomMethodHandlers.mathMinMax(args.myArguments, memState, factory, false)).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("int"), (args, memState, factory) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, factory, false)).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("long"), (args, memState, factory) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, factory, true));

    public static CustomMethodHandler find(PsiMethodCallExpression call) {
        return CUSTOM_METHOD_HANDLERS.mapFirst(call);
    }

    private static List<DfaMemoryState> stringStartsEnds(DfaCallArguments args, DfaMemoryState memState, DfaValueFactory factory, boolean ends) {
        DfaValue arg = ArrayUtil.getFirstElement(args.myArguments);
        if (arg == null) {
            return Collections.emptyList();
        }
        String leftConst = ObjectUtils.tryCast(CustomMethodHandlers.getConstantValue(memState, args.myQualifier), String.class);
        String rightConst = ObjectUtils.tryCast(CustomMethodHandlers.getConstantValue(memState, arg), String.class);
        if (leftConst != null && rightConst != null) {
            return CustomMethodHandlers.singleResult(memState, factory.getBoolean(ends ? leftConst.endsWith(rightConst) : leftConst.startsWith(rightConst)));
        }
        DfaValue leftLength = SpecialField.STRING_LENGTH.createValue(factory, args.myQualifier);
        DfaValue rightLength = SpecialField.STRING_LENGTH.createValue(factory, arg);
        DfaValue trueRelation = factory.createCondition(leftLength, DfaRelationValue.RelationType.GE, rightLength);
        DfaValue falseRelation = factory.createCondition(leftLength, DfaRelationValue.RelationType.LT, rightLength);
        return CustomMethodHandlers.applyCondition(memState, trueRelation, DfaUnknownValue.getInstance(), falseRelation, factory.getBoolean(false));
    }

    private static List<DfaMemoryState> stringEquals(DfaCallArguments args, DfaMemoryState memState, DfaValueFactory factory, boolean ignoreCase) {
        DfaValue arg = ArrayUtil.getFirstElement(args.myArguments);
        if (arg == null) {
            return Collections.emptyList();
        }
        String leftConst = ObjectUtils.tryCast(CustomMethodHandlers.getConstantValue(memState, args.myQualifier), String.class);
        String rightConst = ObjectUtils.tryCast(CustomMethodHandlers.getConstantValue(memState, arg), String.class);
        if (leftConst != null && rightConst != null) {
            return CustomMethodHandlers.singleResult(memState, factory.getBoolean(ignoreCase ? leftConst.equalsIgnoreCase(rightConst) : leftConst.equals(rightConst)));
        }
        DfaValue leftLength = SpecialField.STRING_LENGTH.createValue(factory, args.myQualifier);
        DfaValue rightLength = SpecialField.STRING_LENGTH.createValue(factory, arg);
        DfaValue trueRelation = factory.createCondition(leftLength, DfaRelationValue.RelationType.EQ, rightLength);
        DfaValue falseRelation = factory.createCondition(leftLength, DfaRelationValue.RelationType.NE, rightLength);
        return CustomMethodHandlers.applyCondition(memState, trueRelation, DfaUnknownValue.getInstance(), falseRelation, factory.getBoolean(false));
    }

    private static List<DfaMemoryState> indexOf(DfaValue qualifier, DfaMemoryState memState, DfaValueFactory factory, SpecialField specialField) {
        DfaValue length = specialField.createValue(factory, qualifier);
        LongRangeSet range = memState.getRange(length);
        long maxLen = range == null || range.isEmpty() ? Integer.MAX_VALUE : range.max();
        return CustomMethodHandlers.singleResult(memState, factory.getRangeFactory().create(LongRangeSet.range(-1L, maxLen - 1L)));
    }

    private static List<DfaMemoryState> mathMinMax(DfaValue[] args, DfaMemoryState memState, DfaValueFactory factory, boolean max) {
        if (args == null || args.length != 2) {
            return Collections.emptyList();
        }
        LongRangeSet first = memState.getRange(args[0]);
        LongRangeSet second = memState.getRange(args[1]);
        if (first == null || second == null || first.isEmpty() || second.isEmpty()) {
            return Collections.emptyList();
        }
        LongRangeSet domain = max ? LongRangeSet.range(Math.max(first.min(), second.min()), Long.MAX_VALUE) : LongRangeSet.range(Long.MIN_VALUE, Math.min(first.max(), second.max()));
        LongRangeSet result = first.union(second).intersect(domain);
        return CustomMethodHandlers.singleResult(memState, factory.getRangeFactory().create(result));
    }

    private static List<DfaMemoryState> mathAbs(DfaValue[] args, DfaMemoryState memState, DfaValueFactory factory, boolean isLong) {
        DfaValue arg = ArrayUtil.getFirstElement(args);
        if (arg == null) {
            return Collections.emptyList();
        }
        LongRangeSet range = memState.getRange(arg);
        if (range == null) {
            return Collections.emptyList();
        }
        return CustomMethodHandlers.singleResult(memState, factory.getRangeFactory().create(range.abs(isLong)));
    }

    private static List<DfaMemoryState> singleResult(DfaMemoryState state, DfaValue value) {
        state.push(value);
        return Collections.singletonList(state);
    }

    @NotNull
    private static List<DfaMemoryState> applyCondition(DfaMemoryState memState, DfaValue trueCondition, DfaValue trueResult, DfaValue falseCondition, DfaValue falseResult) {
        DfaMemoryState falseState = memState.createCopy();
        ArrayList<DfaMemoryState> result = new ArrayList<DfaMemoryState>(2);
        if (memState.applyCondition(trueCondition)) {
            memState.push(trueResult);
            result.add(memState);
        }
        if (falseState.applyCondition(falseCondition)) {
            falseState.push(falseResult);
            result.add(falseState);
        }
        ArrayList<DfaMemoryState> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/CustomMethodHandlers", "applyCondition"));
        }
        return arrayList;
    }

    private static Object getConstantValue(DfaMemoryState memoryState, DfaValue value) {
        if (value instanceof DfaVariableValue) {
            value = memoryState.getConstantValue((DfaVariableValue)value);
        }
        if (value instanceof DfaConstValue) {
            return ((DfaConstValue)value).getValue();
        }
        return null;
    }

    static interface CustomMethodHandler {
        public List<DfaMemoryState> handle(DfaCallArguments var1, DfaMemoryState var2, DfaValueFactory var3);
    }
}

