/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfaVariableState {
    @NotNull
    final Set<DfaPsiType> myInstanceofValues;
    @NotNull
    final Set<DfaPsiType> myNotInstanceofValues;
    @NotNull
    final Nullness myNullability;
    @NotNull
    final ThreeState myOptionalPresence;
    @Nullable
    final LongRangeSet myRange;
    private final int myHash;

    DfaVariableState(@NotNull DfaVariableValue dfaVar) {
        if (dfaVar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaVar", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        this(Collections.emptySet(), Collections.emptySet(), dfaVar.getInherentNullability(), ThreeState.UNSURE, DfaVariableState.getInitialRange(dfaVar));
    }

    public boolean isSuperStateOf(DfaVariableState that) {
        if (!this.myNotInstanceofValues.equals(that.myNotInstanceofValues)) {
            return false;
        }
        if (!this.myInstanceofValues.equals(that.myNotInstanceofValues)) {
            return false;
        }
        if (!this.myNullability.equals((Object)that.myNullability)) {
            return false;
        }
        if (!this.myOptionalPresence.equals((Object)that.myOptionalPresence)) {
            return false;
        }
        if (Objects.equals(this.myRange, that.myRange)) {
            return true;
        }
        return this.myRange != null && that.myRange != null && this.myRange.contains(that.myRange);
    }

    private static LongRangeSet getInitialRange(DfaVariableValue var) {
        DfaVariableValue qualifier = var.getQualifier();
        if (qualifier != null) {
            PsiModifierListOwner owner = var.getPsiVariable();
            for (SpecialField sf : SpecialField.values()) {
                if (!sf.isMyAccessor(owner)) continue;
                return sf.getRange();
            }
        }
        return LongRangeSet.fromType(var.getVariableType());
    }

    DfaVariableState(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues, @NotNull Nullness nullability, @NotNull ThreeState optionalPresence, @Nullable LongRangeSet range) {
        if (instanceofValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceofValues", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        if (notInstanceofValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notInstanceofValues", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        if (nullability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullability", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        if (optionalPresence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionalPresence", "com/intellij/codeInspection/dataFlow/DfaVariableState", "<init>"));
        }
        this.myInstanceofValues = instanceofValues;
        this.myNotInstanceofValues = notInstanceofValues;
        this.myNullability = nullability;
        this.myOptionalPresence = optionalPresence;
        this.myRange = range;
        this.myHash = Objects.hash(new Object[]{this.myInstanceofValues, this.myNotInstanceofValues, this.myNullability, this.myOptionalPresence, range});
    }

    public boolean isNullable() {
        return this.myNullability == Nullness.NULLABLE;
    }

    private boolean checkInstanceofValue(@NotNull DfaPsiType dfaType) {
        if (dfaType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaType", "com/intellij/codeInspection/dataFlow/DfaVariableState", "checkInstanceofValue"));
        }
        if (this.myInstanceofValues.contains(dfaType)) {
            return true;
        }
        for (DfaPsiType dfaTypeValue : this.myNotInstanceofValues) {
            if (!dfaTypeValue.isAssignableFrom(dfaType)) continue;
            return false;
        }
        for (DfaPsiType dfaTypeValue : this.myInstanceofValues) {
            if (dfaType.isConvertibleFrom(dfaTypeValue)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    DfaVariableState withInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaType", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withInstanceofValue"));
        }
        if (dfaType.getDfaType().getPsiType() instanceof PsiPrimitiveType) {
            return this;
        }
        if (this.checkInstanceofValue(dfaType.getDfaType())) {
            DfaVariableState result = dfaType.isNullable() ? this.withNullability(Nullness.NULLABLE) : this;
            ArrayList moreGeneric = ContainerUtil.newArrayList();
            for (DfaPsiType alreadyInstanceof : this.myInstanceofValues) {
                if (dfaType.getDfaType().isAssignableFrom(alreadyInstanceof)) {
                    return result;
                }
                if (!alreadyInstanceof.isAssignableFrom(dfaType.getDfaType())) continue;
                moreGeneric.add(alreadyInstanceof);
            }
            HashSet<DfaPsiType> newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.removeAll(moreGeneric);
            newInstanceof.add(dfaType.getDfaType());
            result = this.createCopy(newInstanceof, this.myNotInstanceofValues, result.myNullability, this.myOptionalPresence, this.myRange);
            return result;
        }
        return null;
    }

    @Nullable
    DfaVariableState withNotInstanceofValue(@NotNull DfaTypeValue dfaType) {
        if (dfaType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfaType", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withNotInstanceofValue"));
        }
        if (this.myNotInstanceofValues.contains(dfaType.getDfaType())) {
            return this;
        }
        for (DfaPsiType dfaPsiType : this.myInstanceofValues) {
            if (!dfaType.getDfaType().isAssignableFrom(dfaPsiType)) continue;
            return null;
        }
        ArrayList moreSpecific = ContainerUtil.newArrayList();
        for (DfaPsiType alreadyNotInstanceof : this.myNotInstanceofValues) {
            if (alreadyNotInstanceof.isAssignableFrom(dfaType.getDfaType())) {
                return this;
            }
            if (!dfaType.getDfaType().isAssignableFrom(alreadyNotInstanceof)) continue;
            moreSpecific.add(alreadyNotInstanceof);
        }
        HashSet<DfaPsiType> hashSet = ContainerUtil.newHashSet(this.myNotInstanceofValues);
        hashSet.removeAll(moreSpecific);
        hashSet.add(dfaType.getDfaType());
        return this.createCopy(this.myInstanceofValues, hashSet, this.myNullability, this.myOptionalPresence, this.myRange);
    }

    @NotNull
    DfaVariableState withoutType(@NotNull DfaPsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withoutType"));
        }
        if (this.myInstanceofValues.contains(type)) {
            HashSet<DfaPsiType> newInstanceof = ContainerUtil.newHashSet(this.myInstanceofValues);
            newInstanceof.remove(type);
            DfaVariableState dfaVariableState = this.createCopy(newInstanceof, this.myNotInstanceofValues, this.myNullability, this.myOptionalPresence, this.myRange);
            if (dfaVariableState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withoutType"));
            }
            return dfaVariableState;
        }
        if (this.myNotInstanceofValues.contains(type)) {
            HashSet<DfaPsiType> newNotInstanceof = ContainerUtil.newHashSet(this.myNotInstanceofValues);
            newNotInstanceof.remove(type);
            DfaVariableState dfaVariableState = this.createCopy(this.myInstanceofValues, newNotInstanceof, this.myNullability, this.myOptionalPresence, this.myRange);
            if (dfaVariableState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withoutType"));
            }
            return dfaVariableState;
        }
        DfaVariableState dfaVariableState = this;
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withoutType"));
        }
        return dfaVariableState;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaVariableState)) {
            return false;
        }
        DfaVariableState aState = (DfaVariableState)obj;
        return this.myHash == aState.myHash && this.myNullability == aState.myNullability && this.myOptionalPresence == aState.myOptionalPresence && this.myInstanceofValues.equals(aState.myInstanceofValues) && this.myNotInstanceofValues.equals(aState.myNotInstanceofValues) && Objects.equals(this.myRange, aState.myRange);
    }

    @NotNull
    protected DfaVariableState createCopy(@NotNull Set<DfaPsiType> instanceofValues, @NotNull Set<DfaPsiType> notInstanceofValues, @NotNull Nullness nullability, ThreeState optionalPresent, LongRangeSet range) {
        if (instanceofValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceofValues", "com/intellij/codeInspection/dataFlow/DfaVariableState", "createCopy"));
        }
        if (notInstanceofValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notInstanceofValues", "com/intellij/codeInspection/dataFlow/DfaVariableState", "createCopy"));
        }
        if (nullability == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullability", "com/intellij/codeInspection/dataFlow/DfaVariableState", "createCopy"));
        }
        DfaVariableState dfaVariableState = new DfaVariableState(instanceofValues, notInstanceofValues, nullability, optionalPresent, range);
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "createCopy"));
        }
        return dfaVariableState;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append((Object)this.myNullability);
        if (!this.myInstanceofValues.isEmpty()) {
            buf.append(" instanceof ").append(StringUtil.join(this.myInstanceofValues, ","));
        }
        if (!this.myNotInstanceofValues.isEmpty()) {
            buf.append(" not instanceof ").append(StringUtil.join(this.myNotInstanceofValues, ","));
        }
        if (this.myOptionalPresence != ThreeState.UNSURE) {
            buf.append(this.myOptionalPresence == ThreeState.YES ? " Optional with value" : " empty Optional");
        }
        if (this.myRange != null) {
            buf.append(" ").append(this.myRange);
        }
        return buf.toString();
    }

    @NotNull
    Nullness getNullability() {
        Nullness nullness = this.myNullability;
        if (nullness == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "getNullability"));
        }
        return nullness;
    }

    public boolean isNotNull() {
        return this.myNullability == Nullness.NOT_NULL;
    }

    @NotNull
    DfaVariableState withNullability(@NotNull Nullness nullness) {
        if (nullness == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullness", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withNullability"));
        }
        DfaVariableState dfaVariableState = this.myNullability == nullness ? this : this.createCopy(this.myInstanceofValues, this.myNotInstanceofValues, nullness, this.myOptionalPresence, this.myRange);
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withNullability"));
        }
        return dfaVariableState;
    }

    @NotNull
    DfaVariableState withNullable(boolean nullable) {
        DfaVariableState dfaVariableState = this.myNullability != Nullness.NOT_NULL ? this.withNullability(nullable ? Nullness.NULLABLE : Nullness.UNKNOWN) : this;
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withNullable"));
        }
        return dfaVariableState;
    }

    DfaVariableState withOptionalPresense(boolean presense) {
        ThreeState optionalPresent = ThreeState.fromBoolean(presense);
        return this.myOptionalPresence != optionalPresent ? this.createCopy(this.myInstanceofValues, this.myNotInstanceofValues, this.myNullability, optionalPresent, this.myRange) : this;
    }

    DfaVariableState withRange(@Nullable LongRangeSet range) {
        return Objects.equals(range, this.myRange) ? this : this.createCopy(this.myInstanceofValues, this.myNotInstanceofValues, this.myNullability, this.myOptionalPresence, range);
    }

    @NotNull
    public DfaVariableState withValue(DfaValue value) {
        DfaVariableState dfaVariableState = this;
        if (dfaVariableState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "withValue"));
        }
        return dfaVariableState;
    }

    @Nullable
    public DfaValue getValue() {
        return null;
    }

    @NotNull
    public Set<DfaPsiType> getInstanceofValues() {
        Set<DfaPsiType> set = this.myInstanceofValues;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "getInstanceofValues"));
        }
        return set;
    }

    @NotNull
    public Set<DfaPsiType> getNotInstanceofValues() {
        Set<DfaPsiType> set = this.myNotInstanceofValues;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/DfaVariableState", "getNotInstanceofValues"));
        }
        return set;
    }

    public ThreeState getOptionalPresense() {
        return this.myOptionalPresence;
    }

    @Nullable
    public LongRangeSet getRange() {
        return this.myRange;
    }
}

