/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.FontPreferences;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class DelegatingFontPreferences
implements FontPreferences {
    private Supplier<FontPreferences> myDelegateSupplier;

    public DelegatingFontPreferences(@NotNull Supplier<FontPreferences> delegateSupplier) {
        if (delegateSupplier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateSupplier", "com/intellij/openapi/editor/colors/DelegatingFontPreferences", "<init>"));
        }
        this.myDelegateSupplier = delegateSupplier;
    }

    @Override
    @NotNull
    public List<String> getEffectiveFontFamilies() {
        List<String> list = this.myDelegateSupplier.get().getEffectiveFontFamilies();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/DelegatingFontPreferences", "getEffectiveFontFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getRealFontFamilies() {
        List<String> list = this.myDelegateSupplier.get().getRealFontFamilies();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/DelegatingFontPreferences", "getRealFontFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getFontFamily() {
        String string = this.myDelegateSupplier.get().getFontFamily();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/DelegatingFontPreferences", "getFontFamily"));
        }
        return string;
    }

    @Override
    public int getSize(@NotNull String fontFamily) {
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/DelegatingFontPreferences", "getSize"));
        }
        return this.myDelegateSupplier.get().getSize(fontFamily);
    }

    @Override
    public void copyTo(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/DelegatingFontPreferences", "copyTo"));
        }
        this.myDelegateSupplier.get().copyTo(preferences);
    }

    @Override
    public boolean useLigatures() {
        return this.myDelegateSupplier.get().useLigatures();
    }

    @Override
    public boolean hasSize(@NotNull String fontName) {
        if (fontName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontName", "com/intellij/openapi/editor/colors/DelegatingFontPreferences", "hasSize"));
        }
        return this.myDelegateSupplier.get().hasSize(fontName);
    }

    @Override
    public float getLineSpacing() {
        return this.myDelegateSupplier.get().getLineSpacing();
    }
}

