/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FontPreferences {
    @NonNls
    @NotNull
    public static final String DEFAULT_FONT_NAME = FontPreferences.getDefaultFontName();
    public static final int DEFAULT_FONT_SIZE = FontSize.SMALL.getSize();
    public static final float DEFAULT_LINE_SPACING = 1.0f;
    public static final String FALLBACK_FONT_FAMILY = "Monospaced";
    public static final String MAC_OS_DEFAULT_FONT_FAMILY = "Menlo";
    public static final String LINUX_DEFAULT_FONT_FAMILY = "DejaVu Sans Mono";
    public static final String WINDOWS_DEFAULT_FONT_FAMILY = "Monospaced";

    @NotNull
    public List<String> getEffectiveFontFamilies();

    @NotNull
    public List<String> getRealFontFamilies();

    @NotNull
    public String getFontFamily();

    public int getSize(@NotNull String var1);

    public void copyTo(@NotNull FontPreferences var1);

    public boolean useLigatures();

    public boolean hasSize(@NotNull String var1);

    public float getLineSpacing();

    @Nullable
    public static String getFallbackName(@NotNull String fontName, int fontSize, @Nullable EditorColorsScheme fallbackScheme) {
        if (fontName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontName", "com/intellij/openapi/editor/colors/FontPreferences", "getFallbackName"));
        }
        Font plainFont = new Font(fontName, 0, fontSize);
        if (plainFont.getFamily().equals("Dialog") && !"Dialog".equals(fontName) && !fontName.startsWith("Dialog.")) {
            return fallbackScheme == null ? DEFAULT_FONT_NAME : fallbackScheme.getEditorFontName();
        }
        return null;
    }

    public static String getDefaultFontName() {
        if (SystemInfo.isWindows) {
            return "Monospaced";
        }
        if (SystemInfo.isMacOSSnowLeopard) {
            return MAC_OS_DEFAULT_FONT_FAMILY;
        }
        if (SystemInfo.isXWindow && !GraphicsEnvironment.isHeadless()) {
            for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                if (!LINUX_DEFAULT_FONT_FAMILY.equals(font.getName())) continue;
                return font.getFontName();
            }
        }
        return "Monospaced";
    }
}

