/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class JDOMUtil {
    private static final ThreadLocal<java.lang.ref.SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    public static final Condition<Attribute> NOT_EMPTY_VALUE_CONDITION = new Condition<Attribute>(){

        @Override
        public boolean value(Attribute attribute) {
            return !StringUtil.isEmpty(attribute.getValue());
        }
    };
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        if (parent == null) {
            List<Element> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
            }
            return list;
        }
        List list = parent.getChildren();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
        }
        return list;
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
        }
        if (parent != null) {
            List list = parent.getChildren(name);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
            }
            return list;
        }
        List<Element> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
        }
        return list;
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Comparing.equal(e1.getName(), e2.getName()) && JDOMUtil.attListsEqual(e1.getAttributes(), e2.getAttributes(), ignoreEmptyAttrValues) && JDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER), ignoreEmptyAttrValues);
    }

    public static int getTreeHash(@NotNull Element root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/util/JDOMUtil", "getTreeHash"));
        }
        return JDOMUtil.addToHash(0, root, true);
    }

    private static int addToHash(int i2, @NotNull Element element, boolean skipEmptyText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "addToHash"));
        }
        i2 = JDOMUtil.addToHash(i2, element.getName());
        for (Attribute attribute : element.getAttributes()) {
            i2 = JDOMUtil.addToHash(i2, attribute.getName());
            i2 = JDOMUtil.addToHash(i2, attribute.getValue());
        }
        for (Content child : element.getContent()) {
            if (child instanceof Element) {
                i2 = JDOMUtil.addToHash(i2, (Element)child, skipEmptyText);
                continue;
            }
            if (!(child instanceof Text)) continue;
            String text2 = ((Text)child).getText();
            if (skipEmptyText && StringUtil.isEmptyOrSpaces(text2)) continue;
            i2 = JDOMUtil.addToHash(i2, text2);
        }
        return i2;
    }

    private static int addToHash(int i2, @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/JDOMUtil", "addToHash"));
        }
        return i2 * 31 + s.hashCode();
    }

    @Deprecated
    @NotNull
    public static Element[] getElements(@NotNull Element m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/openapi/util/JDOMUtil", "getElements"));
        }
        List list = m.getChildren();
        Element[] elementArray = list.toArray(new Element[list.size()]);
        if (elementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getElements"));
        }
        return elementArray;
    }

    public static void internElement(@NotNull Element element, @NotNull StringInterner interner) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "internElement"));
        }
        if (interner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interner", "com/intellij/openapi/util/JDOMUtil", "internElement"));
        }
        element.setName(interner.intern(element.getName()));
        for (Attribute attr : element.getAttributes()) {
            attr.setName(interner.intern(attr.getName()));
            attr.setValue(interner.intern(attr.getValue()));
        }
        for (Content o : element.getContent()) {
            if (o instanceof Element) {
                JDOMUtil.internElement((Element)o, interner);
                continue;
            }
            if (!(o instanceof Text)) continue;
            ((Text)o).setText(interner.intern(o.getValue()));
        }
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/JDOMUtil", "legalizeText"));
        }
        String string = JDOMUtil.legalizeChars(str).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "legalizeText"));
        }
        return string;
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/JDOMUtil", "legalizeChars"));
        }
        StringBuilder result = new StringBuilder(str.length());
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            JDOMUtil.appendLegalized(result, str.charAt(i2));
        }
        StringBuilder stringBuilder = result;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "legalizeChars"));
        }
        return stringBuilder;
    }

    private static void appendLegalized(@NotNull StringBuilder sb, char each) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/openapi/util/JDOMUtil", "appendLegalized"));
        }
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter((int)each)) {
            sb.append("0x").append(StringUtil.toUpperCase(Long.toHexString(each)));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(List c1, List c2, boolean ignoreEmptyAttrValues) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator l1 = c1.listIterator();
        ListIterator l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean attListsEqual(@NotNull List<Attribute> l1, @NotNull List<Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (l1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l1", "com/intellij/openapi/util/JDOMUtil", "attListsEqual"));
        }
        if (l2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l2", "com/intellij/openapi/util/JDOMUtil", "attListsEqual"));
        }
        if (ignoreEmptyAttrValues) {
            l1 = ContainerUtil.filter(l1, NOT_EMPTY_VALUE_CONDITION);
            l2 = ContainerUtil.filter(l2, NOT_EMPTY_VALUE_CONDITION);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < l1.size(); ++i2) {
            if (JDOMUtil.attEqual(l1.get(i2), l2.get(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/openapi/util/JDOMUtil", "attEqual"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/openapi/util/JDOMUtil", "attEqual"));
        }
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    private static SAXBuilder getSaxBuilder() {
        java.lang.ref.SoftReference<SAXBuilder> reference = ourSaxBuilder.get();
        SAXBuilder saxBuilder = SoftReference.dereference(reference);
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder(){

                protected void configureParser(XMLReader parser, SAXHandler contentHandler) throws JDOMException {
                    super.configureParser(parser, contentHandler);
                    try {
                        parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                @NotNull
                public InputSource resolveEntity(String publicId, String systemId) {
                    InputSource inputSource = new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                    if (inputSource == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil$3", "resolveEntity"));
                    }
                    return inputSource;
                }
            });
            ourSaxBuilder.set(new java.lang.ref.SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.loadDocument(new CharSequenceReader(seq));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/openapi/util/JDOMUtil", "load"));
        }
        return JDOMUtil.load(new CharSequenceReader(seq));
    }

    @NotNull
    private static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.getSaxBuilder().build(reader);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static Document loadDocument(File file) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(new BufferedInputStream(new FileInputStream(file)));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Element load(@NotNull File file) throws JDOMException, IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/JDOMUtil", "load"));
        }
        Element element = JDOMUtil.load(new BufferedInputStream(new FileInputStream(file)));
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "load"));
        }
        return element;
    }

    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.loadDocument(new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    public static Element load(Reader reader) throws JDOMException, IOException {
        return reader == null ? null : JDOMUtil.loadDocument(reader).detachRootElement();
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.loadDocument(stream).detachRootElement();
    }

    @NotNull
    public static Document loadDocument(@NotNull Class clazz, String resource) throws JDOMException, IOException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        InputStream stream = clazz.getResourceAsStream(resource);
        if (stream == null) {
            throw new FileNotFoundException(resource);
        }
        Document document = JDOMUtil.loadDocument(stream);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.loadDocument(URLUtil.openStream(url));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadResourceDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadResourceDocument"));
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(@NotNull Document document, @NotNull String filePath, String lineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));
        try {
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull File file, String lineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        JDOMUtil.write((Parent)document, file, lineSeparator);
    }

    public static void write(@NotNull Parent element, @NotNull File file) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "write"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/JDOMUtil", "write"));
        }
        JDOMUtil.write(element, file, "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(@NotNull Parent element, @NotNull File file, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "write"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/JDOMUtil", "write"));
        }
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/util/JDOMUtil", "write"));
        }
        FileUtil.createParentDirs(file);
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            JDOMUtil.write(element, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        JDOMUtil.write((Parent)document, stream, lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(@NotNull Parent element, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "write"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/JDOMUtil", "write"));
        }
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/util/JDOMUtil", "write"));
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, CharsetToolkit.UTF8_CHARSET);
        try {
            if (element instanceof Document) {
                JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element, writer, lineSeparator);
            }
        }
        finally {
            writer.close();
        }
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        String string;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException ignored) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
            }
            return "";
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        return string;
    }

    @NotNull
    public static String write(Parent element, String lineSeparator) {
        String string;
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "write"));
        }
        return string;
    }

    public static void write(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof Element) {
            JDOMUtil.writeElement((Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        String string = JDOMUtil.writeElement(element, "\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        return string;
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        return string;
    }

    @NotNull
    public static String writeChildren(@NotNull Element element, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "writeChildren"));
        }
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/util/JDOMUtil", "writeChildren"));
        }
        StringWriter writer = new StringWriter();
        for (Element child : element.getChildren()) {
            JDOMUtil.writeElement(child, writer, lineSeparator);
            writer.append(lineSeparator);
        }
        String string = writer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeChildren"));
        }
        return string;
    }

    public static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        MyXMLOutputter xmlOutputter = new MyXMLOutputter();
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        xmlOutputter.setFormat(format);
        MyXMLOutputter myXMLOutputter = xmlOutputter;
        if (myXMLOutputter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "createOutputter"));
        }
        return myXMLOutputter;
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        String string = JDOMUtil.escapeText(text2, false, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        return string;
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        String string = JDOMUtil.escapeText(text2, false, escapeSpaces, escapeLineEnds);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        return string;
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        StringBuilder buffer = null;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char ch = text2.charAt(i2);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            if (buffer == null) {
                if (quotation == null) continue;
                buffer = new StringBuilder(text2.length() + 20);
                buffer.append(text2, 0, i2);
                buffer.append(quotation);
                continue;
            }
            if (quotation == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(quotation);
        }
        String string = buffer == null ? text2 : buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        return string;
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "printDiagnostics"));
        }
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        int length;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "getElementInfo"));
        }
        ElementInfo info = new ElementInfo();
        StringBuilder buf = new StringBuilder(element.getName());
        List attributes = element.getAttributes();
        if (attributes != null && (length = attributes.size()) > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = (Attribute)attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                info.hasNullAttributes = true;
            }
            buf.append("]");
        }
        info.name = buf.toString();
        ElementInfo elementInfo = info;
        if (elementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getElementInfo"));
        }
        return elementInfo;
    }

    public static void updateFileSet(@NotNull File[] oldFiles, @NotNull String[] newFilePaths, @NotNull Document[] newFileDocuments, String lineSeparator) throws IOException {
        if (oldFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFiles", "com/intellij/openapi/util/JDOMUtil", "updateFileSet"));
        }
        if (newFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFilePaths", "com/intellij/openapi/util/JDOMUtil", "updateFileSet"));
        }
        if (newFileDocuments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileDocuments", "com/intellij/openapi/util/JDOMUtil", "updateFileSet"));
        }
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (String newFilePath : newFilePaths) {
            File file = new File(newFilePath);
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file : oldFiles) {
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not writeable");
        }
        for (int i2 = 0; i2 < newFilePaths.length; ++i2) {
            String newFilePath = newFilePaths[i2];
            JDOMUtil.writeDocument(newFileDocuments[i2], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result = oldFile.delete();
            if (result) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || element.getAttributes().isEmpty() && element.getContent().isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element, int attributeCount) {
        return element == null || element.getAttributes().size() == attributeCount && element.getContent().isEmpty();
    }

    private static class ElementInfo {
        @NotNull
        public String name = "";
        public boolean hasNullAttributes = false;

        private ElementInfo() {
        }
    }

    public static class MyXMLOutputter
    extends XMLOutputter {
        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter", "escapeAttributeEntities"));
            }
            String string = JDOMUtil.escapeText(str, false, true);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter", "escapeAttributeEntities"));
            }
            return string;
        }

        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter", "escapeElementEntities"));
            }
            String string = JDOMUtil.escapeText(str, false, false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter", "escapeElementEntities"));
            }
            return string;
        }
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");

        private LoggerHolder() {
        }
    }
}

