/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.CompoundInitialState;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSessionContainer {
    private static final Logger LOG = Logger.getInstance(InferenceSessionContainer.class);
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    public void registerNestedSession(InferenceSession session) {
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.getInferenceSessionContainer().myNestedSessions);
    }

    @Contract(value="_, !null -> !null")
    public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
        return session == null ? defaultSession : session.getInferenceSubstitution();
    }

    void registerNestedSession(InferenceSession session, PsiType returnType, PsiExpression returnExpression) {
        InferenceSession inferenceSession;
        PsiSubstitutor callSession = this.findNestedSubstitutor(((PsiCallExpression)returnExpression).getArgumentList(), null);
        if (callSession == null && (inferenceSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, returnExpression, returnType, false)) != null && inferenceSession != session) {
            this.registerNestedSession(inferenceSession);
            session.propagateVariables(inferenceSession.getInferenceVariables(), inferenceSession.getRestoreNameSubstitution());
        }
    }

    static PsiSubstitutor infer(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        PsiCall topLevelCall;
        PsiExpressionList argumentList;
        MethodCandidateInfo.CurrentCandidateProperties properties;
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "infer"));
        }
        if (parent instanceof PsiCall && (properties = MethodCandidateInfo.getCurrentMethod(argumentList = ((PsiCall)parent).getArgumentList())) != null && !properties.isApplicabilityCheck() && !MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argumentList) && (topLevelCall = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(parent, false, () -> {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$infer$0"));
            }
            if (parent instanceof PsiExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent)) {
                return null;
            }
            return LambdaUtil.treeWalkUp(parent);
        })) != null) {
            InferenceSession session;
            if (MethodCandidateInfo.isOverloadCheck() || !PsiDiamondType.ourDiamondGuard.currentStack().isEmpty() || LambdaUtil.isLambdaParameterCheck()) {
                session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
            } else {
                Map<PsiElement, InferenceSession> sessions;
                InferenceSession childSession;
                session = (InferenceSession)CachedValuesManager.getCachedValue(topLevelCall, () -> {
                    if (policy == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "lambda$infer$1"));
                    }
                    return new CachedValueProvider.Result<InferenceSession>(InferenceSessionContainer.startTopLevelInference(topLevelCall, policy), PsiModificationTracker.MODIFICATION_COUNT);
                });
                if (session != null && (childSession = (sessions = session.getInferenceSessionContainer().myNestedSessions).get(parent)) != null) {
                    for (PsiTypeParameter parameter : typeParameters) {
                        if (childSession.getInferenceSubstitution().getSubstitutionMap().containsKey(parameter)) continue;
                        session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
                        break;
                    }
                }
            }
            if (session != null) {
                PsiSubstitutor childSubstitutor = InferenceSessionContainer.inferNested(parameters, arguments, (PsiCall)parent, properties, session);
                if (childSubstitutor != null) {
                    return childSubstitutor;
                }
            } else if (topLevelCall instanceof PsiMethodCallExpression) {
                return new InferenceSession(typeParameters, partialSubstitutor, parent.getManager(), parent, policy).prepareSubstitution();
            }
        }
        InferenceSession inferenceSession = new InferenceSession(typeParameters, partialSubstitutor, parent.getManager(), parent, policy);
        inferenceSession.initExpressionConstraints(parameters, arguments, parent);
        return inferenceSession.infer(parameters, arguments, parent);
    }

    private static PsiSubstitutor inferNested(@NotNull PsiParameter[] parameters, @NotNull PsiExpression[] arguments, @NotNull PsiCall parent, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull InferenceSession parentSession) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        if (parentSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentSession", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "inferNested"));
        }
        CompoundInitialState compoundInitialState = InferenceSessionContainer.createState(parentSession);
        InitialInferenceState initialInferenceState = compoundInitialState.getInitialState(parent);
        if (initialInferenceState != null) {
            InferenceSession childSession = new InferenceSession(initialInferenceState);
            List<String> errorMessages = parentSession.getIncompatibleErrorMessages();
            if (errorMessages != null) {
                PsiMethod outerCallerMethod;
                PsiElement context = parentSession.getContext();
                if (context instanceof PsiCallExpression && (outerCallerMethod = ((PsiCallExpression)context).resolveMethod()) != null && outerCallerMethod.hasTypeParameters()) {
                    return properties.getInfo().getSubstitutor(false);
                }
                return childSession.prepareSubstitution();
            }
            return childSession.collectAdditionalAndInfer(parameters, arguments, properties, compoundInitialState.getInitialSubstitutor());
        }
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp(parent.getParent());
        while (true) {
            PsiCall call;
            PsiElement returnContainer;
            if (gParent instanceof PsiReturnStatement && (returnContainer = gParent.getParent()) instanceof PsiCodeBlock) {
                gParent = returnContainer.getParent();
            }
            if (!(gParent instanceof PsiLambdaExpression) || (call = PsiTreeUtil.getParentOfType(gParent, PsiCall.class)) == null) break;
            initialInferenceState = compoundInitialState.getInitialState(call);
            if (initialInferenceState != null) {
                PsiExpressionList argumentList = call.getArgumentList();
                int idx = LambdaUtil.getLambdaIdx(argumentList, gParent);
                JavaResolveResult result = call.resolveMethodGenerics();
                PsiElement method = result.getElement();
                if (!(method instanceof PsiMethod) || idx <= -1) break;
                LOG.assertTrue(argumentList != null);
                PsiParameter[] methodParameters = ((PsiMethod)method).getParameterList().getParameters();
                if (methodParameters.length == 0) break;
                InferenceSession sessionInsideLambda = new InferenceSession(initialInferenceState);
                sessionInsideLambda.collectAdditionalAndInfer(methodParameters, argumentList.getExpressions(), ((MethodCandidateInfo)result).createProperties(), compoundInitialState.getInitialSubstitutor());
                return InferenceSessionContainer.inferNested(parameters, arguments, parent, properties, sessionInsideLambda);
            }
            gParent = PsiUtil.skipParenthesizedExprUp(call.getParent());
        }
        return null;
    }

    private static CompoundInitialState createState(InferenceSession topLevelSession) {
        PsiSubstitutor topInferenceSubstitutor = InferenceSessionContainer.replaceVariables(topLevelSession.getInferenceVariables());
        final LinkedHashMap<PsiElement, InitialInferenceState> nestedStates = new LinkedHashMap<PsiElement, InitialInferenceState>();
        InferenceSessionContainer copy = new InferenceSessionContainer(){

            @Override
            public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
                PsiSubstitutor substitutor = super.findNestedSubstitutor(arg, null);
                if (substitutor != null) {
                    return substitutor;
                }
                InitialInferenceState state = (InitialInferenceState)nestedStates.get(PsiTreeUtil.getParentOfType(arg, PsiCall.class));
                if (state != null) {
                    return state.getInferenceSubstitutor();
                }
                return super.findNestedSubstitutor(arg, defaultSession);
            }
        };
        Map<PsiElement, InferenceSession> nestedSessions = topLevelSession.getInferenceSessionContainer().myNestedSessions;
        for (Map.Entry<PsiElement, InferenceSession> entry : nestedSessions.entrySet()) {
            nestedStates.put(entry.getKey(), entry.getValue().createInitialState(copy, topLevelSession.getInferenceVariables(), topInferenceSubstitutor));
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : topLevelSession.getInferenceVariables()) {
            PsiClass psiClass;
            PsiType instantiation = variable.getInstantiation();
            if (instantiation == PsiType.NULL || !((psiClass = PsiUtil.resolveClassInClassTypeOnly(topInferenceSubstitutor.substitute(variable))) instanceof InferenceVariable)) continue;
            substitutor = substitutor.put((PsiTypeParameter)psiClass, instantiation);
        }
        return new CompoundInitialState(substitutor, nestedStates);
    }

    @Nullable
    private static InferenceSession startTopLevelInference(PsiCall topLevelCall, ParameterTypeInferencePolicy policy) {
        JavaResolveResult result = topLevelCall.resolveMethodGenerics();
        if (result instanceof MethodCandidateInfo) {
            PsiMethod method = ((MethodCandidateInfo)result).getElement();
            PsiParameter[] topLevelParameters = method.getParameterList().getParameters();
            PsiExpressionList topLevelCallArgumentList = topLevelCall.getArgumentList();
            LOG.assertTrue(topLevelCallArgumentList != null, topLevelCall);
            PsiExpression[] topLevelArguments = topLevelCallArgumentList.getExpressions();
            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(topLevelCall, true, () -> {
                InferenceSession topLevelSession = new InferenceSession(method.getTypeParameters(), ((MethodCandidateInfo)result).getSiteSubstitutor(), topLevelCall.getManager(), topLevelCall, policy);
                topLevelSession.initExpressionConstraints(topLevelParameters, topLevelArguments, topLevelCall, method, ((MethodCandidateInfo)result).isVarargs());
                topLevelSession.infer(topLevelParameters, topLevelArguments, topLevelCall, ((MethodCandidateInfo)result).createProperties());
                return topLevelSession;
            });
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor replaceVariables(Collection<InferenceVariable> inferenceVariables) {
        InferenceVariable[] oldVars;
        ArrayList<InferenceVariable> targetVars = new ArrayList<InferenceVariable>();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : oldVars = inferenceVariables.toArray(new InferenceVariable[inferenceVariables.size()])) {
            InferenceVariable newVariable = new InferenceVariable(variable.getCallContext(), variable.getParameter(), variable.getName());
            substitutor = substitutor.put(variable, JavaPsiFacade.getElementFactory(variable.getProject()).createType(newVariable));
            targetVars.add(newVariable);
            if (!variable.isThrownBound()) continue;
            newVariable.setThrownBound();
        }
        for (int i2 = 0; i2 < targetVars.size(); ++i2) {
            InferenceVariable var = (InferenceVariable)targetVars.get(i2);
            for (InferenceBound boundType : InferenceBound.values()) {
                for (PsiType bound : oldVars[i2].getBounds(boundType)) {
                    var.addBound(substitutor.substitute(bound), boundType, null);
                }
            }
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/InferenceSessionContainer", "replaceVariables"));
        }
        return psiSubstitutor;
    }
}

