/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.util.CharTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.AbstractList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FCTSBackedLighterAST
extends LighterAST {
    @NotNull
    private final FlyweightCapableTreeStructure<LighterASTNode> myTreeStructure;

    public FCTSBackedLighterAST(@NotNull CharTable charTable, @NotNull FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
        if (charTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charTable", "com/intellij/lang/FCTSBackedLighterAST", "<init>"));
        }
        if (treeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "com/intellij/lang/FCTSBackedLighterAST", "<init>"));
        }
        super(charTable);
        this.myTreeStructure = treeStructure;
    }

    @Override
    @NotNull
    public LighterASTNode getRoot() {
        LighterASTNode lighterASTNode = this.myTreeStructure.getRoot();
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/FCTSBackedLighterAST", "getRoot"));
        }
        return lighterASTNode;
    }

    @Override
    public LighterASTNode getParent(@NotNull LighterASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/FCTSBackedLighterAST", "getParent"));
        }
        return this.myTreeStructure.getParent(node);
    }

    @Override
    @NotNull
    public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/FCTSBackedLighterAST", "getChildren"));
        }
        Ref<T[]> into = new Ref<T[]>();
        int numKids = this.myTreeStructure.getChildren(this.myTreeStructure.prepareForGetChildren(parent), into);
        if (numKids == 0) {
            List<LighterASTNode> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/FCTSBackedLighterAST", "getChildren"));
            }
            return list;
        }
        LighterASTNode[] elements = (LighterASTNode[])into.get();
        assert (elements != null) : this.myTreeStructure + " (" + parent + ")";
        LighterASTNodeList lighterASTNodeList = new LighterASTNodeList(numKids, elements);
        if (lighterASTNodeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/FCTSBackedLighterAST", "getChildren"));
        }
        return lighterASTNodeList;
    }

    private static class LighterASTNodeList
    extends AbstractList<LighterASTNode> {
        private final int mySize;
        private final LighterASTNode[] myElements;

        public LighterASTNodeList(int size, LighterASTNode[] elements) {
            this.mySize = size;
            this.myElements = elements;
        }

        @Override
        public LighterASTNode get(int index) {
            if (index < 0 || index >= this.mySize) {
                throw new IndexOutOfBoundsException("index:" + index + " size:" + this.mySize);
            }
            return this.myElements[index];
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }
}

