/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HUtils;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.util.ArrayFactory;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

final class HComponent {
    static final HComponent[] EMPTY_ARRAY = new HComponent[0];
    static final ArrayFactory<HComponent> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new HComponent[count];
    @NotNull
    Value value;
    @NotNull
    final HKey[] ids;

    HComponent(@NotNull Value value, @NotNull HKey[] ids) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/bytecodeAnalysis/HComponent", "<init>"));
        }
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/codeInspection/bytecodeAnalysis/HComponent", "<init>"));
        }
        this.value = value;
        this.ids = ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HComponent that = (HComponent)o;
        if (!Arrays.equals(this.ids, that.ids)) {
            return false;
        }
        return this.value == that.value;
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + Arrays.hashCode(this.ids);
        return result;
    }

    public boolean remove(@NotNull HKey id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/codeInspection/bytecodeAnalysis/HComponent", "remove"));
        }
        return HUtils.remove(this.ids, id);
    }

    public boolean isEmpty() {
        return HUtils.isEmpty(this.ids);
    }

    @NotNull
    public HComponent copy() {
        HComponent hComponent = new HComponent(this.value, (HKey[])this.ids.clone());
        if (hComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/HComponent", "copy"));
        }
        return hComponent;
    }
}

