/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.annotations.NotNull;

public class ArrayAccessInstruction
extends Instruction {
    @NotNull
    private final DfaValue myValue;
    @NotNull
    private final PsiArrayAccessExpression myExpression;

    public ArrayAccessInstruction(@NotNull DfaValue value, @NotNull PsiArrayAccessExpression expression) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/instructions/ArrayAccessInstruction", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/instructions/ArrayAccessInstruction", "<init>"));
        }
        this.myValue = value;
        this.myExpression = expression;
    }

    @NotNull
    public DfaValue getValue() {
        DfaValue dfaValue = this.myValue;
        if (dfaValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/instructions/ArrayAccessInstruction", "getValue"));
        }
        return dfaValue;
    }

    @NotNull
    public PsiArrayAccessExpression getExpression() {
        PsiArrayAccessExpression psiArrayAccessExpression = this.myExpression;
        if (psiArrayAccessExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/instructions/ArrayAccessInstruction", "getExpression"));
        }
        return psiArrayAccessExpression;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitArrayAccess(this, runner, stateBefore);
    }

    public String toString() {
        return "ARRAY_ACCESS " + this.myExpression.getText();
    }
}

