/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontPreferencesImpl
extends ModifiableFontPreferences {
    @NotNull
    private final TObjectIntHashMap<String> myFontSizes = new TObjectIntHashMap();
    @NotNull
    private final List<String> myEffectiveFontFamilies = ContainerUtilRt.newArrayList();
    @NotNull
    private final List<String> myRealFontFamilies = ContainerUtilRt.newArrayList();
    private boolean myUseLigatures;
    private float myLineSpacing = 1.0f;
    @Nullable
    private Runnable myChangeListener;
    private int myTemplateFontSize = DEFAULT_FONT_SIZE;

    public void setChangeListener(@Nullable Runnable changeListener) {
        this.myChangeListener = changeListener;
    }

    @Nullable
    public Runnable getChangeListener() {
        return this.myChangeListener;
    }

    @Override
    public void clear() {
        this.myEffectiveFontFamilies.clear();
        this.myRealFontFamilies.clear();
        this.myFontSizes.clear();
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    @Override
    public void clearFonts() {
        this.myEffectiveFontFamilies.clear();
        this.myRealFontFamilies.clear();
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    @Override
    public boolean hasSize(@NotNull String fontName) {
        if (fontName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontName", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "hasSize"));
        }
        return this.myFontSizes.containsKey((Object)fontName);
    }

    @Override
    public float getLineSpacing() {
        return this.myLineSpacing;
    }

    @Override
    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing(lineSpacing);
    }

    @Override
    public int getSize(@NotNull String fontFamily) {
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "getSize"));
        }
        int result = this.myFontSizes.get((Object)fontFamily);
        if (result <= 0) {
            result = this.myTemplateFontSize;
        }
        return result > 0 ? result : DEFAULT_FONT_SIZE;
    }

    public void setSize(@NotNull String fontFamily, int size) {
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "setSize"));
        }
        this.myFontSizes.put((Object)fontFamily, size);
        this.myTemplateFontSize = size;
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    @Override
    @NotNull
    public List<String> getEffectiveFontFamilies() {
        List<String> list = this.myEffectiveFontFamilies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "getEffectiveFontFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getRealFontFamilies() {
        List<String> list = this.myRealFontFamilies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "getRealFontFamilies"));
        }
        return list;
    }

    @Override
    public void register(@NotNull String fontFamily, int size) {
        String effectiveFontFamily;
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "register"));
        }
        String fallbackFontFamily = FontPreferences.getFallbackName(fontFamily, size, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        this.setSize(fontFamily, size);
    }

    @Override
    @NotNull
    public String getFontFamily() {
        String string = this.myEffectiveFontFamilies.isEmpty() ? DEFAULT_FONT_NAME : this.myEffectiveFontFamilies.get(0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "getFontFamily"));
        }
        return string;
    }

    @Override
    public void addFontFamily(@NotNull String fontFamily) {
        String effectiveFontFamily;
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "addFontFamily"));
        }
        String fallbackFontFamily = FontPreferences.getFallbackName(fontFamily, DEFAULT_FONT_SIZE, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    @Override
    public void copyTo(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "copyTo"));
        }
        if (preferences instanceof ModifiableFontPreferences) {
            ModifiableFontPreferences modifiablePreferences = (ModifiableFontPreferences)preferences;
            modifiablePreferences.setEffectiveFontFamilies(this.myEffectiveFontFamilies);
            modifiablePreferences.setRealFontFamilies(this.myRealFontFamilies);
            modifiablePreferences.setTemplateFontSize(this.myTemplateFontSize);
            modifiablePreferences.resetFontSizes();
            for (String fontFamily : this.myRealFontFamilies) {
                if (!this.myFontSizes.containsKey((Object)fontFamily)) continue;
                modifiablePreferences.setFontSize(fontFamily, this.myFontSizes.get((Object)fontFamily));
            }
            modifiablePreferences.setUseLigatures(this.myUseLigatures);
            modifiablePreferences.setLineSpacing(this.myLineSpacing);
        }
    }

    @Override
    public void resetFontSizes() {
        this.myFontSizes.clear();
    }

    @Override
    public void setFontSize(@NotNull String fontFamily, int size) {
        if (fontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamily", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "setFontSize"));
        }
        this.myFontSizes.put((Object)fontFamily, size);
    }

    @Override
    public void setTemplateFontSize(int size) {
        this.myTemplateFontSize = size;
    }

    @Override
    public void setEffectiveFontFamilies(@NotNull List<String> fontFamilies) {
        if (fontFamilies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamilies", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "setEffectiveFontFamilies"));
        }
        this.myEffectiveFontFamilies.clear();
        this.myEffectiveFontFamilies.addAll(fontFamilies);
    }

    @Override
    public void setRealFontFamilies(@NotNull List<String> fontFamilies) {
        if (fontFamilies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontFamilies", "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl", "setRealFontFamilies"));
        }
        this.myRealFontFamilies.clear();
        this.myRealFontFamilies.addAll(fontFamilies);
    }

    public int hashCode() {
        return this.myRealFontFamilies.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontPreferencesImpl that = (FontPreferencesImpl)o;
        if (!this.myRealFontFamilies.equals(that.myRealFontFamilies)) {
            return false;
        }
        for (String fontFamily : this.myRealFontFamilies) {
            if (this.myFontSizes.get((Object)fontFamily) == that.myFontSizes.get((Object)fontFamily)) continue;
            return false;
        }
        if (this.myUseLigatures != that.myUseLigatures) {
            return false;
        }
        return this.myLineSpacing == that.myLineSpacing;
    }

    @Override
    public boolean useLigatures() {
        return this.myUseLigatures;
    }

    @Override
    public void setUseLigatures(boolean useLigatures) {
        if (useLigatures != this.myUseLigatures) {
            this.myUseLigatures = useLigatures;
            if (this.myChangeListener != null) {
                this.myChangeListener.run();
            }
        }
    }

    public String toString() {
        return "Effective font families: " + this.myEffectiveFontFamilies;
    }
}

