/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.dependencies;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.model.JpsSdkManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.dependencies.JpsOrderEntry;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.module.JpsSdkDependency;

public abstract class JpsSdkOrderEntryBase
extends JpsOrderEntry<JpsSdkDependency>
implements JdkOrderEntry {
    public JpsSdkOrderEntryBase(JpsRootModel rootModel, JpsSdkDependency dependencyElement) {
        super(rootModel, dependencyElement);
    }

    @Override
    public String getJdkName() {
        JpsSdkReference<?> reference = ((JpsSdkDependency)this.myDependencyElement).getSdkReference();
        return reference != null ? reference.getSdkName() : null;
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles(OrderRootType type) {
        VirtualFile[] virtualFileArray = this.getRootFiles(type);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getFiles"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getUrls(OrderRootType rootType) {
        String[] stringArray = this.getRootUrls(rootType);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getUrls"));
        }
        return stringArray;
    }

    @Override
    public Sdk getJdk() {
        JpsLibrary library = ((JpsSdkDependency)this.myDependencyElement).resolveSdk();
        if (library == null) {
            return null;
        }
        return JpsSdkManager.getInstance().getSdk(library);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "< " + this.getJdkName() + " >";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getPresentableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile[] getRootFiles(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getRootFiles"));
        }
        Sdk sdk = this.getJdk();
        if (sdk == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getRootFiles"));
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(type);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getRootFiles"));
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getRootUrls(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getRootUrls"));
        }
        Sdk jdk = this.getJdk();
        if (jdk == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getRootUrls"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = jdk.getRootProvider().getUrls(type);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/project/model/impl/module/dependencies/JpsSdkOrderEntryBase", "getRootUrls"));
        }
        return stringArray;
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }
}

