/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.AbstractQuery;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class ClassInheritorsSearch
extends ExtensibleQueryFactory<PsiClass, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create("com.intellij.classInheritorsSearch");
    public static final ClassInheritorsSearch INSTANCE = new ClassInheritorsSearch();

    private ClassInheritorsSearch() {
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(new SearchParameters(aClass, scope, checkDeep, checkInheritance, includeAnonymous));
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (!parameters.isCheckDeep()) {
            Query<PsiClass> directQuery = DirectClassInheritorsSearch.search(parameters.getClassToProcess(), parameters.getScope(), parameters.isIncludeAnonymous());
            if (parameters.getNameCondition() != Conditions.alwaysTrue()) {
                directQuery = new FilteredQuery<PsiClass>(directQuery, psiClass -> {
                    if (parameters == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/search/searches/ClassInheritorsSearch", "lambda$search$0"));
                    }
                    return parameters.getNameCondition().value(ReadAction.compute(psiClass::getName));
                });
            }
            Query<PsiClass> query = AbstractQuery.wrapInReadAction(directQuery);
            if (query == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
            }
            return query;
        }
        Query<PsiClass> query = INSTANCE.createUniqueResultsQuery(parameters, ContainerUtil.canonicalStrategy(), psiClass -> ReadAction.compute(() -> SmartPointerManager.getInstance(psiClass.getProject()).createSmartPsiElementPointer(psiClass)));
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return query;
    }

    @Deprecated
    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(aClass, scope, checkDeep, checkInheritance, true);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(aClass, scope, checkDeep, true, true);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(aClass, ReadAction.compute(() -> {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "lambda$search$3"));
            }
            if (!aClass.isValid()) {
                throw new ProcessCanceledException();
            }
            PsiFile file = aClass.getContainingFile();
            return (file != null ? file : aClass).getUseScope();
        }), checkDeep);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return query;
    }

    @NotNull
    public static Query<PsiClass> search(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        Query<PsiClass> query = ClassInheritorsSearch.search(aClass, true);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch", "search"));
        }
        return query;
    }

    public static class SearchParameters {
        @NotNull
        private final PsiClass myClass;
        @NotNull
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final boolean myCheckInheritance;
        private final boolean myIncludeAnonymous;
        @NotNull
        private final Condition<String> myNameCondition;

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            this(aClass, scope, checkDeep, checkInheritance, includeAnonymous, Conditions.alwaysTrue());
        }

        public SearchParameters(@NotNull PsiClass aClass, @NotNull SearchScope scope, boolean checkDeep, boolean checkInheritance, boolean includeAnonymous, @NotNull Condition<String> nameCondition) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            if (nameCondition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameCondition", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "<init>"));
            }
            this.myClass = aClass;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myCheckInheritance = checkInheritance;
            assert (checkInheritance);
            this.myIncludeAnonymous = includeAnonymous;
            this.myNameCondition = nameCondition;
        }

        @NotNull
        public PsiClass getClassToProcess() {
            PsiClass psiClass = this.myClass;
            if (psiClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "getClassToProcess"));
            }
            return psiClass;
        }

        @NotNull
        public Condition<String> getNameCondition() {
            Condition<String> condition = this.myNameCondition;
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "getNameCondition"));
            }
            return condition;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/ClassInheritorsSearch$SearchParameters", "getScope"));
            }
            return searchScope;
        }

        public boolean isCheckInheritance() {
            return this.myCheckInheritance;
        }

        public boolean isIncludeAnonymous() {
            return this.myIncludeAnonymous;
        }

        public String toString() {
            return "'" + this.myClass.getQualifiedName() + "' scope=" + this.myScope + (this.myCheckDeep ? " (deep)" : "") + (this.myCheckInheritance ? " (check inheritance)" : "") + (this.myIncludeAnonymous ? " (anonymous)" : "") + (this.myNameCondition == Conditions.alwaysTrue() ? "" : " condition: " + this.myNameCondition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchParameters that = (SearchParameters)o;
            if (this.myCheckDeep != that.myCheckDeep) {
                return false;
            }
            if (this.myCheckInheritance != that.myCheckInheritance) {
                return false;
            }
            if (this.myIncludeAnonymous != that.myIncludeAnonymous) {
                return false;
            }
            if (!this.myClass.equals(that.myClass)) {
                return false;
            }
            if (!this.myScope.equals(that.myScope)) {
                return false;
            }
            return this.myNameCondition.equals(that.myNameCondition);
        }

        public int hashCode() {
            int result = this.myClass.hashCode();
            result = 31 * result + this.myScope.hashCode();
            result = 31 * result + (this.myCheckDeep ? 1 : 0);
            result = 31 * result + (this.myCheckInheritance ? 1 : 0);
            result = 31 * result + (this.myIncludeAnonymous ? 1 : 0);
            result = 31 * result + this.myNameCondition.hashCode();
            return result;
        }
    }
}

