/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LayeredIcon
extends JBUI.AuxScalableJBIcon {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ui.LayeredIcon");
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;
    private final boolean[] myDisabledLayers;
    private final int[] myHShifts;
    private final int[] myVShifts;
    private int myXShift;
    private int myYShift;
    private int myWidth;
    private int myHeight;

    public LayeredIcon(int layerCount) {
        this.myIcons = new Icon[layerCount];
        this.myDisabledLayers = new boolean[layerCount];
        this.myHShifts = new int[layerCount];
        this.myVShifts = new int[layerCount];
    }

    public LayeredIcon(Icon ... icons) {
        if (icons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icons", "com/intellij/ui/LayeredIcon", "<init>"));
        }
        this(icons.length);
        for (int i2 = 0; i2 < icons.length; ++i2) {
            this.setIcon(icons[i2], i2);
        }
    }

    protected LayeredIcon(LayeredIcon icon) {
        super(icon);
        this.myIcons = ArrayUtil.copyOf(icon.myIcons);
        this.myScaledIcons = null;
        this.myDisabledLayers = ArrayUtil.copyOf(icon.myDisabledLayers);
        this.myHShifts = ArrayUtil.copyOf(icon.myHShifts);
        this.myVShifts = ArrayUtil.copyOf(icon.myVShifts);
        this.myXShift = icon.myXShift;
        this.myYShift = icon.myYShift;
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
    }

    @NotNull
    protected LayeredIcon copy() {
        LayeredIcon layeredIcon = new LayeredIcon(this);
        if (layeredIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/LayeredIcon", "copy"));
        }
        return layeredIcon;
    }

    @NotNull
    private Icon[] myScaledIcons() {
        if (this.myScaledIcons != null) {
            if (this.myScaledIcons == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/LayeredIcon", "myScaledIcons"));
            }
            return this.myScaledIcons;
        }
        if (this.getScale() == 1.0f) {
            this.myScaledIcons = this.myIcons;
            Icon[] iconArray = this.myScaledIcons;
            if (iconArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/LayeredIcon", "myScaledIcons"));
            }
            return iconArray;
        }
        for (Icon icon : this.myIcons) {
            if (icon == null || icon instanceof ScalableIcon) continue;
            this.myScaledIcons = this.myIcons;
            Icon[] iconArray = this.myScaledIcons;
            if (iconArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/LayeredIcon", "myScaledIcons"));
            }
            return iconArray;
        }
        this.myScaledIcons = new Icon[this.myIcons.length];
        for (int i2 = 0; i2 < this.myIcons.length; ++i2) {
            if (this.myIcons[i2] == null) continue;
            this.myScaledIcons[i2] = ((ScalableIcon)this.myIcons[i2]).scale(this.getScale());
        }
        if (this.myScaledIcons == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/LayeredIcon", "myScaledIcons"));
        }
        return this.myScaledIcons;
    }

    @Override
    public LayeredIcon withJBUIPreScaled(boolean preScaled) {
        super.withJBUIPreScaled(preScaled);
        this.updateSize();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LayeredIcon)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LayeredIcon icon = (LayeredIcon)o;
        if (this.myHeight != icon.myHeight) {
            return false;
        }
        if (this.myWidth != icon.myWidth) {
            return false;
        }
        if (this.myXShift != icon.myXShift) {
            return false;
        }
        if (this.myYShift != icon.myYShift) {
            return false;
        }
        if (!Arrays.equals(this.myHShifts, icon.myHShifts)) {
            return false;
        }
        if (!Arrays.equals(this.myIcons, icon.myIcons)) {
            return false;
        }
        return Arrays.equals(this.myVShifts, icon.myVShifts);
    }

    public int hashCode() {
        return 0;
    }

    public void setIcon(Icon icon, int layer) {
        this.setIcon(icon, layer, 0, 0);
    }

    public Icon getIcon(int layer) {
        return this.myIcons[layer];
    }

    @NotNull
    public Icon[] getAllLayers() {
        if (this.myIcons == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/LayeredIcon", "getAllLayers"));
        }
        return this.myIcons;
    }

    public void setIcon(Icon icon, int layer, int hShift, int vShift) {
        if (icon instanceof LayeredIcon) {
            ((LayeredIcon)icon).checkIHaventIconInsideMe(this);
        }
        this.myIcons[layer] = icon;
        this.myScaledIcons = null;
        this.myHShifts[layer] = hShift;
        this.myVShifts[layer] = vShift;
        this.updateSize();
    }

    public void setIcon(Icon icon, int layer, int constraint) {
        int y;
        int x;
        int width = this.getIconWidth();
        int height = this.getIconHeight();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        if (width <= 1 || height <= 1) {
            this.setIcon(icon, layer);
            return;
        }
        switch (constraint) {
            case 0: {
                x = (width - w) / 2;
                y = (height - h) / 2;
                break;
            }
            case 1: {
                x = (width - w) / 2;
                y = 0;
                break;
            }
            case 2: {
                x = width - w;
                y = 0;
                break;
            }
            case 3: {
                x = width - w;
                y = (height - h) / 2;
                break;
            }
            case 4: {
                x = width - w;
                y = height - h;
                break;
            }
            case 5: {
                x = (width - w) / 2;
                y = height - h;
                break;
            }
            case 6: {
                x = 0;
                y = height - h;
                break;
            }
            case 7: {
                x = 0;
                y = (height - h) / 2;
                break;
            }
            case 8: {
                x = 0;
                y = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("The constraint should be one of SwingConstants' compass-directions [1..8] or CENTER [0], actual value is " + constraint);
            }
        }
        this.setIcon(icon, layer, x, y);
    }

    private void checkIHaventIconInsideMe(Icon icon) {
        LOG.assertTrue(icon != this);
        for (Icon child : this.myIcons) {
            if (!(child instanceof LayeredIcon)) continue;
            ((LayeredIcon)child).checkIHaventIconInsideMe(icon);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.updateJBUIScale()) {
            this.updateSize();
        }
        Icon[] icons = this.myScaledIcons();
        for (int i2 = 0; i2 < icons.length; ++i2) {
            Icon icon = icons[i2];
            if (icon == null || this.myDisabledLayers[i2]) continue;
            int xOffset = x + this.scaleVal(this.myXShift + this.myHShifts(i2), JBUI.ScalableJBIcon.Scale.INSTANCE);
            int yOffset = y + this.scaleVal(this.myYShift + this.myVShifts(i2), JBUI.ScalableJBIcon.Scale.INSTANCE);
            icon.paintIcon(c, g, xOffset, yOffset);
        }
    }

    public boolean isLayerEnabled(int layer) {
        return !this.myDisabledLayers[layer];
    }

    public void setLayerEnabled(int layer, boolean enabled) {
        this.myDisabledLayers[layer] = !enabled;
    }

    @Override
    public int getIconWidth() {
        if (this.myWidth <= 1 || this.updateJBUIScale()) {
            this.updateSize();
        }
        return this.scaleVal(this.myWidth, JBUI.ScalableJBIcon.Scale.INSTANCE);
    }

    @Override
    public int getIconHeight() {
        if (this.myHeight <= 1 || this.updateJBUIScale()) {
            this.updateSize();
        }
        return this.scaleVal(this.myHeight, JBUI.ScalableJBIcon.Scale.INSTANCE);
    }

    private int myHShifts(int i2) {
        return this.scaleVal(this.myHShifts[i2], JBUI.ScalableJBIcon.Scale.JBUI);
    }

    private int myVShifts(int i2) {
        return this.scaleVal(this.myVShifts[i2], JBUI.ScalableJBIcon.Scale.JBUI);
    }

    protected void updateSize() {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean hasNotNullIcons = false;
        for (int i2 = 0; i2 < this.myIcons.length; ++i2) {
            Icon icon = this.myIcons[i2];
            if (icon == null) continue;
            hasNotNullIcons = true;
            int hShift = this.myHShifts(i2);
            int vShift = this.myVShifts(i2);
            minX = Math.min(minX, hShift);
            maxX = Math.max(maxX, hShift + icon.getIconWidth());
            minY = Math.min(minY, vShift);
            maxY = Math.max(maxY, vShift + icon.getIconHeight());
        }
        if (!hasNotNullIcons) {
            return;
        }
        this.myWidth = maxX - minX;
        this.myHeight = maxY - minY;
        if (this.myIcons.length > 1) {
            this.myXShift = -minX;
            this.myYShift = -minY;
        }
    }

    public static Icon create(Icon backgroundIcon, Icon foregroundIcon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(backgroundIcon, 0);
        layeredIcon.setIcon(foregroundIcon, 1);
        return layeredIcon;
    }

    public String toString() {
        return "Layered icon. myIcons=" + Arrays.asList(this.myIcons);
    }
}

