/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.MergePackageAccessibilityStatementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeProvidesStatementsFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeModuleStatementsFix<T extends PsiElement>
extends LocalQuickFixAndIntentionActionOnPsiElement {
    protected MergeModuleStatementsFix(@NotNull PsiJavaModule javaModule) {
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "<init>"));
        }
        super(javaModule);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "isAvailable"));
        }
        return PsiUtil.isLanguageLevel9OrHigher(file);
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "invoke"));
        }
        if (startElement instanceof PsiJavaModule) {
            PsiJavaModule javaModule = (PsiJavaModule)startElement;
            List<T> statementsToMerge = this.getStatementsToMerge(javaModule);
            LOG.assertTrue(!statementsToMerge.isEmpty());
            String tempModuleText = "module " + javaModule.getName() + " {" + this.getReplacementText(statementsToMerge) + "}";
            PsiJavaModule tempModule = JavaPsiFacade.getInstance(project).getElementFactory().createModuleFromText(tempModuleText);
            List<T> tempStatements = this.getStatementsToMerge(tempModule);
            LOG.assertTrue(!tempStatements.isEmpty());
            PsiElement replacement = (PsiElement)tempStatements.get(0);
            PsiElement firstStatement = (PsiElement)statementsToMerge.get(0);
            CommentTracker commentTracker = new CommentTracker();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project);
            PsiElement resultingStatement = codeStyleManager.reformat(commentTracker.replace(firstStatement, replacement));
            for (int i2 = 1; i2 < statementsToMerge.size(); ++i2) {
                PsiElement statement = (PsiElement)statementsToMerge.get(i2);
                commentTracker.delete(statement);
            }
            commentTracker.insertCommentsBefore(resultingStatement);
            if (editor != null) {
                int offset = resultingStatement.getTextRange().getEndOffset();
                editor.getCaretModel().moveToOffset(offset);
            }
        }
    }

    @NotNull
    protected abstract String getReplacementText(List<T> var1);

    @NotNull
    protected abstract List<T> getStatementsToMerge(@NotNull PsiJavaModule var1);

    @NotNull
    protected static String joinUniqueNames(@NotNull List<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "joinUniqueNames"));
        }
        THashSet unique = new THashSet();
        String string = names.stream().filter(arg_0 -> MergeModuleStatementsFix.lambda$joinUniqueNames$0((Set)unique, arg_0)).collect(Collectors.joining(","));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/MergeModuleStatementsFix", "joinUniqueNames"));
        }
        return string;
    }

    @Nullable
    public static MergeModuleStatementsFix createFix(@Nullable PsiElement statement) {
        if (statement instanceof PsiPackageAccessibilityStatement) {
            return MergePackageAccessibilityStatementsFix.createFix((PsiPackageAccessibilityStatement)statement);
        }
        if (statement instanceof PsiProvidesStatement) {
            return MergeProvidesStatementsFix.createFix((PsiProvidesStatement)statement);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$joinUniqueNames$0(Set unique, String name) {
        return unique.add(name);
    }
}

