/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.ide.TypePresentationService;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableArrayTypeFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final PsiArrayType myTargetType;
    private final String myName;
    private final String myFamilyName;

    private VariableArrayTypeFix(@NotNull PsiArrayInitializerExpression initializer, @NotNull PsiArrayType arrayType, @NotNull PsiVariable variable) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "<init>"));
        }
        if (arrayType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrayType", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "<init>"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "<init>"));
        }
        super(initializer);
        this.myTargetType = arrayType;
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(initializer);
        this.myName = this.myTargetType.equals(variable.getType()) && myNewExpression != null ? QuickFixBundle.message("change.new.operator.type.text", VariableArrayTypeFix.getNewText(myNewExpression, initializer), this.myTargetType.getCanonicalText(), "") : QuickFixBundle.message("fix.variable.type.text", VariableArrayTypeFix.formatType(variable), variable.getName(), this.myTargetType.getCanonicalText());
        this.myFamilyName = QuickFixBundle.message(this.myTargetType.equals(variable.getType()) && myNewExpression != null ? "change.new.operator.type.family" : "fix.variable.type.family", new Object[0]);
    }

    @Nullable
    public static VariableArrayTypeFix createFix(PsiArrayInitializerExpression initializer, @NotNull PsiType componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "createFix"));
        }
        PsiArrayType arrayType = new PsiArrayType(componentType);
        PsiArrayInitializerExpression arrayInitializer = initializer;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
            arrayType = new PsiArrayType(arrayType);
        }
        PsiVariable variable = VariableArrayTypeFix.getVariableLocal(arrayInitializer);
        if (variable == null) {
            return null;
        }
        return new VariableArrayTypeFix(arrayInitializer, arrayType, variable);
    }

    private static String formatType(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "formatType"));
        }
        FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(variable.getLanguage());
        String type = provider.getType(variable);
        if (StringUtil.isNotEmpty(type)) {
            return type;
        }
        return TypePresentationService.getService().getTypePresentableName(variable.getClass());
    }

    private static PsiArrayInitializerExpression getInitializer(PsiArrayInitializerExpression initializer) {
        PsiArrayInitializerExpression arrayInitializer = initializer;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
        }
        return arrayInitializer;
    }

    private static PsiVariable getVariableLocal(@NotNull PsiArrayInitializerExpression initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "getVariableLocal"));
        }
        PsiVariable variableLocal = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof PsiVariable) {
            variableLocal = (PsiVariable)parent;
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpressionLocal = (PsiNewExpression)parent;
            PsiElement newParent = newExpressionLocal.getParent();
            if (newParent instanceof PsiAssignmentExpression) {
                variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)newParent);
            } else if (newParent instanceof PsiVariable) {
                variableLocal = (PsiVariable)newParent;
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)parent);
        }
        return variableLocal;
    }

    private static PsiNewExpression getNewExpressionLocal(@NotNull PsiArrayInitializerExpression initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "getNewExpressionLocal"));
        }
        PsiNewExpression newExpressionLocal = null;
        PsiElement parent = initializer.getParent();
        if (!(parent instanceof PsiVariable) && parent instanceof PsiNewExpression) {
            newExpressionLocal = (PsiNewExpression)parent;
        }
        return newExpressionLocal;
    }

    @Nullable
    private static PsiVariable getFromAssignment(PsiAssignmentExpression assignment) {
        PsiExpression reference = assignment.getLExpression();
        PsiElement referencedElement = reference instanceof PsiReferenceExpression ? ((PsiReferenceExpression)reference).resolve() : null;
        return referencedElement != null && referencedElement instanceof PsiVariable ? (PsiVariable)referencedElement : null;
    }

    private static String getNewText(PsiElement myNewExpression, PsiArrayInitializerExpression myInitializer) {
        String newText = myNewExpression.getText();
        int initializerIdx = newText.indexOf(myInitializer.getText());
        if (initializerIdx != -1) {
            return newText.substring(0, initializerIdx).trim();
        }
        return newText;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "isAvailable"));
        }
        PsiArrayInitializerExpression myInitializer = (PsiArrayInitializerExpression)startElement;
        PsiVariable myVariable = VariableArrayTypeFix.getVariableLocal(myInitializer);
        return myVariable != null && myVariable.isValid() && myVariable.getManager().isInProject(myVariable) && this.myTargetType.isValid() && myInitializer.isValid();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "invoke"));
        }
        PsiArrayInitializerExpression myInitializer = (PsiArrayInitializerExpression)startElement;
        PsiVariable myVariable = VariableArrayTypeFix.getVariableLocal(myInitializer);
        if (myVariable == null) {
            return;
        }
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(myInitializer);
        if (!FileModificationService.getInstance().prepareFileForWrite(myVariable.getContainingFile())) {
            return;
        }
        if (!this.myTargetType.equals(myVariable.getType())) {
            WriteAction.run(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "lambda$invoke$0"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "lambda$invoke$0"));
                }
                this.fixVariableType(project, file, myVariable);
            });
        }
        if (myNewExpression != null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            WriteAction.run(() -> this.fixArrayInitializer(myInitializer, myNewExpression));
        }
    }

    private void fixVariableType(@NotNull Project project, @NotNull PsiFile file, PsiVariable myVariable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "fixVariableType"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "fixVariableType"));
        }
        myVariable.normalizeDeclaration();
        myVariable.getTypeElement().replace(JavaPsiFacade.getElementFactory(project).createTypeElement(this.myTargetType));
        JavaCodeStyleManager.getInstance(project).shortenClassReferences(myVariable);
        if (!myVariable.getContainingFile().equals(file)) {
            UndoUtil.markPsiFileForUndo(myVariable.getContainingFile());
        }
    }

    private void fixArrayInitializer(PsiArrayInitializerExpression myInitializer, PsiNewExpression myNewExpression) {
        String text2 = "new " + this.myTargetType.getCanonicalText() + "{}";
        PsiNewExpression newExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory(myNewExpression.getProject()).createExpressionFromText(text2, myNewExpression.getParent());
        PsiElement[] children = newExpression.getChildren();
        children[children.length - 1].replace(myInitializer);
        myNewExpression.replace(newExpression);
    }
}

