/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.LambdaIndy;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class DataInterpreter
extends Interpreter<DataValue> {
    private int called = -1;
    private final MethodNode methodNode;
    private final int shift;
    final int rangeStart;
    final int rangeEnd;
    final int arity;
    final EffectQuantum[] effects;

    protected DataInterpreter(MethodNode methodNode) {
        super(393216);
        this.methodNode = methodNode;
        this.shift = (methodNode.access & 8) == 0 ? 2 : 1;
        this.arity = Type.getArgumentTypes((String)methodNode.desc).length;
        this.rangeStart = this.shift;
        this.rangeEnd = this.arity + this.shift;
        this.effects = new EffectQuantum[methodNode.instructions.size()];
    }

    public DataValue newValue(Type type) {
        if (type == null) {
            return DataValue.UnknownDataValue1;
        }
        ++this.called;
        if (type.toString().equals("Lthis;")) {
            return DataValue.ThisDataValue;
        }
        if (this.called < this.rangeEnd && this.rangeStart <= this.called) {
            if (type == Type.VOID_TYPE) {
                return null;
            }
            if (ASMUtils.isReferenceType(type)) {
                return new DataValue.ParameterDataValue(this.called - this.shift);
            }
            return type.getSize() == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
        }
        if (type == Type.VOID_TYPE) {
            return null;
        }
        return type.getSize() == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
    }

    public DataValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 187: {
                return DataValue.LocalDataValue;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                return DataValue.UnknownDataValue2;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                int size = cst instanceof Long || cst instanceof Double ? 2 : 1;
                return size == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
            case 178: {
                int size = Type.getType((String)((FieldInsnNode)insn).desc).getSize();
                return size == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
        }
        return DataValue.UnknownDataValue1;
    }

    public DataValue binaryOperation(AbstractInsnNode insn, DataValue value1, DataValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return DataValue.UnknownDataValue2;
            }
            case 181: {
                Object effectQuantum = value1 == DataValue.ThisDataValue || value1 == DataValue.OwnedDataValue ? EffectQuantum.ThisChangeQuantum : (value1 == DataValue.LocalDataValue ? null : (value1 instanceof DataValue.ParameterDataValue ? new EffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)value1).n) : EffectQuantum.TopEffectQuantum));
                int insnIndex = this.methodNode.instructions.indexOf(insn);
                this.effects[insnIndex] = effectQuantum;
                return DataValue.UnknownDataValue1;
            }
        }
        return DataValue.UnknownDataValue1;
    }

    public DataValue copyOperation(AbstractInsnNode insn, DataValue value) throws AnalyzerException {
        return value;
    }

    public DataValue naryOperation(AbstractInsnNode insn, List<? extends DataValue> values) throws AnalyzerException {
        int insnIndex = this.methodNode.instructions.indexOf(insn);
        int opCode = insn.getOpcode();
        switch (opCode) {
            case 197: {
                return DataValue.LocalDataValue;
            }
            case 186: {
                if (LambdaIndy.from((InvokeDynamicInsnNode)insn) == null) {
                    this.effects[insnIndex] = EffectQuantum.TopEffectQuantum;
                }
                return ASMUtils.getReturnSizeFast(((InvokeDynamicInsnNode)insn).desc) == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                DataValue result;
                boolean stable = opCode == 183 || opCode == 184;
                MethodInsnNode mNode = (MethodInsnNode)insn;
                DataValue[] data = values.toArray(new DataValue[0]);
                Key key = new Key(new Method(mNode.owner, mNode.name, mNode.desc), Direction.Pure, stable);
                EffectQuantum quantum = new EffectQuantum.CallQuantum(key, data, opCode == 184);
                DataValue dataValue = result = ASMUtils.getReturnSizeFast(mNode.desc) == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
                if (HardCodedPurity.isPureMethod(key)) {
                    quantum = null;
                    result = DataValue.LocalDataValue;
                } else if (HardCodedPurity.isThisChangingMethod(key)) {
                    DataValue receiver = ArrayUtil.getFirstElement(data);
                    if (receiver == DataValue.ThisDataValue) {
                        quantum = EffectQuantum.ThisChangeQuantum;
                    } else if (receiver == DataValue.LocalDataValue || receiver == DataValue.OwnedDataValue) {
                        quantum = null;
                    }
                    if (HardCodedPurity.isBuilderChainCall(key)) {
                        result = receiver;
                    }
                }
                this.effects[insnIndex] = quantum;
                return result;
            }
        }
        return null;
    }

    public DataValue unaryOperation(AbstractInsnNode insn, DataValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                return DataValue.UnknownDataValue2;
            }
            case 180: {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                if (value == DataValue.ThisDataValue && HardCodedPurity.isOwnedField(fieldInsn)) {
                    return DataValue.OwnedDataValue;
                }
                return ASMUtils.getSizeFast(fieldInsn.desc) == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
            case 192: {
                return value;
            }
            case 179: {
                int insnIndex = this.methodNode.instructions.indexOf(insn);
                this.effects[insnIndex] = EffectQuantum.TopEffectQuantum;
                return DataValue.UnknownDataValue1;
            }
            case 188: 
            case 189: {
                return DataValue.LocalDataValue;
            }
        }
        return DataValue.UnknownDataValue1;
    }

    public DataValue ternaryOperation(AbstractInsnNode insn, DataValue value1, DataValue value2, DataValue value3) throws AnalyzerException {
        int insnIndex = this.methodNode.instructions.indexOf(insn);
        this.effects[insnIndex] = value1 == DataValue.ThisDataValue || value1 == DataValue.OwnedDataValue ? EffectQuantum.ThisChangeQuantum : (value1 instanceof DataValue.ParameterDataValue ? new EffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)value1).n) : (value1 == DataValue.LocalDataValue ? null : EffectQuantum.TopEffectQuantum));
        return DataValue.UnknownDataValue1;
    }

    public void returnOperation(AbstractInsnNode insn, DataValue value, DataValue expected) throws AnalyzerException {
    }

    public DataValue merge(DataValue v1, DataValue v2) {
        if (v1.equals(v2)) {
            return v1;
        }
        int size = Math.min(v1.getSize(), v2.getSize());
        return size == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
    }
}

