/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

abstract class DataValue
implements Value {
    private final int myHash;
    static final DataValue ThisDataValue = new DataValue(-1){

        public int getSize() {
            return 1;
        }

        public String toString() {
            return "DataValue: this";
        }
    };
    static final DataValue LocalDataValue = new DataValue(-2){

        public int getSize() {
            return 1;
        }

        public String toString() {
            return "DataValue: local";
        }
    };
    static final DataValue OwnedDataValue = new DataValue(-3){

        public int getSize() {
            return 1;
        }

        public String toString() {
            return "DataValue: owned";
        }
    };
    static final DataValue UnknownDataValue1 = new DataValue(-4){

        public int getSize() {
            return 1;
        }

        public String toString() {
            return "DataValue: unknown (1-slot)";
        }
    };
    static final DataValue UnknownDataValue2 = new DataValue(-5){

        public int getSize() {
            return 2;
        }

        public String toString() {
            return "DataValue: unknown (2-slot)";
        }
    };

    DataValue(int hash) {
        this.myHash = hash;
    }

    public final int hashCode() {
        return this.myHash;
    }

    static class ParameterDataValue
    extends DataValue {
        final int n;

        ParameterDataValue(int n) {
            super(n);
            this.n = n;
        }

        public int getSize() {
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterDataValue that = (ParameterDataValue)o;
            return this.n == that.n;
        }

        public String toString() {
            return "DataValue: arg#" + this.n;
        }
    }
}

