/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

interface EffectQuantum {
    public static final EffectQuantum TopEffectQuantum = new EffectQuantum(){

        public String toString() {
            return "Top";
        }
    };
    public static final EffectQuantum ThisChangeQuantum = new EffectQuantum(){

        public String toString() {
            return "Changes this";
        }
    };

    public static final class CallQuantum
    implements EffectQuantum {
        @NotNull
        final Key key;
        @NotNull
        final DataValue[] data;
        final boolean isStatic;

        public CallQuantum(@NotNull Key key, @NotNull DataValue[] data, boolean isStatic) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInspection/bytecodeAnalysis/EffectQuantum$CallQuantum", "<init>"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInspection/bytecodeAnalysis/EffectQuantum$CallQuantum", "<init>"));
            }
            this.key = key;
            this.data = data;
            this.isStatic = isStatic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CallQuantum)) {
                return false;
            }
            CallQuantum quantum = (CallQuantum)o;
            return this.isStatic == quantum.isStatic && this.key.equals(quantum.key) && Arrays.equals(this.data, quantum.data);
        }

        public int hashCode() {
            return 31 * (31 * this.key.hashCode() + Arrays.hashCode(this.data)) + (this.isStatic ? 1 : 0);
        }

        public String toString() {
            return "Calls " + this.key;
        }
    }

    public static final class ParamChangeQuantum
    implements EffectQuantum {
        final int n;

        public ParamChangeQuantum(int n) {
            this.n = n;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParamChangeQuantum)) {
                return false;
            }
            return this.n == ((ParamChangeQuantum)o).n;
        }

        public int hashCode() {
            return this.n;
        }

        public String toString() {
            return "Changes param#" + this.n;
        }
    }
}

