/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import java.util.Arrays;

abstract class HEffectQuantum {
    private final int myHash;
    static final HEffectQuantum TopEffectQuantum = new HEffectQuantum(-1){

        public String toString() {
            return "Top";
        }
    };
    static final HEffectQuantum ThisChangeQuantum = new HEffectQuantum(-2){

        public String toString() {
            return "Changes this";
        }
    };

    HEffectQuantum(int hash) {
        this.myHash = hash;
    }

    public final int hashCode() {
        return this.myHash;
    }

    static class CallQuantum
    extends HEffectQuantum {
        final HKey key;
        final DataValue[] data;
        final boolean isStatic;

        public CallQuantum(HKey key, DataValue[] data, boolean isStatic) {
            super((key.hashCode() * 31 + Arrays.hashCode(data)) * 31 + (isStatic ? 1 : 0));
            this.key = key;
            this.data = data;
            this.isStatic = isStatic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CallQuantum that = (CallQuantum)o;
            if (this.isStatic != that.isStatic) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            return Arrays.equals(this.data, that.data);
        }

        public String toString() {
            return "Calls " + this.key;
        }
    }

    static class ParamChangeQuantum
    extends HEffectQuantum {
        final int n;

        public ParamChangeQuantum(int n) {
            super(n);
            this.n = n;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamChangeQuantum that = (ParamChangeQuantum)o;
            return this.n == that.n;
        }

        public String toString() {
            return "Changes param#" + this.n;
        }
    }
}

