/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.compiler;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.SuppressByJavaCommentFix;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacQuirksInspectionVisitor
extends JavaElementVisitor {
    private static final ElementPattern QUALIFIER_REFERENCE = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiJavaCodeReferenceElement.class)).withSuperParent(2, PsiJavaCodeReferenceElement.class);
    private final ProblemsHolder myHolder;
    private final LanguageLevel myLanguageLevel;
    private final JavaSdkVersion mySdkVersion;

    public JavacQuirksInspectionVisitor(ProblemsHolder holder) {
        this.myHolder = holder;
        this.mySdkVersion = JavaVersionService.getInstance().getJavaSdkVersion(this.myHolder.getFile());
        this.myLanguageLevel = PsiUtil.getLanguageLevel(this.myHolder.getFile());
    }

    @Override
    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        if (PsiUtil.isLanguageLevel7OrHigher(initializer)) {
            return;
        }
        PsiElement lastElement = PsiTreeUtil.skipSiblingsBackward(initializer.getLastChild(), PsiWhiteSpace.class, PsiComment.class);
        if (lastElement != null && PsiUtil.isJavaToken(lastElement, JavaTokenType.COMMA)) {
            String message = InspectionsBundle.message("inspection.compiler.javac.quirks.anno.array.comma.problem", new Object[0]);
            String fixName = InspectionsBundle.message("inspection.compiler.javac.quirks.anno.array.comma.fix", new Object[0]);
            this.myHolder.registerProblem(lastElement, message, QuickFixFactory.getInstance().createDeleteFix(lastElement, fixName));
        }
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression) {
        if (PsiUtil.isLanguageLevel7OrHigher(expression)) {
            return;
        }
        PsiTypeElement type = expression.getCastType();
        if (type != null) {
            type.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceParameterList(PsiReferenceParameterList list) {
                    super.visitReferenceParameterList(list);
                    if (list.getFirstChild() != null && QUALIFIER_REFERENCE.accepts(list)) {
                        String message = InspectionsBundle.message("inspection.compiler.javac.quirks.qualifier.type.args.problem", new Object[0]);
                        String fixName = InspectionsBundle.message("inspection.compiler.javac.quirks.qualifier.type.args.fix", new Object[0]);
                        JavacQuirksInspectionVisitor.this.myHolder.registerProblem((PsiElement)list, message, QuickFixFactory.getInstance().createDeleteFix(list, fixName));
                    }
                }
            });
        }
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
        super.visitAssignmentExpression(assignment);
        PsiType lType = assignment.getLExpression().getType();
        if (lType == null) {
            return;
        }
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return;
        }
        PsiJavaToken operationSign = assignment.getOperationSign();
        this.checkIntersectionType(lType, rExpression.getType(), operationSign);
        IElementType eqOpSign = operationSign.getTokenType();
        IElementType opSign = TypeConversionUtil.convertEQtoOperation(eqOpSign);
        if (opSign == null) {
            return;
        }
        if (JavaSdkVersion.JDK_1_6.equals((Object)JavaVersionService.getInstance().getJavaSdkVersion(assignment)) && PsiType.getJavaLangObject(assignment.getManager(), assignment.getResolveScope()).equals(lType)) {
            String operatorText = operationSign.getText().substring(0, operationSign.getText().length() - 1);
            String message = JavaErrorMessages.message("binary.operator.not.applicable", operatorText, JavaHighlightUtil.formatType(lType), JavaHighlightUtil.formatType(rExpression.getType()));
            this.myHolder.registerProblem((PsiElement)assignment, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new ReplaceAssignmentOperatorWithAssignmentFix(operationSign.getText()));
        }
    }

    @Override
    public void visitVariable(PsiVariable variable) {
        PsiElement assignmentToken;
        super.visitVariable(variable);
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && (assignmentToken = PsiTreeUtil.skipSiblingsBackward(initializer, PsiWhiteSpace.class)) != null) {
            this.checkIntersectionType(variable.getType(), initializer.getType(), assignmentToken);
        }
    }

    private void checkIntersectionType(@NotNull PsiType lType, @Nullable PsiType rType, @NotNull PsiElement elementToHighlight) {
        PsiClass psiClass;
        if (lType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor", "checkIntersectionType"));
        }
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor", "checkIntersectionType"));
        }
        if (rType instanceof PsiIntersectionType && TypeConversionUtil.isAssignable(lType, rType) && (psiClass = PsiUtil.resolveClassInType(lType)) != null && psiClass.hasModifierProperty("final")) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)rType).getConjuncts()) {
                if (TypeConversionUtil.isAssignable(conjunct, lType)) continue;
                String descriptionTemplate = "Though assignment is formal correct, it could lead to ClassCastException at runtime. Expected: '" + lType.getPresentableText() + "', actual: '" + rType.getPresentableText() + "'";
                this.myHolder.registerProblem(elementToHighlight, descriptionTemplate, new LocalQuickFix[0]);
            }
        }
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        super.visitMethodCallExpression(expression);
        if (PsiUtil.isLanguageLevel8OrHigher(expression) && expression.getTypeArguments().length == 0) {
            PsiMethod method;
            PsiExpression[] args = expression.getArgumentList().getExpressions();
            JavaResolveResult resolveResult = expression.resolveMethodGenerics();
            if (resolveResult instanceof MethodCandidateInfo && (method = ((MethodCandidateInfo)resolveResult).getElement()).isVarArgs() && method.hasTypeParameters() && args.length > method.getParameterList().getParametersCount() + 50) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                for (PsiTypeParameter typeParameter : method.getTypeParameters()) {
                    if (PsiTypesUtil.isDenotableType(substitutor.substitute(typeParameter))) continue;
                    return;
                }
                int count = 0;
                for (int i2 = method.getParameterList().getParametersCount(); i2 < args.length; ++i2) {
                    if (!PsiPolyExpressionUtil.isPolyExpression(args[i2]) || ++count <= 50) continue;
                    this.myHolder.registerProblem((PsiElement)expression.getMethodExpression(), "Vararg method call with 50+ poly arguments may cause compilation and analysis slowdown", new MyAddExplicitTypeArgumentsFix());
                    break;
                }
            }
        }
    }

    @Override
    public void visitIdentifier(PsiIdentifier identifier) {
        super.visitIdentifier(identifier);
        if ("_".equals(identifier.getText()) && this.mySdkVersion != null && this.mySdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8) && this.myLanguageLevel.isLessThan(LanguageLevel.JDK_1_9)) {
            String message = JavaErrorMessages.message("underscore.identifier.warn", new Object[0]);
            this.myHolder.registerProblem((PsiElement)identifier, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitBinaryExpression(PsiBinaryExpression expression) {
        super.visitBinaryExpression(expression);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_7) && !this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiType ltype = expression.getLOperand().getType();
            PsiExpression rOperand = expression.getROperand();
            if (rOperand != null) {
                PsiType rtype = rOperand.getType();
                if (ltype != null && rtype != null && ltype.equalsToText("java.lang.Object") ^ rtype.equalsToText("java.lang.Object") && TypeConversionUtil.isPrimitiveAndNotNull(ltype) ^ TypeConversionUtil.isPrimitiveAndNotNull(rtype) && TypeConversionUtil.isBinaryOperatorApplicable(expression.getOperationTokenType(), ltype, rtype, false) && TypeConversionUtil.areTypesConvertible(rtype, ltype)) {
                    this.myHolder.registerProblem((PsiElement)expression.getOperationSign(), "Comparision between Object and primitive is illegal and is accepted in java 7 only", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        }
    }

    private static class MyAddExplicitTypeArgumentsFix
    implements LocalQuickFix {
        private MyAddExplicitTypeArgumentsFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("add.type.arguments.single.argument.text", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$MyAddExplicitTypeArgumentsFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement parent;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$MyAddExplicitTypeArgumentsFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$MyAddExplicitTypeArgumentsFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiReferenceExpression && (parent = element.getParent()) instanceof PsiMethodCallExpression) {
                PsiExpression withArgs = AddTypeArgumentsFix.addTypeArguments((PsiExpression)parent, null);
                if (withArgs == null) {
                    return;
                }
                element = WriteAction.compute(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$MyAddExplicitTypeArgumentsFix", "lambda$applyFix$0"));
                    }
                    return CodeStyleManager.getInstance(project).reformat(parent.replace(withArgs));
                });
                new SuppressByJavaCommentFix("RedundantTypeArguments (explicit type arguments speedup compilation and analysis time)").invoke(project, element);
            }
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }
    }

    private static class ReplaceAssignmentOperatorWithAssignmentFix
    implements LocalQuickFix {
        private final String myOperationSign;

        public ReplaceAssignmentOperatorWithAssignmentFix(String operationSign) {
            this.myOperationSign = operationSign;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace ''" + this.myOperationSign + "'' with ''=''";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$ReplaceAssignmentOperatorWithAssignmentFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Operator Assignment with Assignment" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$ReplaceAssignmentOperatorWithAssignmentFix", "getFamilyName"));
            }
            return "Replace Operator Assignment with Assignment";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$ReplaceAssignmentOperatorWithAssignmentFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/compiler/JavacQuirksInspectionVisitor$ReplaceAssignmentOperatorWithAssignmentFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiAssignmentExpression) {
                PsiReplacementUtil.replaceOperatorAssignmentWithAssignmentExpression((PsiAssignmentExpression)element);
            }
        }
    }
}

