/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodContract {
    MethodContract() {
    }

    public abstract ValueConstraint getReturnValue();

    @NotNull
    DfaValue getDfaReturnValue(DfaValueFactory factory, DfaValue defaultResult) {
        switch (this.getReturnValue()) {
            case NULL_VALUE: {
                DfaConstValue dfaConstValue = factory.getConstFactory().getNull();
                if (dfaConstValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodContract", "getDfaReturnValue"));
                }
                return dfaConstValue;
            }
            case NOT_NULL_VALUE: {
                DfaValue dfaValue = defaultResult instanceof DfaTypeValue ? ((DfaTypeValue)defaultResult).withNullness(Nullness.NOT_NULL) : DfaUnknownValue.getInstance();
                if (dfaValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodContract", "getDfaReturnValue"));
                }
                return dfaValue;
            }
            case TRUE_VALUE: {
                DfaConstValue dfaConstValue = factory.getConstFactory().getTrue();
                if (dfaConstValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodContract", "getDfaReturnValue"));
                }
                return dfaConstValue;
            }
            case FALSE_VALUE: {
                DfaConstValue dfaConstValue = factory.getConstFactory().getFalse();
                if (dfaConstValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodContract", "getDfaReturnValue"));
                }
                return dfaConstValue;
            }
            case THROW_EXCEPTION: {
                DfaConstValue dfaConstValue = factory.getConstFactory().getContractFail();
                if (dfaConstValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodContract", "getDfaReturnValue"));
                }
                return dfaConstValue;
            }
        }
        DfaValue dfaValue = defaultResult;
        if (dfaValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodContract", "getDfaReturnValue"));
        }
        return dfaValue;
    }

    boolean isTrivial() {
        return this.getConditions().isEmpty();
    }

    abstract String getArgumentsPresentation();

    abstract List<ContractValue> getConditions();

    public String toString() {
        return this.getArgumentsPresentation() + " -> " + (Object)((Object)this.getReturnValue());
    }

    public static MethodContract trivialContract(final ValueConstraint value) {
        return new MethodContract(){

            @Override
            public ValueConstraint getReturnValue() {
                return value;
            }

            @Override
            String getArgumentsPresentation() {
                return "(any)";
            }

            @Override
            List<ContractValue> getConditions() {
                return Collections.emptyList();
            }
        };
    }

    public static MethodContract singleConditionContract(ContractValue left, DfaRelationValue.RelationType relationType, ContractValue right, final ValueConstraint returnValue) {
        final ContractValue condition = ContractValue.condition(left, relationType, right);
        return new MethodContract(){

            @Override
            public ValueConstraint getReturnValue() {
                return returnValue;
            }

            @Override
            String getArgumentsPresentation() {
                return condition.toString();
            }

            @Override
            List<ContractValue> getConditions() {
                return Collections.singletonList(condition);
            }
        };
    }

    public static enum ValueConstraint {
        ANY_VALUE("_"),
        NULL_VALUE("null"),
        NOT_NULL_VALUE("!null"),
        TRUE_VALUE("true"),
        FALSE_VALUE("false"),
        THROW_EXCEPTION("fail");

        private final String myPresentableName;

        private ValueConstraint(String presentableName) {
            this.myPresentableName = presentableName;
        }

        @Nullable
        DfaConstValue getComparisonValue(DfaValueFactory factory) {
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                return factory.getConstFactory().getNull();
            }
            if (this == TRUE_VALUE || this == FALSE_VALUE) {
                return factory.getConstFactory().getTrue();
            }
            return null;
        }

        boolean shouldUseNonEqComparison() {
            return this == NOT_NULL_VALUE || this == FALSE_VALUE;
        }

        public ContractValue getCondition(int argumentIndex) {
            ContractValue left;
            if (this == NULL_VALUE || this == NOT_NULL_VALUE) {
                left = ContractValue.nullValue();
            } else if (this == TRUE_VALUE || this == FALSE_VALUE) {
                left = ContractValue.booleanValue(true);
            } else {
                return ContractValue.booleanValue(true);
            }
            return ContractValue.condition(left, DfaRelationValue.RelationType.equivalence(!this.shouldUseNonEqComparison()), ContractValue.argument(argumentIndex));
        }

        public String toString() {
            return this.myPresentableName;
        }
    }
}

