/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextEditorBasedStructureViewModel
implements StructureViewModel,
ProvidingTreeModel {
    private final Editor myEditor;
    private final PsiFile myPsiFile;
    private final List<FileEditorPositionListener> myListeners;
    private List<ModelListener> myModelListeners;
    private CaretListener myEditorCaretListener;
    private Disposable myEditorCaretListenerDisposable;

    protected TextEditorBasedStructureViewModel(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "<init>"));
        }
        this(PsiEditorUtil.Service.getInstance().findEditorByPsiElement(psiFile), psiFile);
    }

    protected TextEditorBasedStructureViewModel(Editor editor) {
        this(editor, null);
    }

    protected TextEditorBasedStructureViewModel(Editor editor, PsiFile file) {
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myModelListeners = new ArrayList<ModelListener>(2);
        this.myEditor = editor;
        this.myPsiFile = file;
        this.myEditorCaretListener = new CaretListener(){

            @Override
            public void caretPositionChanged(CaretEvent e) {
                if (e.getEditor().equals(TextEditorBasedStructureViewModel.this.myEditor)) {
                    for (FileEditorPositionListener listener : TextEditorBasedStructureViewModel.this.myListeners) {
                        listener.onCurrentElementChanged();
                    }
                }
            }
        };
    }

    @Override
    public final void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "addEditorPositionListener"));
        }
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            this.myEditorCaretListenerDisposable = Disposer.newDisposable();
            EditorFactory.getInstance().getEventMulticaster().addCaretListener(this.myEditorCaretListener, this.myEditorCaretListenerDisposable);
        }
        this.myListeners.add(listener);
    }

    @Override
    public final void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "removeEditorPositionListener"));
        }
        this.myListeners.remove(listener);
        if (this.myEditor != null && this.myListeners.isEmpty()) {
            Disposer.dispose(this.myEditorCaretListenerDisposable);
            this.myEditorCaretListenerDisposable = null;
        }
    }

    @Override
    public void dispose() {
        if (this.myEditorCaretListenerDisposable != null) {
            Disposer.dispose(this.myEditorCaretListenerDisposable);
        }
        this.myModelListeners.clear();
    }

    public void fireModelUpdate() {
        for (ModelListener listener : this.myModelListeners) {
            listener.onModelChanged();
        }
    }

    @Override
    public boolean shouldEnterElement(Object element) {
        return false;
    }

    @Override
    public Object getCurrentEditorElement() {
        if (this.myEditor == null) {
            return null;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        PsiFile file = this.getPsiFile();
        return this.findAcceptableElement(file.getViewProvider().findElementAt(offset, file.getLanguage()));
    }

    @Nullable
    protected Object findAcceptableElement(PsiElement element) {
        while (element != null && !(element instanceof PsiFile)) {
            if (this.isSuitable(element)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    protected PsiFile getPsiFile() {
        return this.myPsiFile;
    }

    protected boolean isSuitable(PsiElement element) {
        Class[] suitableClasses;
        if (element == null) {
            return false;
        }
        for (Class suitableClass : suitableClasses = this.getSuitableClasses()) {
            if (!ReflectionUtil.isAssignable(suitableClass, element.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "addModelListener"));
        }
        this.myModelListeners.add(modelListener);
    }

    @Override
    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelListener", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "removeModelListener"));
        }
        this.myModelListeners.remove(modelListener);
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        if (ArrayUtil.EMPTY_CLASS_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "getSuitableClasses"));
        }
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @Override
    @NotNull
    public Grouper[] getGroupers() {
        if (Grouper.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "getGroupers"));
        }
        return Grouper.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public Sorter[] getSorters() {
        if (Sorter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "getSorters"));
        }
        return Sorter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public Filter[] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "getFilters"));
        }
        return Filter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        List<NodeProvider> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "getNodeProviders"));
        }
        return list;
    }

    @Override
    public boolean isEnabled(@NotNull NodeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/ide/structureView/TextEditorBasedStructureViewModel", "isEnabled"));
        }
        return false;
    }
}

