/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathSaveItem;
import com.intellij.openapi.module.impl.SaveItem;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleManagerImpl
extends ModuleManager
implements Disposable,
PersistentStateComponent<Element>,
ProjectComponent {
    public static final String COMPONENT_NAME = "ProjectModuleManager";
    public static final String ELEMENT_MODULES = "modules";
    public static final String ELEMENT_MODULE = "module";
    public static final String ATTRIBUTE_FILEURL = "fileurl";
    public static final String ATTRIBUTE_FILEPATH = "filepath";
    public static final String ATTRIBUTE_GROUP = "group";
    public static final String IML_EXTENSION = ".iml";
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.module.impl.ModuleManagerImpl");
    private static final Key<String> DISPOSED_MODULE_NAME = Key.create("DisposedNeverAddedModuleName");
    private static final String MODULE_GROUP_SEPARATOR = "/";
    protected final Project myProject;
    protected final MessageBus myMessageBus;
    protected volatile ModuleModelImpl myModuleModel;
    private LinkedHashSet<ModulePath> myModulePathsToLoad;
    private final Set<ModulePath> myFailedModulePaths;
    private double myProgressStep;
    private volatile Module[] myCachedSortedModules;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance(project);
    }

    public ModuleManagerImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/ModuleManagerImpl", "<init>"));
        }
        this.myModuleModel = new ModuleModelImpl(this);
        this.myFailedModulePaths = new THashSet();
        this.myProject = project;
        this.myMessageBus = project.getMessageBus();
    }

    @Override
    public void projectOpened() {
        this.fireModulesAdded();
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectOpened();
        }
    }

    @Override
    public void projectClosed() {
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectClosed();
        }
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
    }

    @Override
    public void dispose() {
        this.myModuleModel.disposeModel();
    }

    @Override
    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e);
        return e;
    }

    @Override
    public void loadState(Element state) {
        boolean isFirstLoadState = this.myModulePathsToLoad == null;
        this.myModulePathsToLoad = ModuleManagerImpl.getPathsToModuleFiles(state);
        if (isFirstLoadState) {
            return;
        }
        ModifiableModuleModel model = this.getModifiableModel();
        Module[] existingModules = model.getModules();
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        THashMap modulePathMap = new THashMap(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            modulePathMap.put(modulePath.getPath(), modulePath);
        }
        for (Module existingModule : existingModules) {
            Object[] group;
            ModulePath correspondingPath = (ModulePath)modulePathMap.remove(existingModule.getModuleFilePath());
            if (correspondingPath == null) {
                model.disposeModule(existingModule);
                continue;
            }
            this.myModulePathsToLoad.remove(correspondingPath);
            String groupStr = correspondingPath.getGroup();
            Object[] objectArray = group = groupStr == null ? null : groupStr.split(MODULE_GROUP_SEPARATOR);
            if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
            groupInterner.setModuleGroupPath(model, existingModule, (String[])group);
        }
        this.loadModules((ModuleModelImpl)model);
        ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        this.myModulePathsToLoad.clear();
    }

    @NotNull
    public static LinkedHashSet<ModulePath> getPathsToModuleFiles(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getPathsToModuleFiles"));
        }
        LinkedHashSet<ModulePath> paths = new LinkedHashSet<ModulePath>();
        Element modules = element.getChild(ELEMENT_MODULES);
        if (modules != null) {
            for (Element moduleElement : modules.getChildren(ELEMENT_MODULE)) {
                String fileUrlValue = moduleElement.getAttributeValue(ATTRIBUTE_FILEURL);
                String filepath = fileUrlValue == null ? moduleElement.getAttributeValue(ATTRIBUTE_FILEPATH) : VirtualFileManager.extractPath(fileUrlValue);
                paths.add(new ModulePath(filepath.replace('/', File.separatorChar), moduleElement.getAttributeValue(ATTRIBUTE_GROUP)));
            }
        }
        LinkedHashSet<ModulePath> linkedHashSet = paths;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getPathsToModuleFiles"));
        }
        return linkedHashSet;
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModules"));
        }
        this.myFailedModulePaths.clear();
        if (this.myModulePathsToLoad == null || this.myModulePathsToLoad.isEmpty()) {
            return;
        }
        this.myFailedModulePaths.addAll(this.myModulePathsToLoad);
        ProgressIndicator globalIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        ProgressIndicator progressIndicator = this.myProject.isDefault() || globalIndicator == null ? new EmptyProgressIndicator() : globalIndicator;
        progressIndicator.setText("Loading modules...");
        progressIndicator.setText2("");
        SmartList<Module> modulesWithUnknownTypes = new SmartList<Module>();
        List<ModuleLoadingErrorDescription> errors = Collections.synchronizedList(new ArrayList());
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        ExecutorService service = AppExecutorUtil.createBoundedApplicationPoolExecutor("modules loader", JobSchedulerImpl.CORES_COUNT);
        ArrayList<Pair<Object, ModulePath>> tasks = new ArrayList<Pair<Object, ModulePath>>();
        THashSet paths = new THashSet();
        boolean parallel = Registry.is("parallel.modules.loading");
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            if (progressIndicator.isCanceled()) break;
            try {
                String path = modulePath.getPath();
                if (!paths.add(path)) continue;
                if (!parallel) {
                    tasks.add(Pair.create(null, modulePath));
                    continue;
                }
                ThrowableComputable computable = moduleModel.loadModuleInternal(path);
                Future<Module> future = service.submit(() -> {
                    progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
                    try {
                        return (Module)computable.compute();
                    }
                    catch (IOException e) {
                        this.reportError(errors, modulePath, e);
                    }
                    catch (Exception e) {
                        LOG.error(e);
                    }
                    return null;
                });
                tasks.add(Pair.create(future, modulePath));
            }
            catch (IOException e) {
                this.reportError(errors, modulePath, e);
            }
        }
        for (Pair pair : tasks) {
            if (progressIndicator.isCanceled()) break;
            try {
                ModulePath modulePath;
                String groupPathString;
                Module module;
                if (parallel) {
                    module = (Module)((Future)pair.first).get();
                } else {
                    module = (Module)moduleModel.loadModuleInternal(((ModulePath)pair.second).getPath()).compute();
                    progressIndicator.setFraction(progressIndicator.getFraction() + this.myProgressStep);
                }
                if (module == null) continue;
                if (this.isUnknownModuleType(module)) {
                    modulesWithUnknownTypes.add(module);
                }
                if ((groupPathString = (modulePath = (ModulePath)pair.second).getGroup()) != null) {
                    groupInterner.setModuleGroupPath(moduleModel, module, groupPathString.split(MODULE_GROUP_SEPARATOR));
                }
                this.myFailedModulePaths.remove(modulePath);
            }
            catch (IOException e) {
                this.reportError(errors, (ModulePath)pair.second, e);
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        service.shutdown();
        progressIndicator.checkCanceled();
        Application app = ApplicationManager.getApplication();
        if (app.isInternal() || app.isEAP() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            THashMap tHashMap = new THashMap();
            for (Module module : moduleModel.getModules()) {
                for (String url : ModuleRootManager.getInstance(module).getContentRootUrls()) {
                    Module oldModule = tHashMap.put(url, module);
                    if (oldModule == null) continue;
                    LOG.error("Module '" + module.getName() + "' and module '" + oldModule.getName() + "' have the same content root: " + url);
                }
            }
        }
        this.onModuleLoadErrors(moduleModel, errors);
        this.showUnknownModuleTypeNotification(modulesWithUnknownTypes);
    }

    private void reportError(List<ModuleLoadingErrorDescription> errors, ModulePath modulePath, Exception e) {
        errors.add(new ModuleLoadingErrorDescription(ProjectBundle.message("module.cannot.load.error", modulePath.getPath(), e.getMessage()), modulePath, this));
    }

    public int getModulePathsCount() {
        return this.myModulePathsToLoad == null ? 0 : this.myModulePathsToLoad.size();
    }

    public void setProgressStep(double step) {
        this.myProgressStep = step;
    }

    protected boolean isUnknownModuleType(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isUnknownModuleType"));
        }
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<Module> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/openapi/module/impl/ModuleManagerImpl", "showUnknownModuleTypeNotification"));
        }
    }

    protected void fireModuleAdded(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleAdded"));
        }
        this.myMessageBus.syncPublisher(ProjectTopics.MODULES).moduleAdded(this.myProject, module);
    }

    protected void fireModuleRemoved(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRemoved"));
        }
        this.myMessageBus.syncPublisher(ProjectTopics.MODULES).moduleRemoved(this.myProject, module);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireBeforeModuleRemoved"));
        }
        this.myMessageBus.syncPublisher(ProjectTopics.MODULES).beforeModuleRemoved(this.myProject, module);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules, @NotNull Map<Module, String> oldNames) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULES, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModulesRenamed"));
        }
        if (oldNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNames", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModulesRenamed"));
        }
        if (!modules.isEmpty()) {
            this.myMessageBus.syncPublisher(ProjectTopics.MODULES).modulesRenamed(this.myProject, modules, module -> {
                if (oldNames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNames", "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModulesRenamed$2"));
                }
                return (String)oldNames.get(module);
            });
        }
    }

    private void onModuleLoadErrors(@NotNull ModuleModelImpl moduleModel, @NotNull List<ModuleLoadingErrorDescription> errors) {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/module/impl/ModuleManagerImpl", "onModuleLoadErrors"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/module/impl/ModuleManagerImpl", "onModuleLoadErrors"));
        }
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$502(moduleModel, null);
        for (ModuleLoadingErrorDescription error : errors) {
            ModuleEx module = moduleModel.getModuleByFilePath(error.getModulePath().getPath());
            if (module == null) continue;
            moduleModel.myModules.remove(module.getName());
            ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose(module), module.getDisposed());
        }
        this.fireModuleLoadErrors(errors);
    }

    protected void fireModuleLoadErrors(@NotNull List<ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleLoadErrors"));
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    public void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "removeFailedModulePath"));
        }
        this.myFailedModulePaths.remove(modulePath);
    }

    @Override
    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ModuleModelImpl moduleModelImpl = new ModuleModelImpl(this.myModuleModel);
        if (moduleModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModifiableModel"));
        }
        return moduleModelImpl;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/impl/ModuleManagerImpl", "writeExternal"));
        }
        Module[] collection = this.getModules();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.length + this.myFailedModulePaths.size());
        for (Module module : collection) {
            sorted.add(new ModuleSaveItem(module));
        }
        for (ModulePath modulePath : this.myFailedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        if (!sorted.isEmpty()) {
            Collections.sort(sorted, Comparator.comparing(SaveItem::getModuleName));
            Element modules = new Element(ELEMENT_MODULES);
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules);
            }
            element.addContent(modules);
        }
    }

    @Override
    @NotNull
    public Module newModule(@NotNull String filePath, String moduleTypeId) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "newModule"));
        }
        return module2;
    }

    @Override
    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "loadModule"));
        }
        return module2;
    }

    @Override
    public void disposeModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "disposeModule"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$disposeModule$4"));
            }
            ModifiableModuleModel modifiableModel = this.getModifiableModel();
            modifiableModel.disposeModule(module);
            modifiableModel.commit();
        });
    }

    @Override
    @NotNull
    public Module[] getModules() {
        if (this.myModuleModel.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModules"));
        }
        return moduleArray;
    }

    @Override
    @NotNull
    public Module[] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedSortedModules == null) {
            this.myCachedSortedModules = this.myModuleModel.getSortedModules();
        }
        if (this.myCachedSortedModules == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getSortedModules"));
        }
        return this.myCachedSortedModules;
    }

    @Override
    public Module findModuleByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl", "findModuleByName"));
        }
        return this.myModuleModel.findModuleByName(name);
    }

    @Override
    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        if (this.myCachedModuleComparator == null) {
            this.myCachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator<Module> comparator = this.myCachedModuleComparator;
        if (comparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleDependencyComparator"));
        }
        return comparator;
    }

    protected void deliverPendingEvents() {
    }

    @Override
    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph = this.moduleGraph(true);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @Override
    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph graph = this.myModuleModel.moduleGraph(includeTests);
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "moduleGraph"));
        }
        return graph;
    }

    @Override
    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        SmartList<Module> result = new SmartList<Module>();
        for (Module aModule : this.getModules()) {
            if (!ModuleManagerImpl.isModuleDependsOn(aModule, module)) continue;
            result.add(aModule);
        }
        SmartList<Module> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleDependentModules"));
        }
        return smartList;
    }

    @Override
    public boolean isModuleDependent(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        if (onModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onModule", "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependent"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ModuleManagerImpl.isModuleDependsOn(module, onModule);
    }

    private static boolean isModuleDependsOn(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependsOn"));
        }
        if (onModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onModule", "com/intellij/openapi/module/impl/ModuleManagerImpl", "isModuleDependsOn"));
        }
        return ModuleRootManager.getInstance(module).isDependsOn(onModule);
    }

    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.getModules()) {
            this.fireModuleAddedInWriteAction((ModuleEx)module);
        }
    }

    protected void fireModuleAddedInWriteAction(@NotNull ModuleEx module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleAddedInWriteAction"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModuleAddedInWriteAction$5"));
            }
            if (!module.isLoaded()) {
                module.moduleAdded();
                this.fireModuleAdded(module);
            }
        });
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model, Runnable runnable) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/module/impl/ModuleManagerImpl", "commitModelWithRunnable"));
        }
        ((ModuleModelImpl)model).commitWithRunnable(runnable);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1, @NotNull VirtualFile var2) throws IOException;

    private void commitModel(ModuleModelImpl moduleModel, Runnable runnable) {
        THashSet removedModules;
        THashSet addedModules;
        ModuleModelImpl.access$502(this.myModuleModel, null);
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<Module> oldModules = Arrays.asList(this.myModuleModel.getModules());
        THashSet newModules = Arrays.asList(moduleModel.getModules());
        if (oldModules.isEmpty()) {
            addedModules = newModules;
            removedModules = Collections.emptyList();
        } else {
            addedModules = new THashSet(newModules);
            addedModules.removeAll(oldModules);
            removedModules = new THashSet(oldModules);
            removedModules.removeAll((Collection<?>)newModules);
        }
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(() -> this.lambda$commitModel$6((Collection)removedModules, moduleModel, oldModules, runnable, (Collection)addedModules), false, true);
    }

    public void fireModuleRenamedByVfsEvent(@NotNull Module module, @NotNull String oldName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/module/impl/ModuleManagerImpl", "fireModuleRenamedByVfsEvent"));
        }
        Module moduleInMap = this.myModuleModel.myModules.remove(oldName);
        LOG.assertTrue(moduleInMap == null || moduleInMap == module);
        this.myModuleModel.myModules.put(module.getName(), module);
        this.incModificationCount();
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(() -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModuleRenamedByVfsEvent$7"));
            }
            if (oldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/module/impl/ModuleManagerImpl", "lambda$fireModuleRenamedByVfsEvent$7"));
            }
            this.fireModulesRenamed(Collections.singletonList(module), Collections.singletonMap(module, oldName));
        }, false, true);
    }

    @Override
    public String[] getModuleGroupPath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl", "getModuleGroupPath"));
        }
        return this.myModuleModel.getModuleGroupPath(module);
    }

    @Override
    public boolean hasModuleGroups() {
        return this.myModuleModel.hasModuleGroups();
    }

    public void setModuleGroupPath(Module module, String[] groupPath) {
        this.myModuleModel.setModuleGroupPath(module, groupPath);
    }

    private /* synthetic */ void lambda$commitModel$6(Collection removedModules, ModuleModelImpl moduleModel, Collection oldModules, Runnable runnable, Collection addedModules) {
        for (Object removedModule : removedModules) {
            this.fireBeforeModuleRemoved((Module)removedModule);
            this.cleanCachedStuff();
        }
        if (!moduleModel.myModulesToDispose.isEmpty()) {
            ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
            neverAddedModules.removeAll(oldModules);
            for (Module neverAddedModule : neverAddedModules) {
                neverAddedModule.putUserData(DISPOSED_MODULE_NAME, neverAddedModule.getName());
                Disposer.dispose(neverAddedModule);
            }
        }
        if (runnable != null) {
            runnable.run();
        }
        Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
        Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
        modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
        ArrayList<Module> modules = new ArrayList<Module>();
        HashMap<Module, String> oldNames = ContainerUtil.newHashMap();
        for (Module module : modulesToBeRenamed) {
            oldNames.put(module, module.getName());
            moduleModel.myModules.remove(module.getName());
            modules.add(module);
            ((ModuleEx)module).rename((String)modulesToNewNamesMap.get(module), true);
            moduleModel.myModules.put(module.getName(), module);
        }
        moduleModel.myIsWritable = false;
        this.myModuleModel = moduleModel;
        for (Module module : removedModules) {
            this.fireModuleRemoved(module);
            this.cleanCachedStuff();
            Disposer.dispose(module);
            this.cleanCachedStuff();
        }
        for (Module addedModule : addedModules) {
            ((ModuleEx)addedModule).moduleAdded();
            this.cleanCachedStuff();
            this.fireModuleAdded(addedModule);
            this.cleanCachedStuff();
        }
        this.cleanCachedStuff();
        this.fireModulesRenamed(modules, oldNames);
        this.cleanCachedStuff();
    }

    static class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myModules;
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose;
        private final Map<Module, String> myModuleToNewName;
        private final Map<String, Module> myNewNameToModule;
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;
        private final ModuleManagerImpl myManager;

        private ModuleModelImpl(@NotNull ModuleManagerImpl manager) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "<init>"));
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap<Module, String>();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap<String, Module>();
            this.myManager = manager;
            this.myIsWritable = false;
        }

        private ModuleModelImpl(@NotNull ModuleModelImpl that) {
            if (that == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "<init>"));
            }
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new com.intellij.util.containers.HashMap<Module, String>();
            this.myNewNameToModule = new com.intellij.util.containers.HashMap<String, Module>();
            this.myManager = that.myManager;
            this.myModules.putAll(that.myModules);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new THashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, "Attempt to modify committed ModifiableModuleModel");
        }

        @Override
        @NotNull
        public Module[] getModules() {
            Module[] cache = this.myModulesCache;
            if (cache == null) {
                Collection<Module> modules = this.myModules.values();
                cache = modules.toArray(new Module[modules.size()]);
                this.myModulesCache = cache;
            }
            if (cache == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModules"));
            }
            return cache;
        }

        @NotNull
        private Module[] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            if (allModules == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getSortedModules"));
            }
            return allModules;
        }

        @Override
        public void renameModule(@NotNull Module module, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "renameModule"));
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module));
            if (module.getName().equals(newName)) {
                this.myModuleToNewName.remove(module);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module, newName);
                this.myNewNameToModule.put(newName, module);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectBundle.message("module.already.exists.error", newName), newName);
            }
        }

        @Override
        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleToBeRenamed"));
            }
            return this.myNewNameToModule.get(newName);
        }

        private Module getModuleByNewName(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleByNewName"));
            }
            Module moduleToBeRenamed = this.getModuleToBeRenamed(newName);
            if (moduleToBeRenamed != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        @Override
        public String getNewName(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getNewName"));
            }
            return this.myModuleToNewName.get(module);
        }

        @Override
        @NotNull
        public Module newModule(@NotNull String filePath, String moduleTypeId) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            Module module = this.newModule(filePath, moduleTypeId, null);
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return module;
        }

        @Override
        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            if (moduleTypeId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleTypeId", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            this.assertWritable();
            filePath = FileUtil.toSystemIndependentName(ModuleModelImpl.resolveShortWindowsName(filePath));
            ModuleEx module = this.getModuleByFilePath(filePath);
            if (module == null) {
                ModuleEx newModule = module = this.myManager.createModule(filePath);
                this.initModule(module, filePath, null, () -> {
                    if (moduleTypeId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleTypeId", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "lambda$newModule$0"));
                    }
                    newModule.setOption("type", moduleTypeId);
                    if (options != null) {
                        for (Map.Entry option : options.entrySet()) {
                            newModule.setOption((String)option.getKey(), (String)option.getValue());
                        }
                    }
                });
            }
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "newModule"));
            }
            return moduleEx;
        }

        @NotNull
        private static String resolveShortWindowsName(@NotNull String filePath) {
            String string;
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
            }
            try {
                string = FileUtil.resolveShortWindowsName(filePath);
            }
            catch (IOException ignored) {
                String string2 = filePath;
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
                }
                return string2;
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "resolveShortWindowsName"));
            }
            return string;
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull String filePath) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "getModuleByFilePath"));
            }
            for (Module module : this.getModules()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module.getModuleFilePath().equals(filePath) : module.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module;
            }
            return null;
        }

        @Override
        @NotNull
        public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
            Module module;
            block7: {
                if (filePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
                }
                this.assertWritable();
                ModuleEx module2 = this.getModuleByFilePath(filePath);
                if (module2 == null) break block7;
                ModuleEx moduleEx = module2;
                if (moduleEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
                }
                return moduleEx;
            }
            try {
                module = this.loadModuleInternal(filePath).compute();
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectBundle.message("module.corrupted.file.error", FileUtil.toSystemDependentName(filePath), e.getMessage()), e);
            }
            if (module == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModule"));
            }
            return module;
        }

        @NotNull
        private ThrowableComputable<Module, IOException> loadModuleInternal(@NotNull String filePath) throws IOException {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModuleInternal"));
            }
            String resolvedPath = ModuleModelImpl.resolveShortWindowsName(filePath);
            Ref ref = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> ref.set(StandardFileSystems.local().refreshAndFindFileByPath(resolvedPath)));
            VirtualFile moduleFile = (VirtualFile)ref.get();
            if (moduleFile == null || !moduleFile.exists()) {
                throw new FileNotFoundException(ProjectBundle.message("module.file.does.not.exist.error", resolvedPath));
            }
            String path = moduleFile.getPath();
            ApplicationManager.getApplication().invokeAndWait(() -> moduleFile.refresh(false, false));
            ThrowableComputable<Module, IOException> throwableComputable = () -> ReadAction.compute(() -> {
                if (this.myManager.myProject.isDisposed()) {
                    return null;
                }
                ModuleEx result = this.myManager.createAndLoadModule(path, moduleFile);
                this.initModule(result, path, moduleFile, null);
                return result;
            });
            if (throwableComputable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "loadModuleInternal"));
            }
            return throwableComputable;
        }

        private void initModule(@NotNull ModuleEx module, @NotNull String path, @Nullable VirtualFile file, @Nullable Runnable beforeComponentCreation) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "initModule"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "initModule"));
            }
            module.init(path, file, beforeComponentCreation);
            this.myModulesCache = null;
            this.myModules.put(module.getName(), module);
        }

        @Override
        public void disposeModule(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "disposeModule"));
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module.getName()) != null) {
                this.myModulesToDispose.add(module);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module);
            }
        }

        @Override
        public Module findModuleByName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "findModuleByName"));
            }
            Module module = this.myModules.get(name);
            if (module != null && !module.isDisposed()) {
                return module;
            }
            return null;
        }

        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder<Module> builder = new DFSTBuilder<Module>(this.moduleGraph(true));
            return builder.comparator();
        }

        private Graph<Module> moduleGraph(final boolean includeTests) {
            return GraphGenerator.generate(CachingSemiGraph.cache(new InboundSemiGraph<Module>(){

                @Override
                public Collection<Module> getNodes() {
                    return myModules.values();
                }

                @Override
                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance(m).getDependencies(includeTests);
                    return Arrays.asList(dependentModules).iterator();
                }
            }));
        }

        @Override
        public void commit() {
            ModifiableModelCommitter.multiCommit(Collections.emptyList(), (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(Runnable runnable) {
            this.myManager.commitModel(this, runnable);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        @Override
        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            THashSet existingModules = new THashSet(Arrays.asList(this.myManager.myModuleModel.getModules()));
            for (Module thisModule : this.getModules()) {
                if (existingModules.contains(thisModule)) continue;
                Disposer.dispose(thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (existingModules.contains(moduleToDispose)) continue;
                Disposer.dispose(moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        @Override
        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            return !this.myModules.equals(this.myManager.myModuleModel.myModules) || !Comparing.equal(this.myManager.myModuleModel.myModuleGroupPath, this.myModuleGroupPath);
        }

        private void disposeModel() {
            Module[] modules = this.getModules();
            this.myModulesCache = null;
            for (Module module : modules) {
                Disposer.dispose(module);
            }
            this.myModules.clear();
            this.myModuleGroupPath = null;
        }

        @Override
        public String[] getModuleGroupPath(Module module) {
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module);
        }

        @Override
        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        @Override
        public void setModuleGroupPath(@NotNull Module module, @Nullable(value="null means remove") String[] groupPath) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl", "setModuleGroupPath"));
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new THashMap();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module);
            } else {
                this.myModuleGroupPath.put(module, groupPath);
            }
        }

        static /* synthetic */ Module[] access$502(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }
    }

    private class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;

        public ModuleSaveItem(Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "<init>"));
            }
            this.myModule = module;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "getModuleName"));
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = ModuleManagerImpl.this.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join(groupPath, ModuleManagerImpl.MODULE_GROUP_SEPARATOR) : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myModule.getModuleFilePath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem", "getModuleFilePath"));
            }
            return string;
        }
    }

    private static class ModuleGroupInterner {
        private final StringInterner groups = new StringInterner();
        private final Map<String[], String[]> paths = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<String[]>(){

            public int computeHashCode(String[] object) {
                return Arrays.hashCode(object);
            }

            public boolean equals(String[] o1, String[] o2) {
                return Arrays.equals(o1, o2);
            }
        });

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model, @NotNull Module module, @Nullable String[] group) {
            String[] cached;
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner", "setModuleGroupPath"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ModuleManagerImpl.ELEMENT_MODULE, "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner", "setModuleGroupPath"));
            }
            String[] stringArray = cached = group == null ? null : this.paths.get(group);
            if (cached == null && group != null) {
                cached = new String[group.length];
                for (int i2 = 0; i2 < group.length; ++i2) {
                    String g = group[i2];
                    cached[i2] = this.groups.intern(g);
                }
                this.paths.put(cached, cached);
            }
            model.setModuleGroupPath(module, cached);
        }
    }
}

