/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectLocator {
    static final Key<Project> PREFERRED_PROJECT_KEY = Key.create("PREFERRED_PROJECT_KEY");

    public static ProjectLocator getInstance() {
        return ServiceManager.getService(ProjectLocator.class);
    }

    @Nullable
    public abstract Project guessProjectForFile(@Nullable VirtualFile var1);

    @NotNull
    public abstract Collection<Project> getProjectsForFile(VirtualFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithPreferredProject(@NotNull VirtualFile file, @NotNull Project preferredProject, @NotNull ThrowableComputable<T, E> action) throws E {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/ProjectLocator", "computeWithPreferredProject"));
        }
        if (preferredProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferredProject", "com/intellij/openapi/project/ProjectLocator", "computeWithPreferredProject"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/project/ProjectLocator", "computeWithPreferredProject"));
        }
        file.putUserData(PREFERRED_PROJECT_KEY, preferredProject);
        try {
            T t = action.compute();
            return t;
        }
        finally {
            file.putUserData(PREFERRED_PROJECT_KEY, null);
        }
    }
}

