/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public abstract class TestSourcesFilter {
    public static final ExtensionPointName<TestSourcesFilter> EP_NAME = ExtensionPointName.create("com.intellij.testSourcesFilter");

    public static boolean isTestSources(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/TestSourcesFilter", "isTestSources"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/TestSourcesFilter", "isTestSources"));
        }
        for (TestSourcesFilter filter : EP_NAME.getExtensions()) {
            if (!filter.isTestSource(file, project)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isTestSource(@NotNull VirtualFile var1, @NotNull Project var2);
}

