/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class InstructionKey
implements Comparable<InstructionKey> {
    private final int myOffset;
    private final int[] myCallStack;

    private InstructionKey(int offset, @NotNull int[] callStack) {
        if (callStack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callStack", "com/intellij/psi/controlFlow/InstructionKey", "<init>"));
        }
        this.myOffset = offset;
        this.myCallStack = callStack;
    }

    @NotNull
    static InstructionKey create(int offset) {
        InstructionKey instructionKey = new InstructionKey(offset, ArrayUtil.EMPTY_INT_ARRAY);
        if (instructionKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/InstructionKey", "create"));
        }
        return instructionKey;
    }

    InstructionKey next(int nextOffset) {
        return new InstructionKey(nextOffset, this.myCallStack);
    }

    InstructionKey push(int nextOffset, int returnOffset) {
        if (this.myCallStack.length > 100) {
            throw new OverflowException(this.myOffset);
        }
        int[] nextStack = ArrayUtil.append(this.myCallStack, returnOffset);
        return new InstructionKey(nextOffset, nextStack);
    }

    InstructionKey pop(int overriddenOffset) {
        int returnOffset = this.myCallStack[this.myCallStack.length - 1];
        int[] nextStack = ArrayUtil.realloc(this.myCallStack, this.myCallStack.length - 1);
        int nextOffset = overriddenOffset != 0 ? overriddenOffset : returnOffset;
        return new InstructionKey(nextOffset, nextStack);
    }

    int getOffset() {
        return this.myOffset;
    }

    @NotNull
    int[] getCallStack() {
        if (this.myCallStack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/InstructionKey", "getCallStack"));
        }
        return this.myCallStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstructionKey key = (InstructionKey)o;
        return this.myOffset == key.myOffset && Arrays.equals(this.myCallStack, key.myCallStack);
    }

    public int hashCode() {
        return 31 * this.myOffset + Arrays.hashCode(this.myCallStack);
    }

    public String toString() {
        if (this.myCallStack.length == 0) {
            return String.valueOf(this.myOffset);
        }
        StringBuilder s = new StringBuilder();
        for (int offset : this.myCallStack) {
            if (s.length() != 0) {
                s.append(',');
            }
            s.append(offset);
        }
        return this.myOffset + "[" + s + "]";
    }

    @Override
    public int compareTo(@NotNull InstructionKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/controlFlow/InstructionKey", "compareTo"));
        }
        int c = this.myOffset - key.myOffset;
        if (c != 0) {
            return c;
        }
        int len = Math.min(this.myCallStack.length, key.myCallStack.length);
        for (int i2 = 0; i2 < len; ++i2) {
            c = this.myCallStack[i2] - key.myCallStack[i2];
            if (c == 0) continue;
            return c;
        }
        c = this.myCallStack.length - key.myCallStack.length;
        return c;
    }

    static class OverflowException
    extends RuntimeException {
        public OverflowException(int offset) {
            super("Instruction key overflow at offset " + offset);
        }
    }
}

