/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ConcurrentMostlySingularMultiMap<K, V>
extends MostlySingularMultiMap<K, V> {
    @Override
    @NotNull
    protected Map<K, Object> createMap() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "createMap"));
        }
        return concurrentMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void add(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "add"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "add"));
        }
        ConcurrentMap map = (ConcurrentMap)this.myMap;
        while (true) {
            Object current;
            if ((current = map.get(key)) == null) {
                if (ConcurrencyUtil.cacheOrGet(map, key, value) != value) continue;
                return;
            }
            if (current instanceof MostlySingularMultiMap.ValueList) {
                MostlySingularMultiMap.ValueList curList = (MostlySingularMultiMap.ValueList)current;
                MostlySingularMultiMap.ValueList newList = new MostlySingularMultiMap.ValueList(curList.size() + 1);
                newList.addAll(curList);
                newList.add(value);
                if (!map.replace(key, curList, newList)) continue;
                return;
            }
            MostlySingularMultiMap.ValueList newList = new MostlySingularMultiMap.ValueList(2);
            newList.add(current);
            newList.add(value);
            if (map.replace(key, current, newList)) return;
        }
    }

    @Override
    public void compact() {
    }

    public boolean replace(@NotNull K key, @NotNull Collection<V> expectedValue, @NotNull Collection<V> newValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "replace"));
        }
        if (expectedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedValue", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/util/containers/ConcurrentMostlySingularMultiMap", "replace"));
        }
        ConcurrentMap map = (ConcurrentMap)this.myMap;
        MostlySingularMultiMap.ValueList<V> newValueToPut = newValue.isEmpty() ? null : (newValue.size() == 1 ? newValue.iterator().next() : new MostlySingularMultiMap.ValueList<V>(newValue));
        Object oldValue = map.get(key);
        List oldCollection = this.rawValueToCollection(oldValue);
        if (!oldCollection.equals(expectedValue)) {
            return false;
        }
        if (oldValue == null) {
            return newValueToPut == null || map.putIfAbsent(key, newValueToPut) == null;
        }
        if (newValueToPut == null) {
            return map.remove(key, oldValue);
        }
        return map.replace(key, oldValue, newValueToPut);
    }
}

