/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class StatementExtractor {
    private static final Node EMPTY = new Node(null){

        @Override
        public Node prepend(Node node) {
            return node;
        }

        @Override
        public String toString() {
            return "";
        }
    };

    @NotNull
    public static PsiStatement[] generateStatements(List<PsiExpression> expressionsToKeep, PsiExpression root) {
        String statementsCode = StatementExtractor.generateStatementsText(expressionsToKeep, root);
        if (statementsCode.isEmpty()) {
            if (PsiStatement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "generateStatements"));
            }
            return PsiStatement.EMPTY_ARRAY;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(root.getProject());
        PsiCodeBlock codeBlock = factory.createCodeBlockFromText("{" + statementsCode + "}", root);
        PsiStatement[] psiStatementArray = codeBlock.getStatements();
        if (psiStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/StatementExtractor", "generateStatements"));
        }
        return psiStatementArray;
    }

    public static String generateStatementsText(List<PsiExpression> expressionsToKeep, PsiExpression root) {
        Node result = (Node)StreamEx.ofReversed(expressionsToKeep).map(expression -> StatementExtractor.createNode(expression, root)).foldLeft((Object)EMPTY, Node::prepend);
        return result.toString();
    }

    private static Node createNode(@NotNull PsiExpression expression, @NotNull PsiExpression root) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/StatementExtractor", "createNode"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/siyeh/ig/psiutils/StatementExtractor", "createNode"));
        }
        Node result = new Expr(expression);
        while (expression != root) {
            PsiExpression parent;
            block15: {
                block12: {
                    boolean and;
                    PsiPolyadicExpression polyadic;
                    block14: {
                        IElementType type;
                        block13: {
                            PsiElement parentElement = expression.getParent();
                            if (parentElement instanceof PsiExpressionList) {
                                parentElement = parentElement.getParent();
                            }
                            if ((parent = ObjectUtils.tryCast(parentElement, PsiExpression.class)) == null) {
                                throw new IllegalStateException(expression.getText() + ": expected to have expression parent; root = " + root.getText());
                            }
                            if (!(parent instanceof PsiPolyadicExpression)) break block12;
                            polyadic = (PsiPolyadicExpression)parent;
                            type = polyadic.getOperationTokenType();
                            if (type != JavaTokenType.ANDAND) break block13;
                            and = true;
                            break block14;
                        }
                        if (type != JavaTokenType.OROR) break block15;
                        and = false;
                    }
                    Object[] operands = polyadic.getOperands();
                    int index = ArrayUtil.indexOf(operands, expression);
                    if (index == 0) break block15;
                    result = new Cond(parent, parent, index, and ? result : EMPTY, and ? EMPTY : result);
                }
                if (parent instanceof PsiConditionalExpression) {
                    PsiConditionalExpression ternary = (PsiConditionalExpression)parent;
                    if (expression == ternary.getThenExpression()) {
                        result = new Cond(ternary, ternary.getCondition(), -1, result, EMPTY);
                    } else if (expression == ternary.getElseExpression()) {
                        result = new Cond(ternary, ternary.getCondition(), -1, EMPTY, result);
                    }
                }
            }
            expression = parent;
        }
        return result;
    }

    private static class Cons
    extends Node {
        @NotNull
        private final Node myHead;
        @NotNull
        private final Node myTail;

        private Cons(@NotNull Node head, @NotNull Node tail) {
            if (head == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "head", "com/siyeh/ig/psiutils/StatementExtractor$Cons", "<init>"));
            }
            if (tail == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tail", "com/siyeh/ig/psiutils/StatementExtractor$Cons", "<init>"));
            }
            super(head.myAnchor);
            assert (!(head instanceof Cons));
            this.myHead = head;
            this.myTail = tail;
        }

        @Override
        public Node prepend(Node node) {
            if (node.myAnchor == null) {
                return this;
            }
            if (PsiTreeUtil.isAncestor(this.myHead.myAnchor, node.myAnchor, false)) {
                Node newHead = this.myHead.prepend(node);
                return new Cons(newHead, this.myTail);
            }
            return new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myHead.toString() + this.myTail;
        }
    }

    private static class Expr
    extends Node {
        private Expr(@NotNull PsiExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/StatementExtractor$Expr", "<init>"));
            }
            super(expression);
        }

        @Override
        public Node prepend(Node node) {
            return node.myAnchor == null ? this : new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myAnchor.getText() + ";";
        }
    }

    private static class Cond
    extends Node {
        @NotNull
        private final PsiExpression myCondition;
        @NotNull
        private final Node myThenBranch;
        @NotNull
        private final Node myElseBranch;
        private final int myLimit;

        private Cond(@NotNull PsiExpression anchor, @NotNull PsiExpression condition, int limit, @NotNull Node thenBranch, @NotNull Node elseBranch) {
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/siyeh/ig/psiutils/StatementExtractor$Cond", "<init>"));
            }
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/siyeh/ig/psiutils/StatementExtractor$Cond", "<init>"));
            }
            if (thenBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenBranch", "com/siyeh/ig/psiutils/StatementExtractor$Cond", "<init>"));
            }
            if (elseBranch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elseBranch", "com/siyeh/ig/psiutils/StatementExtractor$Cond", "<init>"));
            }
            super(anchor);
            this.myCondition = condition;
            this.myLimit = limit;
            assert (limit < 0 || condition instanceof PsiPolyadicExpression);
            this.myThenBranch = thenBranch;
            this.myElseBranch = elseBranch;
        }

        private String getCondition(boolean invert) {
            if (this.myLimit < 0) {
                return invert ? BoolUtils.getNegatedExpressionText(this.myCondition) : this.myCondition.getText();
            }
            PsiPolyadicExpression condition = (PsiPolyadicExpression)this.myCondition;
            Object[] operands = condition.getOperands();
            String joiner = condition.getOperationTokenType() == JavaTokenType.ANDAND != invert ? "&&" : "||";
            return StreamEx.of((Object[])operands, (int)0, (int)this.myLimit).map(invert ? BoolUtils::getNegatedExpressionText : PsiElement::getText).joining((CharSequence)joiner);
        }

        @Override
        public String toString() {
            if (this.myThenBranch == EMPTY) {
                return "if(" + this.getCondition(true) + ") {" + this.myElseBranch + "}";
            }
            return "if(" + this.getCondition(false) + ") {" + this.myThenBranch + "}" + (this.myElseBranch == EMPTY ? "" : "else {" + this.myElseBranch + "}");
        }

        @Override
        public Node prepend(Node node) {
            PsiExpression thatAnchor = node.myAnchor;
            if (thatAnchor == null) {
                return this;
            }
            if (thatAnchor == this.myAnchor) {
                assert (node instanceof Cond);
                Cond cond = (Cond)node;
                assert (this.myCondition == cond.myCondition);
                if (this.myLimit == cond.myLimit) {
                    return new Cond(this.myAnchor, this.myCondition, this.myLimit, this.myThenBranch.prepend(cond.myThenBranch), this.myElseBranch.prepend(cond.myElseBranch));
                }
                assert (this.myLimit > cond.myLimit);
                return this;
            }
            if (PsiTreeUtil.isAncestor(this.myCondition, thatAnchor, false)) {
                return this;
            }
            return new Cons(node, this);
        }
    }

    private static abstract class Node {
        final PsiExpression myAnchor;

        protected Node(PsiExpression anchor) {
            this.myAnchor = anchor;
        }

        public abstract Node prepend(Node var1);

        public abstract String toString();
    }
}

